/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.BlockUtils;
import com.ma.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ComponentFelledOak
extends Component {
    public ComponentFelledOak(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        ComponentApplicationResult result = ComponentApplicationResult.FAIL;
        if (!target.isBlock()) {
            return result;
        }
        PlayerEntity player = source.isPlayerCaster() ? source.getPlayer() : FakePlayerFactory.getMinecraft((ServerWorld)context.getWorld());
        BlockPos sourceBlock = target.getBlock();
        Pair<Boolean, Boolean> captureRedirect = InventoryUtilities.getCaptureAndRedirect(player);
        if (BlockUtils.isLogOrLeaf(context.getWorld().func_180495_p(sourceBlock)) == BlockUtils.TreeBlockTypes.LOG) {
            while (BlockUtils.isLogOrLeaf(context.getWorld().func_180495_p(sourceBlock)) == BlockUtils.TreeBlockTypes.LOG && sourceBlock.func_177956_o() > 0) {
                sourceBlock = sourceBlock.func_177977_b();
            }
            sourceBlock = sourceBlock.func_177984_a();
            Pair<Boolean, List<ItemStack>> treeResult = BlockUtils.breakTreeRecursive(player, (World)context.getWorld(), sourceBlock, (Boolean)captureRedirect.getFirst());
            if (((Boolean)treeResult.getFirst()).booleanValue()) {
                if (source.isPlayerCaster()) {
                    InventoryUtilities.redirectCaptureOrDrop(player, (World)context.getWorld(), (List)treeResult.getSecond(), (Boolean)captureRedirect.getSecond());
                }
                result = ComponentApplicationResult.SUCCESS;
            }
        }
        return result;
    }

    @Override
    public boolean targetsBlocks() {
        return true;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public float initialComplexity() {
        return 15.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

