/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.BlockUtils;
import com.ma.tools.EnchantmentUtils;
import com.ma.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class ComponentExchange
extends Component {
    public ComponentExchange(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!source.isPlayerCaster() || target.isEntity()) {
            return ComponentApplicationResult.FAIL;
        }
        if (context.getWorld().func_175623_d(target.getBlock())) {
            return ComponentApplicationResult.FAIL;
        }
        int harvestLevel = (int)modificationData.getValue(Attribute.MAGNITUDE);
        if (!BlockUtils.canDestroyBlock(source.getCaster(), (World)context.getWorld(), target.getBlock(), harvestLevel, ToolType.AXE, ToolType.HOE, ToolType.PICKAXE, ToolType.SHOVEL)) {
            return ComponentApplicationResult.FAIL;
        }
        CompoundNBT nbt = context.getMeta();
        Block searchBlock = null;
        Item searchItem = null;
        if (!nbt.func_74764_b("blockType")) {
            ItemStack offhandStack = source.getPlayer().func_184586_b(source.getHand() == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND);
            if (!(offhandStack.func_77973_b() instanceof BlockItem)) {
                return ComponentApplicationResult.FAIL;
            }
            if (!(offhandStack.func_77973_b() instanceof BlockItem)) {
                return ComponentApplicationResult.FAIL;
            }
            searchBlock = ((BlockItem)offhandStack.func_77973_b()).func_179223_d();
            searchItem = offhandStack.func_77973_b();
            nbt.func_74778_a("blockType", offhandStack.func_77973_b().getRegistryName().toString());
        } else {
            ResourceLocation rLoc = new ResourceLocation(nbt.func_74779_i("blockType"));
            searchItem = (Item)ForgeRegistries.ITEMS.getValue(rLoc);
            if (searchItem != null && searchItem instanceof BlockItem) {
                searchBlock = ((BlockItem)searchItem).func_179223_d();
            }
        }
        if (searchBlock == null || searchItem == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (!searchBlock.func_176223_P().func_196955_c((IWorldReader)context.getWorld(), target.getBlock())) {
            return ComponentApplicationResult.FAIL;
        }
        if (!source.getPlayer().func_184812_l_() && InventoryUtilities.removeSingleItemFromInventory(searchItem.getRegistryName(), (IInventory)source.getPlayer().field_71071_by).func_190926_b()) {
            return ComponentApplicationResult.FAIL;
        }
        boolean silkTouch = EnchantmentUtils.getSilkTouch(source.getPlayer());
        int fortune_level = 0;
        if (!silkTouch) {
            fortune_level = EnchantmentUtils.getFortuneLevel(source.getPlayer());
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Pair<Boolean, Boolean> captureRedirect = InventoryUtilities.getCaptureAndRedirect(source.getPlayer());
        drops.addAll(BlockUtils.destroyBlockCaptureDrops(source.getCaster(), (World)context.getWorld(), target.getBlock(), silkTouch, fortune_level, harvestLevel, ToolType.AXE, ToolType.HOE, ToolType.PICKAXE, ToolType.SHOVEL));
        if (source.isPlayerCaster()) {
            InventoryUtilities.redirectCaptureOrDrop(source.getPlayer(), (World)context.getWorld(), drops, (Boolean)captureRedirect.getSecond());
        }
        context.getWorld().func_180501_a(target.getBlock(), searchBlock.func_176223_P(), 3);
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public float initialComplexity() {
        return 2.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public class PlaceBlockInfo {
        public final Block block;
        public final BlockPos position;
        public final World world;

        public PlaceBlockInfo(Block block, BlockPos position, World world) {
            this.block = block;
            this.position = position;
            this.world = world;
        }
    }
}

