/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells;

import com.ma.Registries;
import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.ISpellInteractibleBlock;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.entities.ISpellInteractibleEntity;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.ISpellHelper;
import com.ma.api.spells.SpellCastingResult;
import com.ma.api.spells.SpellCastingResultCode;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.adjusters.SpellAdjustingContext;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.base.SpellBlacklistResult;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.EntityInit;
import com.ma.entities.utility.EntityResidualMagic;
import com.ma.entities.utility.EntitySpellFX;
import com.ma.events.EventDispatcher;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedSpellEffect;
import com.ma.inventory.InventoryRitualKit;
import com.ma.items.ItemInit;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import com.ma.spells.NameProcessors;
import com.ma.spells.SpellAdjuster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;

public class SpellCaster
implements ISpellHelper {
    private static ArrayList<SpellAdjuster> _adjusters = new ArrayList();
    private static ArrayList<Item> _cooldownItems = new ArrayList();

    public static SpellCastingResult PlayerCast(ItemStack stack, PlayerEntity caster, Hand hand, Vector3d casterPosition, Vector3d casterLook, World world, boolean consumeMana) {
        IPlayerMagic magic = null;
        IPlayerProgression progression = null;
        if (caster.func_70660_b((Effect)EffectInit.SILENCE.get()) != null) {
            return SpellCastingResultCode.SILENCED.createResult();
        }
        magic = (IPlayerMagic)caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        progression = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (magic == null || progression == null) {
            return SpellCastingResultCode.CAPABILITY_MISSING.createResult();
        }
        if (!magic.isMagicUnlocked() && consumeMana) {
            if (!world.field_72995_K) {
                caster.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.no-magic"), Util.field_240973_b_);
            }
            return SpellCastingResultCode.NOT_UNLOCKED_MAGIC.createResult();
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.func_190925_c("spell"));
        if (!recipe.isValid()) {
            return SpellCastingResultCode.INVALID_RECIPE.createResult();
        }
        if (consumeMana && !caster.func_184812_l_() && recipe.getTier(world) > progression.getTier()) {
            if (!world.field_72995_K) {
                caster.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.tier-fail"), Util.field_240973_b_);
            }
            return SpellCastingResultCode.INSUFFICIENT_TIER.createResult();
        }
        if (consumeMana && !caster.func_184812_l_() && recipe.getComplexity() > (float)progression.getTierMaxComplexity()) {
            if (!world.field_72995_K) {
                caster.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.complexity-fail"), Util.field_240973_b_);
            }
            return SpellCastingResultCode.TOO_COMPLEX.createResult();
        }
        if (consumeMana && !caster.func_184812_l_() && !SpellCaster.checkReagents(caster, recipe)) {
            if (!world.field_72995_K) {
                caster.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.reagents-missing"), Util.field_240973_b_);
            }
            return SpellCastingResultCode.MISSING_REAGENTS.createResult();
        }
        if (!EventDispatcher.DispatchSpellCast(recipe, caster)) {
            return SpellCastingResultCode.CANCELED_BY_EVENT.createResult();
        }
        SpellCaster.applyAdjusters(stack, caster, recipe, SpellCastStage.CASTING);
        if (!world.field_72995_K && recipe.isMysterious()) {
            recipe.setMysterious(false);
            recipe.writeToNBT(stack.func_196082_o());
        }
        float manaCost = recipe.getManaCost();
        if (!caster.func_184812_l_() && magic.getCastingResource().getAmount() < manaCost) {
            return SpellCastingResultCode.NOT_ENOUGH_MANA.createResult();
        }
        SpellCastingResult subCast = SpellCaster.Affect(stack, recipe, world, new SpellSource((LivingEntity)caster, hand));
        if (!subCast.getCode().isConsideredSuccess()) {
            return subCast;
        }
        if (consumeMana) {
            if (!recipe.canFactionCraft(progression)) {
                recipe.usedByPlayer(caster);
            }
            if (((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isChanneled()) {
                magic.getCastingResource().consume(manaCost * 0.25f);
            } else {
                magic.getCastingResource().consume(manaCost);
                SpellCaster.AddAffinityAndMagicXP(recipe, caster);
            }
            SpellCaster.consumeReagents(caster, recipe, subCast);
        }
        return subCast;
    }

    public static SpellCastingResult Affect(@Nullable ItemStack stack, ISpellDefinition recipe, World world, SpellSource source) {
        EntityResidualMagic e;
        if (!recipe.isValid()) {
            return SpellCastingResultCode.INVALID_RECIPE.createResult();
        }
        Shape shape = recipe.getShape().getPart();
        if (shape == null || recipe.countComponents() == 0) {
            return SpellCastingResultCode.INVALID_RECIPE.createResult();
        }
        SpellBlacklistResult result = shape.canBeCastAt(world, source.getOrigin());
        if (result != SpellBlacklistResult.ALLOWED) {
            if (source.isPlayerCaster() && world.field_72995_K) {
                source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent(result.getMessageTranslationKey().toString()), Util.field_240973_b_);
            }
            return SpellCastingResultCode.BLOCKED_BY_CONFIG.createResult();
        }
        for (int i = 0; i < recipe.countComponents(); ++i) {
            result = recipe.getComponent(i).getPart().canBeCastAt(world, source.getOrigin());
            if (result == SpellBlacklistResult.ALLOWED) continue;
            if (source.isPlayerCaster() && world.field_72995_K) {
                source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent(result.getMessageTranslationKey().toString()), Util.field_240973_b_);
            }
            return SpellCastingResultCode.BLOCKED_BY_CONFIG.createResult();
        }
        List<SpellTarget> targets = shape.Target(source, world, recipe.getShape(), recipe);
        if (targets.size() <= 1 && targets.get(0) == SpellTarget.NONE) {
            return SpellCastingResultCode.NO_TARGET.createResult();
        }
        if (!world.field_72995_K && !((ServerWorld)world).func_73046_m().func_71219_W() && recipe.isHarmful()) {
            MutableBoolean pvpdenied = new MutableBoolean(false);
            recipe.iterateComponents(c -> {
                if (((Component)c.getPart()).getUseTag() == SpellPartTags.HARMFUL) {
                    pvpdenied.setTrue();
                }
            });
            if (pvpdenied.booleanValue()) {
                targets = targets.stream().filter(t -> !t.isEntity() || !(t.getEntity() instanceof PlayerEntity) || t.getEntity() == source.getCaster()).collect(Collectors.toList());
            }
            if (targets.size() == 0) {
                return SpellCastingResultCode.NO_TARGET.createResult();
            }
        }
        SoundEvent spellSound = SFX.Spell.Cast.ForAffinity(recipe.getHighestAffinity());
        if (stack != null) {
            spellSound = NameProcessors.checkAndOverrideSound(recipe, stack.func_200301_q().getString(), spellSound);
        }
        world.func_217384_a(null, (Entity)source.getCaster(), spellSound, SoundCategory.PLAYERS, 0.01f, 1.0f);
        if (!world.field_72995_K && (e = (EntityResidualMagic)((EntityType)EntityInit.RESIDUAL_MAGIC.get()).func_220331_a((ServerWorld)world, stack, source.getPlayer(), new BlockPos(source.getOrigin()).func_177982_a(0, 2, 0), SpawnReason.TRIGGERED, true, true)) != null) {
            e.setResidualPower(recipe.getManaCost());
        }
        if (shape.spawnsTargetEntity()) {
            HashMap<Component, ComponentApplicationResult> targetResult = new HashMap<Component, ComponentApplicationResult>();
            for (IModifiedSpellPart<Component> c2 : recipe.getComponents()) {
                targetResult.put(c2.getPart(), ComponentApplicationResult.TARGET_ENTITY_SPAWNED);
            }
            if (shape.isChanneled()) {
                return SpellCastingResultCode.CHANNEL.createResult(targetResult);
            }
            return SpellCastingResultCode.SUCCESS.createResult(targetResult);
        }
        if (targets.size() == 1) {
            boolean cancel;
            SpellTarget target2 = targets.get(0);
            BlockState state = world.func_180495_p(target2.getBlock());
            if (state.func_177230_c() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.func_177230_c()).onHitBySpell(world, target2.getBlock(), recipe)) {
                return SpellCastingResultCode.SPELL_INTERACTIBLE_BLOCK_HIT.createResult();
            }
            if (target2.isEntity() && target2.getEntity() instanceof ISpellInteractibleEntity && (cancel = ((ISpellInteractibleEntity)target2.getEntity()).onShapeTarget(recipe, source))) {
                return SpellCastingResultCode.SPELL_INTERACTIBLE_ENTITY_HIT.createResult();
            }
        }
        HashMap<Component, ComponentApplicationResult> mergedComponentResults = new HashMap<Component, ComponentApplicationResult>();
        if (!world.field_72995_K) {
            SpellContext context = new SpellContext((ServerWorld)world, recipe);
            targets.forEach(target -> {
                HashMap<Component, ComponentApplicationResult> componentResults = SpellCaster.ApplyComponents(recipe, source, target, context);
                SpellCaster.mergeComponentResults(mergedComponentResults, componentResults);
                if (componentResults.values().stream().anyMatch(c -> c == ComponentApplicationResult.SUCCESS || c == ComponentApplicationResult.DELAYED)) {
                    SpellCaster.spawnClientFX(world, target.getPosition(), source, recipe);
                }
            });
        }
        return mergedComponentResults.values().stream().anyMatch(c -> c == ComponentApplicationResult.SUCCESS || c == ComponentApplicationResult.DELAYED) ? SpellCastingResultCode.SUCCESS.createResult(mergedComponentResults) : SpellCastingResultCode.NO_TARGET.createResult(mergedComponentResults);
    }

    private static void mergeComponentResults(HashMap<Component, ComponentApplicationResult> mainList, HashMap<Component, ComponentApplicationResult> toMerge) {
        toMerge.forEach((c, r) -> {
            if (mainList.containsKey(c)) {
                if (r.is_success) {
                    mainList.put((Component)c, (ComponentApplicationResult)((Object)r));
                }
            } else {
                mainList.put((Component)c, (ComponentApplicationResult)((Object)r));
            }
        });
    }

    public static HashMap<Component, ComponentApplicationResult> ApplyComponents(ISpellDefinition recipe, SpellSource source, SpellTarget target, SpellContext context) {
        HashMap<Component, ComponentApplicationResult> results = new HashMap<Component, ComponentApplicationResult>();
        if (!context.getWorld().func_73046_m().func_71219_W() && recipe.isHarmful()) {
            MutableBoolean pvpdenied = new MutableBoolean(false);
            recipe.iterateComponents(c -> {
                if (((Component)c.getPart()).getUseTag() == SpellPartTags.HARMFUL) {
                    pvpdenied.setTrue();
                }
            });
            if (pvpdenied.booleanValue() && target.isEntity() && target.getEntity() instanceof PlayerEntity && target.getEntity() != source.getCaster()) {
                recipe.iterateComponents(c -> results.put((Component)c.getPart(), ComponentApplicationResult.FAIL));
                return results;
            }
        }
        recipe.iterateComponents(c -> {
            int delayInSeconds = (int)c.getValue(Attribute.DELAY) * 20;
            if (target.isBlock() && ((Component)c.getPart()).targetsBlocks() && !context.hasBlockBeenAffected((Component)c.getPart(), target.getBlock())) {
                if (delayInSeconds == 0) {
                    results.put((Component)c.getPart(), ((Component)c.getPart()).ApplyEffect(source, target, (IModifiedSpellPart<Component>)c, context));
                    context.addAffectedBlock((Component)c.getPart(), target.getBlock());
                } else {
                    DelayedEventQueue.pushEvent((World)context.getWorld(), new TimedDelayedSpellEffect("" + context.getWorld().func_82737_E(), delayInSeconds, source, target, (IModifiedSpellPart<Component>)c, context));
                    results.put((Component)c.getPart(), ComponentApplicationResult.DELAYED);
                }
            } else if (target.isEntity() && ((Component)c.getPart()).targetsEntities() && !context.hasEntityBeenAffected((Component)c.getPart(), target.getEntity())) {
                if (delayInSeconds == 0) {
                    results.put((Component)c.getPart(), ((Component)c.getPart()).ApplyEffect(source, target, (IModifiedSpellPart<Component>)c, context));
                    context.addAffectedEntity((Component)c.getPart(), target.getEntity());
                } else {
                    DelayedEventQueue.pushEvent((World)context.getWorld(), new TimedDelayedSpellEffect("" + context.getWorld().func_82737_E(), delayInSeconds, source, target, (IModifiedSpellPart<Component>)c, context));
                    results.put((Component)c.getPart(), ComponentApplicationResult.DELAYED);
                }
            }
        });
        ServerWorld world = context.getWorld();
        if (!world.field_72995_K && !recipe.getShape().getPart().isChanneled() && results.values().stream().anyMatch(c -> c == ComponentApplicationResult.SUCCESS || c == ComponentApplicationResult.DELAYED)) {
            SpellCaster.spawnClientFX((World)context.getWorld(), target.getPosition(), source, recipe);
        }
        return results;
    }

    public static void AddAffinityAndMagicXP(SpellRecipe recipe, PlayerEntity caster) {
        SpellCaster.AddAffinityAndMagicXP(recipe, caster, -1);
    }

    public static void AddAffinityAndMagicXP(SpellRecipe recipe, PlayerEntity caster, int channelDuration) {
        if (caster == null || recipe == null || !recipe.isValid()) {
            return;
        }
        caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
            caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> {
                int xp = (int)recipe.getComplexity();
                float affinity = 0.1f;
                if (channelDuration > -1) {
                    int maxChannelTime = ((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).maxChannelTime(recipe.getShape());
                    xp = (int)((float)xp * ((float)channelDuration / (float)Math.max(1, maxChannelTime)));
                    affinity *= (float)channelDuration / (float)Math.max(1, maxChannelTime);
                }
                magic.addMagicXP(xp, caster, (IPlayerProgression)progression);
                if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BELT_AFFINITY_LOCK.get(), (LivingEntity)caster).isPresent()) {
                    for (Map.Entry<Affinity, Float> e : recipe.getAffinity().entrySet()) {
                        magic.shiftAffinity(e.getKey(), affinity * e.getValue().floatValue());
                    }
                }
            });
            if (!caster.field_70170_p.field_72995_K) {
                caster.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(rote -> {
                    if (rote.addRoteXP((ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart(), channelDuration == -1 ? 1 : channelDuration)) {
                        SpellCaster.sendRoteMessage(caster, (ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart());
                    }
                    recipe.iterateComponents(c -> {
                        float bonus = 1.0f + magic.getAffinityDepth(((Component)c.getPart()).getAffinity()) / 100.0f;
                        float detriment = 1.0f - magic.getAffinityDepth(((Component)c.getPart()).getAffinity().getOpposite()) / 100.0f;
                        int xp = (int)Math.max(Math.ceil(1.0f * bonus * detriment), 0.0);
                        if (rote.addRoteXP((ISpellComponent)c.getPart(), xp)) {
                            SpellCaster.sendRoteMessage(caster, (ISpellComponent)c.getPart());
                        }
                    });
                    for (int i = 0; i < recipe.countModifiers(); ++i) {
                        if (!rote.addRoteXP(recipe.getModifier(i))) continue;
                        SpellCaster.sendRoteMessage(caster, recipe.getModifier(i));
                    }
                });
            }
        });
    }

    private static void sendRoteMessage(PlayerEntity caster, ISpellComponent component) {
        IFormattableTextComponent translatedComponentName = new TranslationTextComponent(component.getRegistryName().toString()).func_240699_a_(TextFormatting.GOLD);
        IFormattableTextComponent roteMessage = translatedComponentName.func_230529_a_((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.spell_part_rote"));
        caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SFX.Event.Player.SPELL_CREATED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        caster.func_145747_a((ITextComponent)roteMessage, Util.field_240973_b_);
    }

    public static void spawnClientFX(World world, Vector3d position, SpellSource source, ISpellDefinition recipe) {
        if (!world.func_195588_v(new BlockPos(position))) {
            return;
        }
        EntitySpellFX fx = new EntitySpellFX((EntityType)EntityInit.SPELL_FX.get(), world);
        fx.setCasterUUID(source.getPlayer());
        fx.setRecipe(recipe);
        fx.func_226286_f_(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        world.func_217376_c((Entity)fx);
    }

    public static float getComplexity(ItemStack spellStack) {
        return SpellCaster.getComplexity(spellStack.func_190925_c("spell"));
    }

    public static float getComplexity(CompoundNBT spellNBT) {
        SpellRecipe recipe = SpellRecipe.fromNBT(spellNBT);
        if (recipe == null || !recipe.isValid()) {
            return 0.0f;
        }
        return recipe.getComplexity();
    }

    public static void registerAdjuster(Predicate<SpellAdjustingContext> executeCheck, BiConsumer<ISpellDefinition, PlayerEntity> adjuster) {
        _adjusters.add(new SpellAdjuster(executeCheck, adjuster));
    }

    public static void applyAdjusters(ItemStack stack, @Nullable PlayerEntity caster, SpellRecipe recipe, SpellCastStage stage) {
        for (SpellAdjuster adjuster : _adjusters) {
            if (!adjuster.check(stage, stack, caster)) continue;
            adjuster.modify(recipe, caster);
        }
    }

    public static boolean consumeChanneledMana(PlayerEntity player, ItemStack stack) {
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return false;
        }
        SpellRecipe spell = SpellRecipe.fromNBT(stack.func_190925_c("spell"));
        if (spell == null || !spell.isValid()) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        SpellCaster.applyAdjusters(stack, player, spell, SpellCastStage.CALCULATING_MANA_COST);
        float manaCost = spell.getManaCost();
        if (magic.getCastingResource().getAmount() < manaCost) {
            return false;
        }
        magic.getCastingResource().consume(manaCost);
        return true;
    }

    public static final void setCooldown(Item item, PlayerEntity player, int durationInTicks) {
        if (!_cooldownItems.contains(item)) {
            _cooldownItems.add(item);
        }
        for (Item cdItem : _cooldownItems) {
            player.func_184811_cZ().func_185145_a(cdItem, durationInTicks);
        }
    }

    private static List<Pair<IItemHandler, Direction>> getReagentSearchInventories(PlayerEntity caster) {
        ArrayList<Pair<IItemHandler, Direction>> output = new ArrayList<Pair<IItemHandler, Direction>>();
        for (int i = 0; i < caster.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = caster.field_71071_by.func_70301_a(i);
            if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ItemPractitionersPouch)) continue;
            ItemPractitionersPouch item = (ItemPractitionersPouch)invStack.func_77973_b();
            Pair<IItemHandler, Direction> remoteInv = item.resolveRemoteInventory(invStack, caster.field_70170_p);
            if (remoteInv != null) {
                output.add(remoteInv);
            }
            if (item.getPatchLevel(invStack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> output.add(new Pair((Object)new InvWrapper((IInventory)m.getRiftInventory()), (Object)Direction.UP)));
            }
            InventoryRitualKit kit = new InventoryRitualKit(invStack);
            output.add((Pair<IItemHandler, Direction>)new Pair((Object)kit, (Object)Direction.UP));
        }
        output.add(new Pair((Object)new InvWrapper((IInventory)caster.field_71071_by), (Object)Direction.UP));
        return output;
    }

    private static final boolean checkReagents(PlayerEntity caster, SpellRecipe recipe) {
        if (caster.func_184812_l_()) {
            return true;
        }
        List<Pair<IItemHandler, Direction>> inventories = SpellCaster.getReagentSearchInventories(caster);
        for (SpellReagent reagent : recipe.getReagents(caster, null)) {
            if (InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), true, inventories)) continue;
            return false;
        }
        return true;
    }

    private static final void consumeReagents(PlayerEntity caster, SpellRecipe recipe, SpellCastingResult componentResults) {
        if (caster.func_184812_l_() || caster.field_70170_p.field_72995_K) {
            return;
        }
        List<Pair<IItemHandler, Direction>> inventories = SpellCaster.getReagentSearchInventories(caster);
        for (SpellReagent reagent : recipe.getReagents(caster, componentResults)) {
            if (!reagent.getConsume()) continue;
            InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), false, inventories);
        }
    }

    @Override
    public SpellCastingResult affect(ItemStack stack, ISpellDefinition spell, World world, SpellSource source) {
        return SpellCaster.Affect(stack, spell, world, source);
    }

    @Override
    public ISpellDefinition createSpell(Shape shape, Component component, Modifier ... modifiers) {
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(shape);
        recipe.addComponent(component);
        for (int i = 0; i < Math.min(3, modifiers.length); ++i) {
            recipe.setModifier(modifiers[i], i);
        }
        return recipe;
    }

    @Override
    public ISpellDefinition parseSpellDefinition(ItemStack stack) {
        return SpellRecipe.fromNBT(stack.func_196082_o());
    }

    @Override
    public SpellCastingResult playerCast(ItemStack stack, PlayerEntity caster, Hand hand, boolean consumeMana) {
        return SpellCaster.PlayerCast(stack, caster, hand, caster.func_213303_ch(), caster.func_70040_Z(), caster.field_70170_p, consumeMana);
    }

    @Override
    public void writeSpellDefinition(ISpellDefinition spell, ItemStack stack) {
        spell.writeToNBT(stack.func_196082_o());
    }

    @Override
    public void writeSpellDefinitionTooltip(ISpellDefinition spell, List<ITextComponent> tooltip) {
    }

    @Override
    public void registerSpellCastingItem(Item item) {
        _cooldownItems.add(item);
    }

    @Override
    public void registerSpellAdjuster(Predicate<SpellAdjustingContext> predicate, BiConsumer<ISpellDefinition, PlayerEntity> adjuster) {
        SpellCaster.registerAdjuster(predicate, adjuster);
    }

    @Override
    public IForgeRegistry<Shape> getShapeRegistry() {
        return Registries.Shape;
    }

    @Override
    public IForgeRegistry<Component> getComponentRegistry() {
        return Registries.Component;
    }

    @Override
    public IForgeRegistry<Modifier> getModifierRegistry() {
        return Registries.Modifier;
    }

    static {
        _cooldownItems.add((Item)ItemInit.SPELL.get());
        _cooldownItems.add((Item)ItemInit.SPELL_BOOK.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_COUNCIL.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_DEMON.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_FEY.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_UNDEAD.get());
        _cooldownItems.add((Item)ItemInit.ROTE_BOOK.get());
        _cooldownItems.add((Item)ItemInit.PUNKIN_STAFF.get());
        _cooldownItems.add((Item)ItemInit.STAFF_A.get());
        _cooldownItems.add((Item)ItemInit.STAFF_B.get());
        _cooldownItems.add((Item)ItemInit.STAFF_C.get());
        _cooldownItems.add((Item)ItemInit.WAND_A.get());
        _cooldownItems.add((Item)ItemInit.WAND_B.get());
        _cooldownItems.add((Item)ItemInit.WAND_C.get());
        _cooldownItems.add((Item)ItemInit.HELLFIRE_STAFF.get());
    }
}

