/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells;

import com.ma.api.spells.adjusters.SpellAdjustingContext;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.base.ISpellDefinition;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class SpellAdjuster {
    private final Predicate<SpellAdjustingContext> executeCheck;
    private final BiConsumer<ISpellDefinition, PlayerEntity> bi_adjuster;

    public SpellAdjuster(Predicate<SpellAdjustingContext> executeCheck, BiConsumer<ISpellDefinition, PlayerEntity> adjuster) {
        this.executeCheck = executeCheck;
        this.bi_adjuster = adjuster;
    }

    public boolean check(SpellCastStage stage, ItemStack stack, @Nullable PlayerEntity caster) {
        return this.executeCheck.test(new SpellAdjustingContext(stack, caster, stage));
    }

    public void modify(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (this.bi_adjuster != null) {
            this.bi_adjuster.accept(recipe, caster);
        }
    }
}

