/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityAncientCouncil;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class RitualEffectAncientCouncil
extends RitualEffect {
    public RitualEffectAncientCouncil(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return new StringTextComponent("Progression could not be found...this is a problem.");
        }
        if (progression.getTier() > 2 && progression.getAlliedFaction() != Faction.ANCIENT_WIZARDS) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.wrong_faction");
        }
        if (progression.getTierProgress() < 1.0f) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.not_ready");
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Faction.ANCIENT_WIZARDS) {
            context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ritual_failed"), Util.field_240973_b_);
            return false;
        }
        if (context.getCaster() == null || context.getCaster().func_110124_au() == null) {
            return false;
        }
        EntityAncientCouncil e = (EntityAncientCouncil)((EntityType)EntityInit.ANCIENT_COUNCIL.get()).func_220331_a((ServerWorld)context.getWorld(), null, context.getCaster(), context.getCenter(), SpawnReason.EVENT, false, false);
        e.setCasterUUID(context.getCaster().func_110124_au());
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 100;
    }
}

