/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.manaweaving;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ManaweavingRecipeSerializer
extends AMRecipeBaseSerializer<ManaweavingRecipe> {
    public static HashMap<ResourceLocation, ManaweavingRecipe> ALL_RECIPES = new HashMap();

    public ManaweavingRecipeSerializer(Function<ResourceLocation, ManaweavingRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public ManaweavingRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        ManaweavingRecipe recipe = new ManaweavingRecipe(recipeId);
        recipe.parseJSON(json);
        ALL_RECIPES.put(recipeId, recipe);
        return recipe;
    }

    @Override
    public ManaweavingRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ManaweavingRecipe recipe = new ManaweavingRecipe(recipeId);
            recipe.setOutput(buffer.func_192575_l());
            recipe.setOutputQuantity(buffer.readInt());
            recipe.setEnchantment(buffer.func_192575_l());
            recipe.setEnchantmentMagnitude(buffer.readInt());
            recipe.setCopyNBT(buffer.readBoolean());
            recipe.setRequiredFaction(buffer.readInt());
            int numItems = buffer.readInt();
            ResourceLocation[] requiredItems = new ResourceLocation[numItems];
            for (int i = 0; i < numItems; ++i) {
                requiredItems[i] = buffer.func_192575_l();
            }
            recipe.setRequiredItems(requiredItems);
            int numPatterns = buffer.readInt();
            ResourceLocation[] requiredPatterns = new ResourceLocation[numPatterns];
            for (int i = 0; i < numPatterns; ++i) {
                requiredPatterns[i] = buffer.func_192575_l();
            }
            recipe.setRequiredPatterns(requiredPatterns);
            ALL_RECIPES.put(recipeId, recipe);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading manaweaving recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, ManaweavingRecipe recipe) {
        try {
            int i;
            buffer.func_192572_a(recipe.getOutput());
            buffer.writeInt(recipe.getOutputQuantity());
            buffer.func_192572_a(recipe.getEnchantment());
            buffer.writeInt(recipe.getEnchantmentMagnitude());
            buffer.writeBoolean(recipe.getCopyNBT());
            buffer.writeInt(recipe.getFactionRequirement().ordinal());
            ResourceLocation[] items = recipe.getRequiredItems();
            ResourceLocation[] patterns = recipe.getRequiredPatterns();
            buffer.writeInt(items.length);
            for (i = 0; i < items.length; ++i) {
                buffer.func_192572_a(items[i]);
            }
            buffer.writeInt(patterns.length);
            for (i = 0; i < patterns.length; ++i) {
                buffer.func_192572_a(patterns[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing manaweaving recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

