/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.manaweaving;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ManaweavingPatternSerializer
extends AMRecipeBaseSerializer<ManaweavingPattern> {
    public static HashMap<ResourceLocation, ManaweavingPattern> ALL_RECIPES = new HashMap();

    public ManaweavingPatternSerializer(Function<ResourceLocation, ManaweavingPattern> patternMap) {
        super(patternMap);
    }

    @Override
    public ManaweavingPattern readExtra(ResourceLocation recipeId, JsonObject json) {
        ManaweavingPattern pattern = new ManaweavingPattern(recipeId);
        pattern.parseJSON(json);
        ALL_RECIPES.put(recipeId, pattern);
        return pattern;
    }

    @Override
    public ManaweavingPattern readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            int len = buffer.readInt();
            byte[][] pattern = new byte[len][];
            for (int i = 0; i < len; ++i) {
                pattern[i] = buffer.func_179251_a();
            }
            ManaweavingPattern mwpattern = new ManaweavingPattern(recipeId);
            mwpattern.setPatternBytes(pattern);
            ALL_RECIPES.put(recipeId, mwpattern);
            return mwpattern;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading manaweaving pattern recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, ManaweavingPattern recipe) {
        try {
            byte[][] pattern = recipe.get();
            buffer.writeInt(pattern.length);
            for (int i = 0; i < pattern.length; ++i) {
                buffer.func_179250_a(pattern[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing manaweaving pattern recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

