/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.eldrin;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.eldrin.EldrinAltarRecipe;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class EldrinAltarRecipeSerializer
extends AMRecipeBaseSerializer<EldrinAltarRecipe> {
    public EldrinAltarRecipeSerializer(Function<ResourceLocation, EldrinAltarRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public void writeExtra(PacketBuffer buffer, EldrinAltarRecipe recipe) {
        try {
            int i;
            buffer.func_192572_a(recipe.getOutput());
            buffer.writeInt(recipe.getOutputQuantity());
            buffer.writeInt(recipe.getFactionRequirement().ordinal());
            ResourceLocation[] items = recipe.getRequiredItems();
            ResourceLocation[] patterns = recipe.getRequiredPatterns();
            buffer.writeInt(items.length);
            for (i = 0; i < items.length; ++i) {
                buffer.func_192572_a(items[i]);
            }
            buffer.writeInt(patterns.length);
            for (i = 0; i < patterns.length; ++i) {
                buffer.func_192572_a(patterns[i]);
            }
            buffer.writeInt(recipe.getPowerRequirements().size());
            recipe.getPowerRequirements().entrySet().forEach(r -> {
                buffer.writeInt(((Affinity)((Object)((Object)r.getKey()))).ordinal());
                buffer.writeFloat(((Float)r.getValue()).floatValue());
            });
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing eldrin altar recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public EldrinAltarRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            EldrinAltarRecipe recipe = new EldrinAltarRecipe(recipeId);
            recipe.setOutput(buffer.func_192575_l());
            recipe.setOutputQuantity(buffer.readInt());
            recipe.setRequiredFaction(buffer.readInt());
            int numItems = buffer.readInt();
            ResourceLocation[] requiredItems = new ResourceLocation[numItems];
            for (int i = 0; i < numItems; ++i) {
                requiredItems[i] = buffer.func_192575_l();
            }
            recipe.setRequiredItems(requiredItems);
            int numPatterns = buffer.readInt();
            ResourceLocation[] requiredPatterns = new ResourceLocation[numPatterns];
            for (int i = 0; i < numPatterns; ++i) {
                requiredPatterns[i] = buffer.func_192575_l();
            }
            recipe.setRequiredPatterns(requiredPatterns);
            int num_power_requirements = buffer.readInt();
            for (int i = 0; i < num_power_requirements; ++i) {
                int ordinal = buffer.readInt();
                float power = buffer.readFloat();
                recipe.getPowerRequirements().put(Affinity.values()[ordinal], Float.valueOf(power));
            }
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading eldrin altar recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected EldrinAltarRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        EldrinAltarRecipe recipe = new EldrinAltarRecipe(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }
}

