/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IItemAndPatternRecipe;
import com.ma.recipes.AMRecipeBase;
import com.ma.tools.MATags;
import com.ma.tools.NBTUtilities;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ItemAndPatternRecipe
extends AMRecipeBase
implements IItemAndPatternRecipe {
    protected ResourceLocation[] requiredItems = new ResourceLocation[0];
    protected ResourceLocation[] requiredPatterns = new ResourceLocation[0];
    protected ResourceLocation output = new ResourceLocation("");
    protected int outputQuantity;
    protected CompoundNBT __outputNBT = null;
    protected ItemStack __outputItem = null;

    public ItemAndPatternRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        if (recipeJSON.get("output").isJsonObject()) {
            JsonObject outputObject = recipeJSON.get("output").getAsJsonObject();
            this.output = new ResourceLocation(outputObject.get("item").getAsString());
            if (outputObject.has("data")) {
                this.__outputNBT = NBTUtilities.fromJSON(outputObject.get("data").getAsJsonObject());
            }
        } else {
            this.output = new ResourceLocation(recipeJSON.get("output").getAsString());
        }
        this.outputQuantity = recipeJSON.has("quantity") ? Math.max(1, recipeJSON.get("quantity").getAsInt()) : 1;
        JsonElement items = recipeJSON.get("items");
        if (items != null && items.isJsonArray()) {
            JsonArray itemsarray = items.getAsJsonArray();
            this.requiredItems = new ResourceLocation[Math.min(itemsarray.size(), this.maxItems())];
            for (int i = 0; i < this.requiredItems.length; ++i) {
                this.requiredItems[i] = new ResourceLocation(itemsarray.get(i).getAsString());
            }
        } else {
            this.output = new ResourceLocation("");
            ManaAndArtifice.LOGGER.error("Error parsing JSON for manaweaving recipe %s, block [items].  This must be an array.  The object was not loaded.");
            return;
        }
        JsonElement patterns = recipeJSON.get("patterns");
        if (patterns != null && patterns.isJsonArray()) {
            JsonArray patternsarray = patterns.getAsJsonArray();
            this.requiredPatterns = new ResourceLocation[Math.min(patternsarray.size(), this.maxPatterns())];
            for (int i = 0; i < this.requiredPatterns.length; ++i) {
                this.requiredPatterns[i] = new ResourceLocation(patternsarray.get(i).getAsString());
            }
        } else if (this.maxPatterns() > 0) {
            this.output = new ResourceLocation("");
            ManaAndArtifice.LOGGER.error("Error parsing JSON for manaweaving recipe %s, block [patterns].  This must be an array.  The object was not loaded.");
            return;
        }
    }

    protected abstract int maxItems();

    protected abstract int maxPatterns();

    public boolean matches(CraftingInventory inv, World worldIn) {
        return true;
    }

    protected boolean patternsMatchShaped(ArrayList<String> patternsIn) {
        if (patternsIn.size() != this.requiredPatterns.length) {
            return false;
        }
        for (int i = 0; i < this.requiredPatterns.length; ++i) {
            if (patternsIn.get(i).equals(this.requiredPatterns[i].toString()) || patternsIn.get(i).replace("manaweave_patterns/", "").equals(this.requiredPatterns[i].toString())) continue;
            return false;
        }
        return true;
    }

    protected boolean itemsMatchShapeless(ArrayList<ItemStack> inItems) {
        if (inItems.size() != this.requiredItems.length) {
            return false;
        }
        block0: for (ResourceLocation rLoc : this.requiredItems) {
            if (rLoc == null) continue;
            for (int i = 0; i < inItems.size(); ++i) {
                ItemStack stack = inItems.get(i);
                if (stack.func_77951_h() || !MATags.isItemEqual(stack, rLoc)) continue;
                inItems.remove(i);
                continue block0;
            }
        }
        return inItems.size() == 0;
    }

    protected boolean patternsMatchShapeless(ArrayList<String> patternsIn) {
        if (patternsIn.size() != this.requiredPatterns.length) {
            return false;
        }
        for (ResourceLocation rLoc : this.requiredPatterns) {
            if (rLoc == null) continue;
            int idx = patternsIn.indexOf(rLoc.toString());
            if (idx == -1) {
                return false;
            }
            patternsIn.remove(idx);
        }
        return patternsIn.size() == 0;
    }

    public int getOutputQuantity() {
        return this.outputQuantity;
    }

    public void setOutputQuantity(int outputQuantity) {
        this.outputQuantity = outputQuantity;
    }

    public ItemStack assemble(CraftingInventory inv) {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        IForgeRegistry itemRegistry;
        if ((this.__outputItem == null || this.__outputItem.func_190926_b()) && (itemRegistry = GameRegistry.findRegistry(Item.class)) != null) {
            Item outputItem = (Item)itemRegistry.getValue(this.output);
            if (outputItem == null) {
                return ItemStack.field_190927_a;
            }
            this.__outputItem = new ItemStack((IItemProvider)outputItem, this.outputQuantity);
            if (this.__outputNBT != null) {
                this.__outputItem.func_77982_d(this.__outputNBT.func_74737_b());
            }
        }
        return this.__outputItem;
    }

    @Override
    public void runValidation() {
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Override
    public ResourceLocation[] getRequiredItems() {
        return this.requiredItems;
    }

    public void setRequiredItems(ResourceLocation[] locations) {
        this.requiredItems = locations;
    }

    @Override
    public ResourceLocation[] getRequiredPatterns() {
        return this.requiredPatterns;
    }

    public void setRequiredPatterns(ResourceLocation[] patterns) {
        this.requiredPatterns = patterns;
    }

    public ResourceLocation getOutput() {
        return this.output;
    }

    public void setOutput(ResourceLocation location) {
        this.output = location;
    }

    public abstract IRecipeSerializer<?> func_199559_b();

    public abstract IRecipeType<?> func_222127_g();
}

