/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.types.movers;

import com.ma.api.particles.IParticleMoveType;
import com.ma.particles.base.MAParticleBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class ParticleSphereOrbitMover
implements IParticleMoveType {
    private Vector3d center;
    private double forward;
    private double tilt;
    private double radius;

    public ParticleSphereOrbitMover() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
    }

    public ParticleSphereOrbitMover(double sx, double sy, double sz, double forward, double tilt, double radius) {
        this.center = new Vector3d(sx, sy, sz);
        this.forward = forward;
        this.tilt = tilt;
        this.radius = radius;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.writeDouble(this.center.field_72450_a);
        buffer.writeDouble(this.center.field_72448_b);
        buffer.writeDouble(this.center.field_72449_c);
        buffer.writeDouble(this.forward);
        buffer.writeDouble(this.tilt);
        buffer.writeDouble(this.radius);
    }

    @Override
    public String serialize() {
        return "OrbitMover:" + this.center.field_72450_a + ":" + this.center.field_72448_b + ":" + this.center.field_72449_c + ":" + this.forward + ":" + this.tilt + ":" + this.radius;
    }

    @Override
    public IParticleMoveType deserialize(PacketBuffer buffer) {
        this.center = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.forward = buffer.readDouble();
        this.tilt = buffer.readDouble();
        this.radius = buffer.readDouble();
        return this;
    }

    @Override
    public void deserialize(String string) {
        if (string.startsWith("SphereOrbitMover")) {
            String[] parts = string.split(":");
            this.center = new Vector3d(Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            this.forward = Double.parseDouble(parts[4]);
            this.tilt = Double.parseDouble(parts[5]);
            this.radius = Double.parseDouble(parts[6]);
        }
    }

    @Override
    public void configureParticle(MAParticleBase particle) {
        particle.setMoveSphereOrbit(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c, this.forward, this.tilt, this.radius);
    }

    @Override
    public int getId() {
        return 2;
    }
}

