/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.types.movers;

import com.ma.api.particles.IParticleMoveType;
import com.ma.particles.base.MAParticleBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class ParticleLerpMover
implements IParticleMoveType {
    private Vector3d start;
    private Vector3d end;

    public ParticleLerpMover() {
        this.start = new Vector3d(0.0, 0.0, 0.0);
        this.end = new Vector3d(0.0, 0.0, 0.0);
    }

    public ParticleLerpMover(double sx, double sy, double sz, double ex, double ey, double ez) {
        this.start = new Vector3d(sx, sy, sz);
        this.end = new Vector3d(ex, ey, ez);
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.writeDouble(this.start.field_72450_a);
        buffer.writeDouble(this.start.field_72448_b);
        buffer.writeDouble(this.start.field_72449_c);
        buffer.writeDouble(this.end.field_72450_a);
        buffer.writeDouble(this.end.field_72448_b);
        buffer.writeDouble(this.end.field_72449_c);
    }

    @Override
    public String serialize() {
        return "LerpMover:" + this.start.field_72450_a + ":" + this.start.field_72448_b + ":" + this.start.field_72449_c + ":" + this.end.field_72450_a + ":" + this.end.field_72448_b + ":" + this.end.field_72449_c;
    }

    @Override
    public IParticleMoveType deserialize(PacketBuffer buffer) {
        this.start = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.end = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        return this;
    }

    @Override
    public void deserialize(String string) {
        if (string.startsWith("VelocityMover")) {
            String[] parts = string.split(":");
            this.start = new Vector3d(Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            this.end = new Vector3d(Double.parseDouble(parts[4]), Double.parseDouble(parts[5]), Double.parseDouble(parts[6]));
        }
    }

    @Override
    public void configureParticle(MAParticleBase particle) {
        particle.setMoveLerp(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c, this.end.field_72450_a, this.end.field_72448_b, this.end.field_72449_c);
    }

    @Override
    public int getId() {
        return 1;
    }
}

