/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles;

import com.ma.api.particles.MAParticleType;
import com.ma.particles.base.MAParticleBase;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXLight
extends MAParticleBase {
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXLight.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXLight.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:light";
        }
    };

    public FXLight(ClientWorld world, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        this.field_190015_G = this.field_190014_F = (float)(-45.0 + Math.random() * 90.0 / (Math.PI / 180));
        this.func_82338_g(0.0f);
        this.field_70552_h = 0.225f;
        this.field_70553_i = 0.245f;
        this.field_70551_j = 0.95f;
        this.field_70544_f *= 0.75f;
        this.field_190017_n = false;
        this.field_217569_E = sprite.func_217590_a(new Random());
        this.maxAlpha = 0.1f;
        this.field_70547_e = 20;
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f;
    }

    @Override
    @Nonnull
    public IParticleRenderType func_217558_b() {
        return NORMAL_RENDER;
    }

    protected static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableCull();
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        Vector3 myPos = new Vector3(this.field_187123_c, this.field_187124_d, this.field_187125_e);
        Vector3 projected = new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        Quaternion quaternion = new Quaternion(renderInfo.func_227995_f_());
        quaternion.func_195890_a(Vector3.LookAt(myPos, projected));
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXLightVelocity
    extends MAParticleBase.FXParticleFactoryBase {
        public FXLightVelocity(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXLight particle = new FXLight(worldIn, x, y, z, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed, false);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }
}

