/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RequestWellspringPowerNetworkSyncMessage
extends BaseMessage {
    private RegistryKey<World> forDimension;
    private boolean nearbyNodes;

    public RequestWellspringPowerNetworkSyncMessage(RegistryKey<World> dimension, boolean nearbyNodes) {
        this.forDimension = dimension;
        this.nearbyNodes = nearbyNodes;
        this.messageIsValid = true;
    }

    public RequestWellspringPowerNetworkSyncMessage() {
        this.messageIsValid = false;
    }

    public static final RequestWellspringPowerNetworkSyncMessage decode(PacketBuffer buf) {
        RequestWellspringPowerNetworkSyncMessage msg = new RequestWellspringPowerNetworkSyncMessage();
        try {
            ResourceLocation location = buf.func_192575_l();
            ResourceLocation registryName = buf.func_192575_l();
            msg.forDimension = new RegistryKey(registryName, location);
            msg.nearbyNodes = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RequestWellspringPowerNetworkSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public RegistryKey<World> getDimension() {
        return this.forDimension;
    }

    public boolean getNearbyNodes() {
        return this.nearbyNodes;
    }

    public static final void encode(RequestWellspringPowerNetworkSyncMessage msg, PacketBuffer buf) {
        buf.func_192572_a(msg.forDimension.func_240901_a_());
        buf.func_192572_a(msg.forDimension.getRegistryName());
        buf.writeBoolean(msg.getNearbyNodes());
    }
}

