/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class ManaweavePatternDrawnMessage
extends BaseMessage {
    private ResourceLocation patternID;
    private Vector3d position;
    private Hand hand;
    private int ticksDrawn;

    public ManaweavePatternDrawnMessage(ResourceLocation patternID, Vector3d position, Hand hand, int ticksDrawn) {
        this.patternID = patternID;
        this.position = position;
        this.hand = hand;
        this.ticksDrawn = ticksDrawn;
        this.messageIsValid = true;
    }

    public ManaweavePatternDrawnMessage() {
        this.messageIsValid = false;
    }

    public ResourceLocation getPatternID() {
        return this.patternID;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public int getTicksDrawn() {
        return this.ticksDrawn;
    }

    public Hand getHand() {
        return this.hand;
    }

    public static ManaweavePatternDrawnMessage decode(PacketBuffer buf) {
        ManaweavePatternDrawnMessage msg = new ManaweavePatternDrawnMessage();
        try {
            msg.patternID = buf.func_192575_l();
            msg.position = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            msg.hand = Hand.values()[buf.readInt()];
            msg.ticksDrawn = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ManaweavePatternDrawnMessage msg, PacketBuffer buf) {
        buf.func_192572_a(msg.getPatternID());
        buf.writeDouble(msg.getPosition().field_72450_a);
        buf.writeDouble(msg.getPosition().field_72448_b);
        buf.writeDouble(msg.getPosition().field_72449_c);
        buf.writeInt(msg.getHand().ordinal());
        buf.writeInt(msg.getTicksDrawn());
    }
}

