/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.network.ExtendedItemStackPacketBuffer;
import com.ma.network.messages.BaseMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ExtendedSlotContentsMessage
extends BaseMessage {
    private int screenId = 0;
    private int slot = 0;
    private ItemStack stack = ItemStack.field_190927_a;

    public ExtendedSlotContentsMessage(int screenId, int slot, ItemStack stack) {
        this.screenId = screenId;
        this.slot = slot;
        this.stack = stack.func_77946_l();
        this.messageIsValid = true;
    }

    public ExtendedSlotContentsMessage() {
        this.messageIsValid = false;
    }

    public int getScreenID() {
        return this.screenId;
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public static ExtendedSlotContentsMessage decode(PacketBuffer buf) {
        ExtendedSlotContentsMessage msg = new ExtendedSlotContentsMessage();
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        try {
            msg.screenId = bufferWrapper.readInt();
            msg.slot = bufferWrapper.readInt();
            msg.stack = bufferWrapper.readExtendedItemStack();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ExtendedSlotContentsMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ExtendedSlotContentsMessage msg, PacketBuffer buf) {
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        bufferWrapper.writeInt(msg.getScreenID());
        bufferWrapper.writeInt(msg.getSlotIndex());
        bufferWrapper.writeExtendedItemStack(msg.getStack());
    }
}

