/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public class ExtendedItemStackPacketBuffer
extends PacketBuffer {
    public ExtendedItemStackPacketBuffer(ByteBuf buffer) {
        super(buffer);
    }

    public void writeExtendedItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            this.writeInt(-1);
        } else {
            this.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
            this.writeInt(stack.func_190916_E());
            CompoundNBT nbttagcompound = null;
            if (stack.func_77973_b().getShareTag(stack) != null) {
                nbttagcompound = stack.func_77973_b().getShareTag(stack);
            }
            this.writeNBT(nbttagcompound);
        }
    }

    public ItemStack readExtendedItemStack() {
        int itemID = this.readInt();
        if (itemID < 0) {
            return ItemStack.field_190927_a;
        }
        int count = this.readInt();
        ItemStack stack = new ItemStack((IItemProvider)Item.func_150899_d((int)itemID), count);
        stack.func_77982_d(this.readNBT());
        return stack;
    }

    public CompoundNBT readNBT() {
        int i = this.readerIndex();
        byte b0 = this.readByte();
        if (b0 == 0) {
            return null;
        }
        this.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)this.getBuffer()), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public void writeNBT(@Nullable CompoundNBT nbt) {
        if (nbt == null) {
            this.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)new ByteBufOutputStream((ByteBuf)this.getBuffer()));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }
}

