/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery.bound;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.renderers.bound.BoundAxeItemRenderer;
import com.ma.items.sorcery.bound.IBoundItem;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ItemBoundAxe
extends AxeItem
implements IBoundItem {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ItemBoundAxe(float attackDamageIn, float attackSpeedIn) {
        super((IItemTier)ItemTier.DIAMOND, attackDamageIn, attackSpeedIn, new Item.Properties().setISTER(() -> BoundAxeItemRenderer::new));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public float getPassiveManaDrain(Entity entity) {
        return 0.5f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap baseAttrs = super.getAttributeModifiers(slot, stack);
        if (slot != EquipmentSlotType.MAINHAND) {
            return baseAttrs;
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!stack.func_77942_o()) {
            return baseAttrs;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.func_77978_p());
        if (!recipe.isValid()) {
            return baseAttrs;
        }
        int damage = (int)((ModifiedSpellPart)recipe.getShape()).getValue(com.ma.api.spells.attributes.Attribute.DAMAGE);
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        int range = (int)((ModifiedSpellPart)recipe.getShape()).getValue(com.ma.api.spells.attributes.Attribute.RANGE);
        builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(BASE_RANGE_UUID, "Weapon modifier", (double)range, AttributeModifier.Operation.ADDITION));
        baseAttrs.forEach((a, m) -> {
            if (a == ForgeMod.REACH_DISTANCE.get() || a == Attributes.field_233823_f_) {
                return;
            }
            builder.put(a, m);
        });
        return builder.build();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        SpellRecipe recipe = this.getRecipe(stack);
        if (attacker instanceof PlayerEntity && recipe.isValid()) {
            ((PlayerEntity)attacker).getCapability(PlayerMagicProvider.MAGIC).ifPresent(c -> {
                if (c.getCastingResource().getAmount() >= recipe.getManaCost() && this.affectTarget(recipe, attacker, target, Hand.MAIN_HAND)) {
                    c.getCastingResource().consume(recipe.getManaCost());
                }
            });
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.handleInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        SpellRecipe recipe = this.getRecipe(stack);
        recipe.addItemTooltip(stack, worldIn, tooltip, flagIn, (PlayerEntity)mc.field_71439_g);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack createFromSpell(ItemStack original, ISpellDefinition recipe) {
        return IBoundItem.super.createFromSpell((Item)this, original, recipe);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        ItemStack restored = this.restoreItem(item);
        player.func_174820_d(98, restored);
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bound_swordaxe.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

