/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.runes;

import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.ma.recipes.runeforging.RunescribingRecipeSerializer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemRunescribingRecipe
extends TieredItem {
    private static final String NBT_RECIPEID = "runescribe_recipe_id";

    public ItemRunescribingRecipe() {
        super(new Item.Properties().func_200916_a(MAItemGroups.runes));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (RunescribingRecipe recipe : RunescribingRecipeSerializer.ALL_RECIPES.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemRunescribingRecipe.setRecipe(stack, recipe);
                items.add((Object)stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        RunescribingRecipe recipe = this.getRecipe(stack, worldIn);
        if (recipe == null || recipe.func_77571_b() == null || recipe.func_77571_b().func_190926_b()) {
            return;
        }
        tooltip.add(recipe.func_77571_b().func_200301_q());
    }

    public ItemStack func_190903_i() {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (RunescribingRecipeSerializer.ALL_RECIPES.size() > 0) {
            ItemRunescribingRecipe.setRecipe(stack, RunescribingRecipeSerializer.ALL_RECIPES.values().iterator().next());
        }
        return stack;
    }

    @Nullable
    public RunescribingRecipe getRecipe(ItemStack stack, World world) {
        if (world == null || world.func_199532_z() == null || !stack.func_77942_o() || stack.func_77973_b() != this) {
            return null;
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (!nbt.func_74764_b(NBT_RECIPEID)) {
            return null;
        }
        ResourceLocation rLoc = new ResourceLocation(nbt.func_74781_a(NBT_RECIPEID).func_150285_a_());
        Optional optRecipe = world.func_199532_z().func_215367_a(rLoc);
        if (!optRecipe.isPresent() || !(optRecipe.get() instanceof RunescribingRecipe)) {
            return null;
        }
        return (RunescribingRecipe)optRecipe.get();
    }

    public static void setRecipe(ItemStack stack, RunescribingRecipe recipe) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a(NBT_RECIPEID, recipe.func_199560_c().toString());
    }
}

