/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ItemPlayerCharm
extends TieredItem {
    private static final String KEY_PLAYER_TARGET_NAME = "player_target_name";
    private static final String KEY_PLAYER_TARGET_UUID = "player_target_uuid";
    private static final String KEY_PLAYER_TARGET_SALT = "player_target_salt";

    public ItemPlayerCharm() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.thaumaturgy));
    }

    public boolean SetPlayerTarget(PlayerEntity entity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        LazyOptional magic = entity.getCapability(PlayerMagicProvider.MAGIC);
        if (magic.isPresent()) {
            nbt.func_74778_a(KEY_PLAYER_TARGET_UUID, entity.func_110124_au().toString());
            nbt.func_74768_a(KEY_PLAYER_TARGET_SALT, ((IPlayerMagic)magic.orElse(null)).getTeleportSalt());
            nbt.func_74778_a(KEY_PLAYER_TARGET_NAME, entity.func_146103_bH().getName());
            return true;
        }
        return false;
    }

    @Nullable
    public PlayerEntity GetPlayerTarget(ItemStack stack, World world) {
        LazyOptional magic;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(KEY_PLAYER_TARGET_UUID) || !nbt.func_74764_b(KEY_PLAYER_TARGET_SALT)) {
            return null;
        }
        UUID uuid = UUID.fromString(nbt.func_74779_i(KEY_PLAYER_TARGET_UUID));
        PlayerEntity entity = world.func_217371_b(uuid);
        if (entity != null && (magic = entity.getCapability(PlayerMagicProvider.MAGIC)).isPresent() && ((IPlayerMagic)magic.orElse(null)).getTeleportSalt() == nbt.func_74762_e(KEY_PLAYER_TARGET_SALT)) {
            return entity;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if (!nbt.func_74764_b(KEY_PLAYER_TARGET_UUID) && !nbt.func_74764_b(KEY_PLAYER_TARGET_SALT)) {
                this.SetPlayerTarget(playerIn, stack);
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("You've attuned this to yourself!"), Util.field_240973_b_);
            } else {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("This is already attuned to someone else."), Util.field_240973_b_);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.player_charm.not_attuned", (Object[])new Object[0])));
            return;
        }
        String playerName = nbt.func_74779_i(KEY_PLAYER_TARGET_NAME);
        if (playerName == null) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.player_charm.attuned", (Object[])new Object[]{playerName})));
    }
}

