/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice.curio;

import com.ma.api.items.ChargeableItem;
import com.ma.api.items.MAItemGroups;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class ItemEldritchOrb
extends ChargeableItem {
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();

    public ItemEldritchOrb() {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice), 1000.0f);
        this.allowedEnchantments.clear();
        this.allowedEnchantments.add(Enchantments.field_180312_n);
        this.allowedEnchantments.add(Enchantments.field_185311_w);
        this.allowedEnchantments.add(Enchantments.field_180313_o);
        this.allowedEnchantments.add(Enchantments.field_222192_G);
        this.allowedEnchantments.add(Enchantments.field_185303_l);
        this.allowedEnchantments.add(Enchantments.field_222193_H);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.allowedEnchantments.contains(ench)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.allowedEnchantments.contains(enchantment);
    }

    public boolean shoot(PlayerEntity caster, ItemStack orb) {
        if (caster.field_70170_p.field_72995_K) {
            return false;
        }
        List targets = caster.field_70170_p.func_217357_a(MobEntity.class, caster.func_174813_aQ().func_186662_g(5.0)).stream().filter(e -> e.func_70089_S() && e.func_70685_l((Entity)caster) && (e.func_70638_az() == caster || e.func_70643_av() == caster)).collect(Collectors.toList());
        if (targets.size() <= 0) {
            return false;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)orb);
        int numTargets = enchants.containsKey(Enchantments.field_222192_G) ? (Integer)enchants.get(Enchantments.field_222192_G) + 1 : 1;
        for (int i = 0; i < numTargets; ++i) {
            MobEntity target = (MobEntity)targets.get((int)Math.floor(Math.random() * (double)targets.size()));
            Vector3f translation = new Vector3f(1.0f, 2.0f, 0.0f);
            Quaternion rotation = new Quaternion(Vector3f.field_229180_c_, (float)((double)(MathUtils.lerpf(caster.field_70758_at, caster.field_70759_as, 0.0f) / 180.0f) * Math.PI), false);
            translation.func_214905_a(rotation);
            ServerMessageDispatcher.sendParticleSpawn(caster.func_226277_ct_() + (double)translation.func_195899_a(), caster.func_226278_cu_() + (double)translation.func_195900_b(), caster.func_226281_cx_() + (double)translation.func_195902_c(), target.func_233580_cy_().func_177958_n(), (float)target.func_233580_cy_().func_177956_o() + target.func_213302_cg() / 2.0f, target.func_233580_cy_().func_177952_p(), 64.0f, (RegistryKey<World>)caster.field_70170_p.func_234923_W_(), (MAParticleType)ParticleInit.LIGHTNING_BOLT.get());
            caster.field_70170_p.func_184133_a(null, caster.func_233580_cy_(), SFX.Spell.Cast.ARCANE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.applyOrbEnchantmentEffects(caster, target, enchants);
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)caster), 1.0f);
        }
        return true;
    }

    private void applyOrbEnchantmentEffects(PlayerEntity caster, MobEntity target, Map<Enchantment, Integer> enchants) {
        for (Map.Entry<Enchantment, Integer> e : enchants.entrySet()) {
            if ((target instanceof SpiderEntity || target instanceof SilverfishEntity || target instanceof EndermiteEntity) && e.getKey() == Enchantments.field_180312_n) {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, e.getValue().intValue()));
                continue;
            }
            if (target.func_70662_br() && e.getKey() == Enchantments.field_185303_l) {
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 60, e.getValue().intValue()));
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, e.getValue().intValue()));
                continue;
            }
            if (e.getKey() == Enchantments.field_185311_w) {
                target.func_70015_d(e.getValue() + 1);
                continue;
            }
            if (e.getKey() != Enchantments.field_180313_o) continue;
            Vector3d dir = caster.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b();
            target.func_233627_a_((float)e.getValue().intValue() / 3.0f, dir.field_72450_a, dir.field_72449_c);
        }
    }

    @Override
    protected float manaPerRechargeTick() {
        return 10.0f;
    }

    @Override
    protected boolean tickEffect(ItemStack stack, PlayerEntity player, World world, int slot, float mana, boolean selected) {
        long delay;
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        long l = delay = enchants.containsKey(Enchantments.field_222193_H) ? (long)(20 - (Integer)enchants.get(Enchantments.field_222193_H)) : 20L;
        return world.func_82737_E() % delay == 0L && this.shoot(player, stack);
    }
}

