/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.gui.containers.providers.NamedEnderDisc;
import com.ma.items.IItemWithGui;
import com.ma.items.IRadialMenuItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class ItemEnderDisk
extends TieredItem
implements IItemWithGui<ItemEnderDisk>,
IRadialMenuItem {
    private static final String KEY_INDEX = "ender_disk_index";
    private static final String KEY_NBT = "ender_disk_data";
    private static final String KEY_COUNT = "count";
    private static final String KEY_NAME = "name";
    private static final String KEY_ENTRY_PREFIX = "reagent_";
    public static final int MAX_PATTERNS = 7;

    public ItemEnderDisk() {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedEnderDisc();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IPlayerMagic magic = (IPlayerMagic)playerIn.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!this.openGuiIfModifierPressed(playerIn.func_184586_b(handIn), playerIn, worldIn)) {
            this.teleport(worldIn, playerIn, stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResultType.FAIL;
        }
        if (!this.openGuiIfModifierPressed(context.func_195996_i(), context.func_195999_j(), context.func_195991_k())) {
            this.teleport(context.func_195991_k(), context.func_195999_j(), context.func_195996_i());
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("mana-and-artifice:ender_disc.set_to", new Object[]{ItemEnderDisk.getPatternName(stack, ItemEnderDisk.getIndex(stack))}).func_240699_a_(TextFormatting.GOLD));
        IItemWithGui.super.appendHoverText(stack, worldIn, tooltip, flagIn);
        IRadialMenuItem.super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    private void teleport(World world, PlayerEntity player, ItemStack stack) {
        if (world.field_72995_K) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
                world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), (double)player.func_233580_cy_().func_177958_n() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)player.func_233580_cy_().func_177956_o() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)player.func_233580_cy_().func_177952_p() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
            return;
        }
        ArrayList<ResourceLocation> pattern = ItemEnderDisk.getPattern(stack);
        if (pattern.size() == 0) {
            return;
        }
        LazyOptional worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent()) {
            IRitualTeleportLocation teleportPosition = ((IWorldMagic)worldMagicContainer.orElse(null)).getRitualTeleportBlockLocation(pattern, (RegistryKey<World>)world.func_234923_W_());
            if (teleportPosition == null) {
                return;
            }
            if (!teleportPosition.getWorldType().equals((Object)world.func_234923_W_())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.wrong_dimension"), Util.field_240973_b_);
                return;
            }
            ((ServerWorld)world).func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            ((ServerWorld)world).func_184133_a(null, teleportPosition.getPos(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            player.func_70634_a((double)((float)teleportPosition.getPos().func_177958_n() + 0.5f), (double)teleportPosition.getPos().func_177984_a().func_177956_o(), (double)((float)teleportPosition.getPos().func_177952_p() + 0.5f));
        }
    }

    private static CompoundNBT getCurrentCompound(ItemStack stack, int index) {
        ListNBT list;
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(KEY_NBT)) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag.func_150297_b(KEY_NBT, 10)) {
            return tag.func_74775_l(KEY_NBT);
        }
        if (tag.func_150297_b(KEY_NBT, 9) && index < (list = (ListNBT)tag.func_74781_a(KEY_NBT)).size()) {
            return list.func_150305_b(index);
        }
        return null;
    }

    public static ArrayList<ResourceLocation> getPattern(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        int index = 0;
        if (tag.func_74764_b(KEY_INDEX)) {
            index = tag.func_74762_e(KEY_INDEX);
        }
        return ItemEnderDisk.getPattern(stack, index);
    }

    public static ArrayList<ResourceLocation> getPattern(ItemStack stack, int index) {
        ArrayList<ResourceLocation> output = new ArrayList<ResourceLocation>(8);
        CompoundNBT nbt = ItemEnderDisk.getCurrentCompound(stack, index);
        if (nbt != null) {
            int count = Math.min(nbt.func_74762_e(KEY_COUNT), 8);
            for (int i = 0; i < count; ++i) {
                output.add(new ResourceLocation(nbt.func_74779_i(KEY_ENTRY_PREFIX + i)));
            }
        }
        while (output.size() < 8) {
            output.add(new ResourceLocation("minecraft:air"));
        }
        return output;
    }

    public static ITextComponent getPatternName(ItemStack stack, int index) {
        CompoundNBT tag = stack.func_196082_o();
        ListNBT list = null;
        if (!tag.func_150297_b(KEY_NBT, 9)) {
            return new TranslationTextComponent("mana-and-artifice:ender_disc.unused");
        }
        list = tag.func_150295_c(KEY_NBT, 10);
        CompoundNBT nbt = null;
        if (index >= list.size()) {
            return new TranslationTextComponent("mana-and-artifice:ender_disc.unused");
        }
        nbt = list.func_150305_b(index);
        return new StringTextComponent(nbt.func_74779_i(KEY_NAME));
    }

    public static void setPattern(ItemStack stack, List<ResourceLocation> locations, int index, String name) {
        CompoundNBT tag = stack.func_196082_o();
        ListNBT list = null;
        list = tag.func_150297_b(KEY_NBT, 9) ? tag.func_150295_c(KEY_NBT, 10) : new ListNBT();
        while (list.size() < 7) {
            list.add((Object)new CompoundNBT());
        }
        CompoundNBT nbt = null;
        nbt = index < list.size() ? list.func_150305_b(index) : new CompoundNBT();
        nbt.func_74768_a(KEY_COUNT, locations.size());
        nbt.func_74778_a(KEY_NAME, name);
        int count = 0;
        for (ResourceLocation loc : locations) {
            nbt.func_74778_a(KEY_ENTRY_PREFIX + count++, loc.toString());
        }
        list.set(index, (INBT)nbt);
        stack.func_77978_p().func_218657_a(KEY_NBT, (INBT)list);
    }

    public static void setIndex(ItemStack stack, int index) {
        stack.func_196082_o().func_74768_a(KEY_INDEX, index);
    }

    public static int getIndex(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(KEY_INDEX);
        }
        return 0;
    }
}

