/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.api.items.ITieredItem;
import com.ma.items.ItemInit;
import com.ma.items.armor.MAArmorMaterial;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BrokenMageArmor
extends DyeableArmorItem
implements ITieredItem<BrokenMageArmor> {
    private static final String NBT_RESTORE = "previous_item";
    private static final String NBT_OTHER_ID = "previous_item_id";
    private int _tier = -1;

    public BrokenMageArmor(EquipmentSlotType slot) {
        super((IArmorMaterial)MAArmorMaterial.BROKEN, slot, new Item.Properties().func_200917_a(1).setNoRepair());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.broken_repair_prompt").func_240699_a_(TextFormatting.AQUA));
    }

    public static BrokenMageArmor getBySlot(EquipmentSlotType slot) {
        if (slot == null) {
            return null;
        }
        switch (slot) {
            case CHEST: {
                return (BrokenMageArmor)ItemInit.BROKEN_ROBES.get();
            }
            case FEET: {
                return (BrokenMageArmor)ItemInit.BROKEN_BOOTS.get();
            }
            case HEAD: {
                return (BrokenMageArmor)ItemInit.BROKEN_HOOD.get();
            }
            case LEGS: {
                return (BrokenMageArmor)ItemInit.BROKEN_LEGGINGS.get();
            }
        }
        return null;
    }

    public ItemStack convertFrom(ItemStack other) {
        if (!(other.func_77973_b() instanceof ArmorItem) || ((ArmorItem)other.func_77973_b()).func_185083_B_() != this.func_185083_B_()) {
            return ItemStack.field_190927_a;
        }
        ItemStack outputStack = new ItemStack((IItemProvider)this);
        if (other.func_77973_b() instanceof DyeableArmorItem) {
            ((DyeableArmorItem)other.func_77973_b()).func_200885_a(outputStack, ((DyeableArmorItem)other.func_77973_b()).func_200886_f(other));
        }
        CompoundNBT tag = outputStack.func_196082_o();
        if (other.func_77942_o()) {
            tag.func_218657_a(NBT_RESTORE, (INBT)other.func_77978_p());
        }
        tag.func_74778_a(NBT_OTHER_ID, other.func_77973_b().getRegistryName().toString());
        return outputStack;
    }

    public ItemStack restore(ItemStack me) {
        CompoundNBT tag = me.func_77978_p();
        if (tag == null) {
            return ItemStack.field_190927_a;
        }
        ResourceLocation restore = new ResourceLocation(tag.func_74779_i(NBT_OTHER_ID));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(restore);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack outputStack = new ItemStack((IItemProvider)item);
        if (tag.func_74764_b(NBT_RESTORE)) {
            outputStack.func_77982_d((CompoundNBT)tag.func_74781_a(NBT_RESTORE));
        }
        return outputStack;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public int getCachedtier() {
        return this._tier;
    }
}

