/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items;

import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.entities.manaweaving.EntityThrownManaweaveBottle;
import com.ma.items.renderers.ManaweaveBottleRenderer;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternSerializer;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemManaweaveBottle
extends TieredItem {
    private static final String KEY_PATTERN_ID = "pattern";

    public ItemManaweaveBottle() {
        super(new Item.Properties().func_200916_a(MAItemGroups.items).setISTER(() -> ManaweaveBottleRenderer::new));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (ManaweavingPattern p : ManaweavingPatternSerializer.ALL_RECIPES.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemManaweaveBottle.setPattern(p, stack);
                items.add((Object)stack);
            }
        }
    }

    public static boolean hasPattern(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_PATTERN_ID);
    }

    @Nullable
    public static ManaweavingPattern getPattern(ItemStack stack) {
        if (!ItemManaweaveBottle.hasPattern(stack)) {
            return null;
        }
        String patternID = stack.func_77978_p().func_74779_i(KEY_PATTERN_ID);
        Optional<ManaweavingPattern> pattern = ManaweavingPatternSerializer.ALL_RECIPES.values().stream().filter(p -> p.func_199560_c().toString().equals(patternID)).findFirst();
        return pattern.orElse(null);
    }

    public static void setPattern(ManaweavingPattern pattern, ItemStack stack) {
        stack.func_196082_o().func_74778_a(KEY_PATTERN_ID, pattern.func_199560_c().toString());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TranslationTextComponent baseline = new TranslationTextComponent(this.func_77667_c(stack));
        if (ItemManaweaveBottle.hasPattern(stack)) {
            String patternName = new TranslationTextComponent(stack.func_77978_p().func_74779_i(KEY_PATTERN_ID)).getString();
            baseline.func_230529_a_((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweave_bottle.suffix", new Object[]{patternName}));
        }
        return baseline;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            EntityThrownManaweaveBottle potionentity = new EntityThrownManaweaveBottle(worldIn, (LivingEntity)playerIn);
            potionentity.func_213884_b(itemstack);
            potionentity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, -20.0f, 0.5f, 1.0f);
            worldIn.func_217376_c((Entity)potionentity);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResult.func_233538_a_((Object)itemstack, (boolean)worldIn.func_201670_d());
    }
}

