/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory.stack_extension;

import com.ma.ManaAndArtifice;
import com.ma.inventory.stack_extension.SlotInfoTable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import org.apache.logging.log4j.Logger;

public class ItemStackEntry {
    public static Codec<ItemStackEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.field_234691_a_.fieldOf("item").forGetter(o -> o.stack), (App)Codec.LONG.fieldOf("count").forGetter(o -> o.count), (App)SlotInfoTable.CODEC.optionalFieldOf("info").forGetter(o -> o.info == null || o.info.isEmpty() ? Optional.empty() : Optional.of(o.info))).apply((Applicative)instance, (a, b, c) -> new ItemStackEntry((ItemStack)a, (long)b, c.orElse(new SlotInfoTable()))));
    public static ItemStackEntry EMPTY = new ItemStackEntry(ItemStack.field_190927_a);
    private ItemStack stack;
    private long count;
    private SlotInfoTable info;

    public ItemStackEntry(ItemStack stack) {
        this.stack = stack;
        this.count = stack.func_190916_E();
        this.info = null;
    }

    private ItemStackEntry(ItemStack stack, long count, SlotInfoTable info) {
        this.stack = stack;
        this.count = count;
        this.info = info;
    }

    public ItemStack getStackOriginal() {
        return this.stack;
    }

    public ItemStack getStackCopy() {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_190920_e((int)this.count);
        return copy;
    }

    public ItemStack extract(int count) {
        if ((long)count > this.count) {
            count = (int)this.count;
        }
        if (this.stack.func_190916_E() == count) {
            this.count = 0L;
            ItemStack result = this.stack;
            this.stack = ItemStack.field_190927_a;
            return result;
        }
        ItemStack copy = this.getStackCopy();
        copy.func_190920_e(count);
        this.count -= (long)count;
        return copy;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
        this.stack.func_190920_e((int)this.count);
    }

    public void grow(long count) {
        this.count += count;
        this.stack.func_190920_e((int)this.count);
    }

    public SlotInfoTable getInfo() {
        return this.info;
    }

    public boolean isEmpty() {
        if (this.stack.func_190926_b()) {
            return true;
        }
        return this.count == 0L && this.info.isEmpty();
    }

    public INBT serialize() {
        return (INBT)((DataResult)NBTDynamicOps.field_210820_a.withEncoder(CODEC).apply(this)).getOrThrow(false, arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0));
    }

    public static ItemStackEntry deserialize(INBT tag) {
        if (tag == null) {
            return EMPTY;
        }
        return (ItemStackEntry)CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0));
    }
}

