/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory.stack_extension;

import com.ma.gui.containers.IExtendedItemHandler;
import com.ma.inventory.stack_extension.IInventoryListener;
import com.ma.inventory.stack_extension.ItemStackEntry;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AbstractItemHandler
implements IExtendedItemHandler {
    protected NonNullList<ItemStackEntry> stacks;
    protected Set<IInventoryListener> listeners = new HashSet<IInventoryListener>();

    public AbstractItemHandler() {
        this(1);
    }

    public AbstractItemHandler(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStackEntry.EMPTY);
    }

    public AbstractItemHandler(NonNullList<ItemStackEntry> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void enlarge(int size) {
        if (size < this.stacks.size()) {
            throw new RuntimeException("Cannot reduce the size of an AbstractItemHandler, currently contains: " + this.stacks.size() + " slots, cannot reduce to " + size + " slots");
        }
        if (size == this.stacks.size()) {
            return;
        }
        NonNullList newList = NonNullList.func_191197_a((int)size, (Object)ItemStackEntry.EMPTY);
        for (int i = 0; i < this.stacks.size(); ++i) {
            newList.set(i, this.stacks.get(i));
        }
        this.stacks = newList;
    }

    public abstract int getSlotLimit(int var1);

    public int getSlotLimit(int slot, ItemStack stack) {
        return this.getSlotLimit(slot);
    }

    @Override
    public int size() {
        return this.stacks.size();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)new ItemStackEntry(stack));
        this.onContentsChanged(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemStackEntry)this.stacks.get(slot)).getStackOriginal();
    }

    @Override
    public long getCountInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemStackEntry)this.stacks.get(slot)).getCount();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStackEntry entry = (ItemStackEntry)this.stacks.get(slot);
        ItemStack existing = entry.getStackOriginal();
        int limit = this.getSlotLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                if (reachedLimit) {
                    entry = new ItemStackEntry(stack.func_77946_l());
                    entry.setCount(limit);
                    this.stacks.set(slot, (Object)entry);
                } else {
                    entry = new ItemStackEntry(stack);
                    this.stacks.set(slot, (Object)entry);
                }
            } else {
                entry.grow(stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStackEntry entry = (ItemStackEntry)this.stacks.get(slot);
        ItemStack existing = entry.getStackOriginal();
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStackEntry.EMPTY);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            entry = new ItemStackEntry(ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.stacks.set(slot, (Object)entry);
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public abstract boolean isItemValid(int var1, @Nonnull ItemStack var2);

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public void onContentsChanged(int slot) {
        for (IInventoryListener listener : this.listeners) {
            listener.inventoryChanged(this, slot);
        }
    }

    @Override
    public void addListener(IInventoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT result = new CompoundNBT();
        result.func_74768_a("slots", this.size());
        for (int i = 0; i < this.size(); ++i) {
            ItemStackEntry entry = (ItemStackEntry)this.stacks.get(i);
            if (entry.isEmpty()) continue;
            result.func_218657_a("" + i, entry.serialize());
        }
        return result;
    }

    @Override
    public void deserialize(CompoundNBT result) {
        int size = result.func_74762_e("slots");
        this.enlarge(Math.max(size, this.size()));
        for (int i = 0; i < size; ++i) {
            ItemStackEntry entry = ItemStackEntry.deserialize(result.func_74781_a("" + i));
            this.stacks.set(i, (Object)entry);
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

