/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ma.ManaAndArtifice;
import com.ma.api.guidebook.IGuideBookRegistry;
import com.ma.api.guidebook.RegisterGuidebooksEvent;
import com.ma.guide.EntryCategories;
import com.ma.guide.GuidebookEntry;
import com.ma.guide.RelatedRecipe;
import com.ma.guide.sections.TextSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuideBookEntries
implements IGuideBookRegistry {
    public static final GuideBookEntries INSTANCE = new GuideBookEntries();
    private Map<String, GuidebookEntry> _entries;
    private List<ResourceLocation> guidebookPaths;
    private boolean hasLoaded = false;
    private String lastLanguage = "";
    private boolean lastUnicode = false;
    ResourceLocation _default = new ResourceLocation("mana-and-artifice", "guide/en_us.json");
    ResourceLocation _default_packadds = new ResourceLocation("mana-and-artifice", "guide/pack_adds/en_us.json");

    private GuideBookEntries() {
        this.guidebookPaths = new ArrayList<ResourceLocation>();
        this._entries = new HashMap<String, GuidebookEntry>();
        this.guidebookPaths.add(new ResourceLocation("mana-and-artifice", "guide"));
        MinecraftForge.EVENT_BUS.post((Event)new RegisterGuidebooksEvent(this));
    }

    public GuidebookEntry getEntry(String id) {
        return this._entries.get(id);
    }

    public Collection<GuidebookEntry> getEntries() {
        return this._entries.values();
    }

    public Collection<GuidebookEntry> getEntries(EntryCategories category) {
        ArrayList<GuidebookEntry> matches = new ArrayList<GuidebookEntry>();
        for (GuidebookEntry e : this._entries.values()) {
            if (e.getCategory() != category) continue;
            matches.add(e);
        }
        return matches;
    }

    public Set<Map.Entry<String, GuidebookEntry>> getAllEntries() {
        return this._entries.entrySet();
    }

    public List<GuidebookSearchResult> searchEntries(String query, int tier, int limit) {
        String lowerQuery = query.toLowerCase();
        Minecraft m = Minecraft.func_71410_x();
        List matchingContents = this._entries.values().stream().filter(e -> e.getTier() <= tier).filter(e -> e.getSections().stream().anyMatch(s -> s instanceof TextSection && ((TextSection)s).getRawText().toLowerCase().contains(lowerQuery))).collect(Collectors.toList());
        HashMap relatedRecipes = new HashMap();
        this._entries.values().forEach(e -> e.getRelatedRecipes().stream().filter(r -> r.getTier() <= tier).forEach(r -> {
            block0: for (ItemStack is : r.getOutputItems((World)m.field_71441_e)) {
                if (is.func_190926_b()) continue;
                if (is.func_77948_v()) {
                    Map map = EnchantmentHelper.func_82781_a((ItemStack)is);
                    for (Map.Entry ench : map.entrySet()) {
                        if (!((Enchantment)ench.getKey()).func_200305_d(((Integer)ench.getValue()).intValue()).getString().toLowerCase().contains(lowerQuery)) continue;
                        relatedRecipes.put(r, is);
                        continue block0;
                    }
                    continue;
                }
                if (!is.func_200301_q().getString().toLowerCase().contains(lowerQuery)) continue;
                relatedRecipes.put(r, is);
                break;
            }
        }));
        List results = relatedRecipes.entrySet().stream().map(r -> new GuidebookSearchResult((RelatedRecipe)r.getKey(), (ItemStack)r.getValue())).collect(Collectors.toList());
        results.addAll(matchingContents.stream().map(e -> new GuidebookSearchResult((GuidebookEntry)e)).collect(Collectors.toList()));
        return results.stream().filter(this.distinctByKey(GuidebookSearchResult::toString)).limit(limit).collect(Collectors.toList());
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private void readEntries(IResourceManager resourceManager, ResourceLocation rLoc) {
        try {
            BufferedReader reader;
            IResource res;
            InputStream in;
            if (resourceManager.func_219533_b(rLoc) && (in = (res = resourceManager.func_199002_a(rLoc)).func_199027_b()) != null && (reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8))) != null) {
                JsonElement obj = new JsonParser().parse((Reader)reader);
                if (obj != null && obj.isJsonObject()) {
                    this.parseJSON(obj.getAsJsonObject());
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException ex) {
            ManaAndArtifice.LOGGER.catching((Throwable)ex);
        }
    }

    private void parseJSON(JsonObject obj) {
        for (Map.Entry elem : obj.getAsJsonObject().entrySet()) {
            if (!((JsonElement)elem.getValue()).isJsonObject()) continue;
            this._entries.put((String)elem.getKey(), new GuidebookEntry(((JsonElement)elem.getValue()).getAsJsonObject(), (String)elem.getKey()));
        }
    }

    private void readAndParseGuidebooks(IResourceManager resourceManager) {
        Minecraft mc = Minecraft.func_71410_x();
        for (ResourceLocation rLoc : this.guidebookPaths) {
            ResourceLocation rLoc_packAdds;
            String guidebook_localized = String.format("%s.json", mc.field_71474_y.field_74363_ab);
            ResourceLocation rLoc_localized = new ResourceLocation(rLoc.func_110624_b(), rLoc.func_110623_a() + "/" + guidebook_localized);
            if (rLoc_localized.compareTo(this._default) != 0) {
                this.readEntries(resourceManager, rLoc_localized);
            }
            if ((rLoc_packAdds = new ResourceLocation(rLoc.func_110624_b(), rLoc.func_110623_a() + "/pack_adds/" + guidebook_localized)).compareTo(this._default_packadds) == 0) continue;
            this.readEntries(resourceManager, rLoc_packAdds);
        }
    }

    public void reload() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.hasLoaded && this.lastLanguage == mc.field_71474_y.field_74363_ab && mc.func_211821_e() == this.lastUnicode) {
            return;
        }
        IResourceManager resourceManager = mc.func_195551_G();
        this._entries.clear();
        this.readEntries(resourceManager, this._default);
        this.readEntries(resourceManager, this._default_packadds);
        this.readAndParseGuidebooks(resourceManager);
        this.hasLoaded = true;
        this.lastLanguage = mc.field_71474_y.field_74363_ab;
        this.lastUnicode = mc.func_211821_e();
    }

    @Override
    public void addGuidebookPath(ResourceLocation resourceLocation) {
        this.guidebookPaths.add(resourceLocation);
    }

    public class GuidebookSearchResult {
        private GuidebookEntry _entry;
        private RelatedRecipe _recipe;
        private ItemStack _output;

        public GuidebookSearchResult(GuidebookEntry entry) {
            this._entry = entry;
            this._output = ItemStack.field_190927_a;
        }

        public GuidebookSearchResult(RelatedRecipe recipe, ItemStack output) {
            this._recipe = recipe;
            this._output = output;
        }

        @Nullable
        public GuidebookEntry getEntry() {
            return this._entry;
        }

        public boolean isEntry() {
            return this._entry != null;
        }

        @Nullable
        public RelatedRecipe getRecipe() {
            return this._recipe;
        }

        public ItemStack getOutputStack() {
            return this._output;
        }

        public boolean isRecipe() {
            return this._recipe != null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GuidebookSearchResult) {
                GuidebookSearchResult other = (GuidebookSearchResult)obj;
                if (this.isEntry() && other.isEntry()) {
                    return this.getEntry().equals(other.getEntry());
                }
                if (this.isRecipe() && other.isRecipe()) {
                    return this.getRecipe().equals(other.getRecipe());
                }
            }
            return false;
        }

        public String toString() {
            if (this.isEntry()) {
                return this._entry.toString();
            }
            return this._recipe.toString();
        }
    }
}

