/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.radial;

import com.google.common.collect.Lists;
import com.ma.KeybindInit;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.parts.Modifier;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.events.ClientEventHandler;
import com.ma.gui.radial.GenericRadialMenu;
import com.ma.gui.radial.components.BlitRadialMenuItem;
import com.ma.gui.radial.components.IRadialMenuHost;
import com.ma.gui.radial.components.RadialMenuItem;
import com.ma.items.ItemInit;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.RecipeInit;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModifierSelectionScreen
extends Screen {
    private ItemStack stackEquipped;
    private List<Modifier> knownModifiers;
    private boolean needsRecheckStacks = true;
    private final List<BlitRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;
    private Minecraft mc = Minecraft.func_71410_x();

    public ModifierSelectionScreen() {
        super((ITextComponent)new StringTextComponent("RADIAL MENU"));
        this.knownModifiers = new ArrayList<Modifier>();
        this.stackEquipped = this.mc.field_71439_g.func_184614_ca();
        if (this.stackEquipped.func_77973_b() == ItemInit.MODIFIER_BOOK.get()) {
            int tier = ((IPlayerProgression)this.mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier();
            this.knownModifiers.addAll(this.mc.field_71439_g.field_70170_p.func_199532_z().func_241447_a_(RecipeInit.MODIFIER_TYPE).stream().filter(m -> m.getTier() <= tier).map(m -> (Modifier)m.getComponent()).collect(Collectors.toList()));
        } else {
            this.func_231175_as__();
        }
        this.menu = new GenericRadialMenu(Minecraft.func_71410_x(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(MatrixStack matrixStack, ItemStack stack, int mouseX, int mouseY) {
                ModifierSelectionScreen.this.func_230457_a_(matrixStack, stack, mouseX, mouseY);
            }

            @Override
            public void renderTooltip(MatrixStack matrixStack, ITextComponent text, int mouseX, int mouseY) {
                ModifierSelectionScreen.this.func_238652_a_(matrixStack, text, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return ModifierSelectionScreen.this;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return ModifierSelectionScreen.this.field_230712_o_;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return ModifierSelectionScreen.this.field_230707_j_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof ModifierSelectionScreen) {
            event.setCanceled(true);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ClientEventHandler.wipeOpen();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.func_71410_x().func_147108_a(null);
            ClientEventHandler.wipeOpen();
        }
        if (!this.menu.isReady() || this.knownModifiers == null || this.knownModifiers.size() == 0) {
            return;
        }
        ItemStack inHand = this.field_230706_i_.field_71439_g.func_184614_ca();
        if (inHand.func_77973_b() != ItemInit.MODIFIER_BOOK.get()) {
            this.knownModifiers.clear();
        }
        if (this.knownModifiers.size() == 0) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!ClientEventHandler.isKeyDown(KeybindInit.spellBookSelectWheelOpen)) {
            this.processClick(false);
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.knownModifiers == null || this.knownModifiers.size() == 0) {
            return;
        }
        ItemStack inHand = this.field_230706_i_.field_71439_g.func_184614_ca();
        if (inHand.func_77973_b() != ItemInit.MODIFIER_BOOK.get()) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.knownModifiers.size(); ++i) {
                final Modifier m = this.knownModifiers.get(i);
                int index = i;
                BlitRadialMenuItem item = new BlitRadialMenuItem(this.menu, i, m.getGuiIcon(), 0, 0, 16, 16, 16, 16, (ITextComponent)new TranslationTextComponent(m.getRegistryName().toString())){

                    @Override
                    public boolean onClick() {
                        ClientMessageDispatcher.sendSelectedModifierMessage(m);
                        ModifierSelectionScreen.this.menu.close();
                        return true;
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.needsRecheckStacks = false;
        }
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.spellbook.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

