/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.item;

import com.ma.api.cantrips.ICantrip;
import com.ma.api.capabilities.IPlayerCantrip;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.sound.SFX;
import com.ma.cantrips.CantripRegistry;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.gui.containers.item.ContainerCantrips;
import com.ma.gui.item.GuiGuideBook;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class GuiCantrips
extends ContainerScreen<ContainerCantrips> {
    ArrayList<ManaweavingPattern> playerKnownPatterns;
    IPlayerProgression progression;
    IPlayerMagic magic;
    int numPages;
    int page;
    Point[] buttonPositions = new Point[]{new Point(13, 39), new Point(13, 93), new Point(13, 147), new Point(134, 39), new Point(134, 93), new Point(134, 147)};
    Point[] cantripPositions;
    HashMap<ResourceLocation, Integer[]> cantripPatterns;
    int patternSpacing = 40;

    public GuiCantrips(ContainerCantrips screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playerKnownPatterns = new ArrayList();
        this.progression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.magic = (IPlayerMagic)this.field_230706_i_.field_71439_g.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.field_230706_i_.field_71441_e.func_199532_z().func_241447_a_(RecipeInit.MANAWEAVING_PATTERN_TYPE).stream().forEach(p -> {
            if (p.getTier() <= this.progression.getTier()) {
                this.playerKnownPatterns.add((ManaweavingPattern)p);
            }
        });
        this.cantripPatterns = new HashMap();
        RecipeManager clientRecipeManager = this.field_230706_i_.field_71441_e.func_199532_z();
        CantripRegistry.INSTANCE.getCantrips(this.progression.getTier()).forEach(cantrip -> {
            if (cantrip.getTier() > this.progression.getTier()) {
                return;
            }
            this.cantripPatterns.put(cantrip.getId(), new Integer[3]);
            for (int j = 0; j < 3; ++j) {
                Optional<IPlayerCantrip> playerCantrip = this.magic.getCantripData().getCantrip(cantrip.getId());
                Optional pattern = clientRecipeManager.func_215367_a(playerCantrip.get().getPattern(j));
                this.cantripPatterns.get((Object)cantrip.getId())[j] = pattern.isPresent() && pattern.get() instanceof ManaweavingPattern ? Integer.valueOf(pattern != null ? this.playerKnownPatterns.indexOf(pattern.get()) : -1) : Integer.valueOf(-1);
            }
        });
        this.numPages = (int)Math.ceil(this.cantripPatterns.size() / 6);
        this.setupPage(0);
    }

    private List<ICantrip> getCantripsForPage(int page) {
        if (page > this.numPages) {
            return new ArrayList<ICantrip>();
        }
        int skip = page * this.buttonPositions.length;
        if (skip >= this.cantripPatterns.size()) {
            return new ArrayList<ICantrip>();
        }
        return CantripRegistry.INSTANCE.getCantrips(this.progression.getTier()).stream().skip(skip).limit(6L).collect(Collectors.toList());
    }

    private void setupPage(int page) {
        int i;
        this.page = page;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        List<ICantrip> cantrips = this.getCantripsForPage(page);
        for (i = 0; i < cantrips.size(); ++i) {
            this.initRowSelectionButtons(this.buttonPositions[i].x, this.buttonPositions[i].y, cantrips.get(i));
        }
        ((ContainerCantrips)this.field_147002_h).enableSlotsForPage(page);
        i = this.field_147003_i;
        int j = this.field_147009_r;
        if (this.page > 0) {
            this.func_230480_a_((Widget)new PaperImageButton(i + 10, j + 158, 14, 14, 0, 178, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.setupPage(this.page - 1)));
        }
        if (this.page < this.numPages) {
            this.func_230480_a_((Widget)new PaperImageButton(i + 233, j + 158, 14, 14, 14, 178, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.setupPage(this.page + 1)));
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.cantripPatterns.entrySet().forEach(data -> {
            int patternIndex;
            ArrayList<ResourceLocation> patternIDs = new ArrayList<ResourceLocation>();
            for (int j = 0; j < ((Integer[])data.getValue()).length && (patternIndex = ((Integer[])data.getValue())[j].intValue()) >= 0 && patternIndex < this.playerKnownPatterns.size(); ++j) {
                patternIDs.add(this.playerKnownPatterns.get(patternIndex).func_199560_c());
            }
            this.magic.getCantripData().setPattern((ResourceLocation)data.getKey(), patternIDs);
        });
        ClientMessageDispatcher.sendCantripUpdateMessage(this.magic);
    }

    private void initRowSelectionButtons(int x, int y, ICantrip cantrip) {
        int i = 0;
        while (i < 3) {
            int count = i++;
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + x, this.field_147009_r + y, 3, 5, 3, 242, 5, GuiTextures.CANTRIP_BOOK, 256, 256, button -> {
                int idx = this.cantripPatterns.get(cantrip.getId())[count] - 1;
                if (idx < (count < 2 ? 0 : -1)) {
                    idx = this.playerKnownPatterns.size() - 1;
                }
                this.cantripPatterns.get((Object)cantrip.getId())[count] = idx;
            }));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + x + 25, this.field_147009_r + y, 3, 5, 0, 242, 5, GuiTextures.CANTRIP_BOOK, 256, 256, button -> {
                int idx = this.cantripPatterns.get(cantrip.getId())[count] + 1;
                if (idx >= this.playerKnownPatterns.size()) {
                    idx = count < 2 ? 0 : -1;
                }
                this.cantripPatterns.get((Object)cantrip.getId())[count] = idx;
            }));
            x += this.patternSpacing;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        MutableObject tt = new MutableObject(null);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.CANTRIP_BOOK);
        int topLeftCornerX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int topLeftCornerY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, topLeftCornerX, topLeftCornerY, 0, 0, 256, 178);
        this.func_238474_b_(matrixStack, topLeftCornerX + 47, topLeftCornerY + 178, 94, 178, 162, 76);
        this.calculateCantripPositions();
        MutableInt index = new MutableInt(0);
        this.getCantripsForPage(this.page).stream().forEach(cantrip -> {
            Point pt = this.cantripPositions[index.getAndIncrement()];
            if (this.renderCantripBGAt((ICantrip)cantrip, pt.x, pt.y, mouseX, mouseY, matrixStack)) {
                tt.setValue(cantrip);
            }
            this.drawManaweavePatternCombo(matrixStack, pt.x + 13, pt.y + 29, this.cantripPatterns.get(cantrip.getId()));
        });
        if (tt.getValue() != null) {
            this.renderCantripTooltip(matrixStack, (ICantrip)tt.getValue(), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    private void calculateCantripPositions() {
        int topLeftCornerX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int topLeftCornerY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int pageY = topLeftCornerY + 5;
        this.cantripPositions = new Point[]{new Point(topLeftCornerX + 20, pageY), new Point(topLeftCornerX + 20, pageY + 54), new Point(topLeftCornerX + 20, pageY + 108), new Point(topLeftCornerX + 141, pageY), new Point(topLeftCornerX + 141, pageY + 54), new Point(topLeftCornerX + 141, pageY + 108)};
    }

    private boolean renderCantripBGAt(ICantrip cantrip, int x, int y, int mouseX, int mouseY, MatrixStack matrixStack) {
        boolean hovered = false;
        if (this.progression.getTier() >= cantrip.getTier()) {
            this.field_230706_i_.field_71446_o.func_110577_a(GuiTextures.CANTRIP_BOOK);
            for (int i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, x - 2 + this.patternSpacing * i, y + 27, 64, 178, 18, 18);
            }
            if (cantrip.isStackLocked()) {
                x += 35;
            } else {
                this.func_238474_b_(matrixStack, x + 38, y + 3, 64, 178, 18, 18);
            }
            this.field_230706_i_.field_71446_o.func_110577_a(cantrip.getIcon());
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)24, (int)24, (int)24, (int)24);
            if (this.isMouseWithin(x, y, x + 32, y + 32, mouseX, mouseY)) {
                hovered = true;
            }
        }
        return hovered;
    }

    private boolean isMouseWithin(int x, int y, int x2, int y2, int mouseX, int mouseY) {
        return x <= mouseX && x2 >= mouseX && y <= mouseY && y2 >= mouseY;
    }

    private void renderCantripTooltip(MatrixStack stack, ICantrip cantrip, int mouseX, int mouseY) {
        ArrayList<IFormattableTextComponent> ttLines = new ArrayList<IFormattableTextComponent>();
        ttLines.add(new TranslationTextComponent("cantrip." + cantrip.getId().toString().replace(":", ".")).func_240699_a_(TextFormatting.LIGHT_PURPLE));
        ttLines.add(new TranslationTextComponent("cantrip.mana-and-artifice.tier", new Object[]{cantrip.getTier()}).func_240699_a_(TextFormatting.AQUA));
        ttLines.add(new TranslationTextComponent("cantrip." + cantrip.getId().toString().replace(":", ".") + ".desc").func_240699_a_(TextFormatting.ITALIC));
        this.func_243308_b(stack, ttLines, mouseX, mouseY);
    }

    private void drawManaweavePatternCombo(MatrixStack matrixStack, int x, int y, Integer[] patterns) {
        GuiRenderUtils.bindManaweaveTextureRenderer();
        float scale = 0.1f;
        for (int i = 0; i < patterns.length; ++i) {
            Integer index = patterns[i];
            if (index != null && index >= 0) {
                ManaweavingPattern p = this.playerKnownPatterns.get(index);
                GuiRenderUtils.renderManaweavePattern(matrixStack, (int)((float)x / scale), (int)((float)y / scale), scale, p);
            }
            x += this.patternSpacing;
        }
    }

    public class PaperImageButton
    extends ImageButton {
        private ITextComponent tooltip;

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51136_9_, int p_i51136_10_, Button.IPressable onPressIn, ITextComponent textIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51136_9_, p_i51136_10_, onPressIn, textIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
        }

        public PaperImageButton setTooltip(ITextComponent tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.field_230693_o_ && this.field_230694_p_ && this.func_230449_g_() && this.tooltip != null) {
                GuiGuideBook.currentTooltip.add(this.tooltip);
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }
}

