/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.gui.containers.ContainerInit;
import com.ma.gui.containers.LargeContainer;
import com.ma.gui.containers.slots.ExtendedItemStackFilterSlot;
import com.ma.gui.containers.slots.ExtendedItemStackSlot;
import com.ma.inventory.InventoryRitualKit;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerPractitionersPouch
extends LargeContainer {
    private InventoryRitualKit inventory;
    public int bagHash;
    protected int mySlot;
    private int myPlayerIndex;
    private HashMap<PractitionersPouchPatches, ArrayList<ExtendedItemStackFilterSlot>> patchSlots;

    public ContainerPractitionersPouch(int i, PlayerInventory playerInventory) {
        this(i, playerInventory, new InventoryRitualKit(playerInventory.func_70301_a(playerInventory.field_70461_c)));
    }

    public ContainerPractitionersPouch(int i, PlayerInventory playerInv, InventoryRitualKit kitInv) {
        super(ContainerInit.RITUAL_KIT, i, playerInv, kitInv);
        this.inventory = kitInv;
        this.bagHash = kitInv.getStack().hashCode();
        this.myPlayerIndex = playerInv.field_70461_c;
        this.patchSlots = new HashMap();
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(PlayerInventory playerInv) {
        int col;
        int slotIndex = 0;
        int bagSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 7; ++col) {
                this.func_75146_a((Slot)new ExtendedItemStackSlot(this.inventory, bagSlotIndex++, 18 + col * 18, 75 + row * 18));
                ++slotIndex;
            }
        }
        PractitionersPouchPatches[] patches = PractitionersPouchPatches.values();
        for (int i = 0; i < patches.length; ++i) {
            PractitionersPouchPatches patch = patches[i];
            if (!patch.hasInventory()) continue;
            ArrayList<ExtendedItemStackFilterSlot> patchSlotList = new ArrayList<ExtendedItemStackFilterSlot>();
            for (int row = 0; row < patch.getInventoryRows(); ++row) {
                for (int col2 = 0; col2 < patch.getInventoryCols(); ++col2) {
                    ExtendedItemStackFilterSlot patchSlot = new ExtendedItemStackFilterSlot(this.inventory, bagSlotIndex++, 164 + col2 * 18, patch.getRowStart() + row * 18, patch.getSlotFilter());
                    if (playerInv.field_70458_d.field_70170_p.field_72995_K) {
                        patchSlot.setActive(false);
                    }
                    this.func_75146_a((Slot)patchSlot);
                    patchSlotList.add(patchSlot);
                    ++slotIndex;
                }
            }
            this.patchSlots.put(patch, patchSlotList);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col3 = 0; col3 < 9; ++col3) {
                this.func_75146_a(new Slot((IInventory)playerInv, col3 + row * 9 + 9, 48 + col3 * 18, 144 + row * 18));
                ++slotIndex;
            }
        }
        for (col = 0; col < 9; ++col) {
            if (col == playerInv.field_70461_c) {
                this.mySlot = slotIndex;
            }
            this.func_75146_a(new Slot((IInventory)playerInv, col, 48 + col * 18, 202));
            ++slotIndex;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPatchActive(PractitionersPouchPatches patch) {
        this.patchSlots.entrySet().forEach(e -> ((ArrayList)e.getValue()).forEach(v -> v.setActive(false)));
        if (patch != null && this.patchSlots.containsKey((Object)patch)) {
            this.patchSlots.get((Object)patch).forEach(s -> s.setActive(true));
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity p_75145_1_) {
        return true;
    }

    public boolean patchEnabled(PractitionersPouchPatches patch, int level) {
        return ((ItemPractitionersPouch)this.inventory.getStack().func_77973_b()).getPatchLevel(this.inventory.getStack(), patch) >= level;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.inventory.writeItemStack();
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId == this.mySlot || clickTypeIn == ClickType.SWAP && dragType == this.myPlayerIndex) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int mainSlots = 21;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < mainSlots ? !this.func_75135_a(itemstack1, mainSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, mainSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    @Override
    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean wrap) {
        boolean flag = false;
        int i = startIndex;
        if (wrap) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!wrap ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && ContainerPractitionersPouch.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = slot.func_75219_a())) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (wrap) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = wrap ? endIndex - 1 : startIndex;
            while (!(!wrap ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (wrap) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }
}

