/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.gui.containers.ContainerInit;
import com.ma.items.artifice.ItemEnderDisk;
import com.ma.network.ClientMessageDispatcher;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ContainerEnderDisc
extends Container {
    public ItemStack heldItem;
    private ArrayList<EnderDiscPattern> _patterns;
    private byte[] dirty;
    private int _curIndex = 0;

    private ContainerEnderDisc(@Nullable ContainerType<?> type, int id, PlayerInventory playerInv, ItemStack heldItem) {
        super(type, id);
        this.heldItem = heldItem;
        this._curIndex = MathUtils.clamp(ItemEnderDisk.getIndex(this.heldItem), 0, 7);
        this.dirty = new byte[7];
        this._patterns = new ArrayList();
        for (int i = 0; i < this.dirty.length; ++i) {
            this.dirty[i] = 0;
            this._patterns.add(EnderDiscPattern.fromStack(this.heldItem, i));
        }
    }

    public ContainerEnderDisc(int i, PlayerInventory playerInv) {
        this(ContainerInit.ENDER_DISC, i, playerInv, playerInv.func_70301_a(playerInv.field_70461_c));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void changePatternIndex(int newIndex) {
        if (newIndex >= 0 && newIndex < this._patterns.size()) {
            this._curIndex = newIndex;
        }
    }

    public ArrayList<ResourceLocation> getCurPattern() {
        return this._patterns.get((int)this._curIndex)._pattern;
    }

    public int getCurPatternIndex() {
        return this._curIndex;
    }

    public String getCurPatternName() {
        return this._patterns.get((int)this._curIndex)._name;
    }

    public void setPattern(ResourceLocation pattern, int index) {
        if (index < 0 || index >= 8) {
            return;
        }
        this._patterns.get((int)this._curIndex)._pattern.set(index, pattern);
        this.dirty[this._curIndex] = 1;
    }

    public void setName(String name) {
        this._patterns.get((int)this._curIndex)._name = name;
        this.dirty[this._curIndex] = 1;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (playerIn.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.dirty.length; ++i) {
                if (this.dirty[i] != 1) continue;
                ClientMessageDispatcher.sendEnderDiscPatternChange(this._patterns.get((int)i)._pattern, i, this._patterns.get((int)i)._name);
            }
            ClientMessageDispatcher.sendEnderDiscIndexChange(this._curIndex);
        }
    }

    public String getPatternName(int index) {
        if (index < 0 || index >= this._patterns.size()) {
            return "";
        }
        return this._patterns.get((int)index)._name;
    }

    static class EnderDiscPattern {
        ArrayList<ResourceLocation> _pattern;
        String _name = "";

        EnderDiscPattern() {
        }

        static EnderDiscPattern fromStack(ItemStack stack, int index) {
            EnderDiscPattern pattern = new EnderDiscPattern();
            pattern._pattern = ItemEnderDisk.getPattern(stack, index);
            pattern._name = ItemEnderDisk.getPatternName(stack, index).getString();
            return pattern;
        }
    }
}

