/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.block;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.gui.containers.ContainerInit;
import com.ma.gui.containers.slots.InscriptionTableOutputSlot;
import com.ma.gui.containers.slots.SingleItemSlot;
import com.ma.items.ItemInit;
import com.ma.recipes.spells.ComponentRecipe;
import com.ma.recipes.spells.ModifierRecipe;
import com.ma.recipes.spells.ShapeRecipe;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.tools.MATags;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerInscriptionTable
extends Container {
    private final IItemHandler inventory;
    private final InscriptionTableTile table;
    public static int SIZE = 4;
    static int rowLength = 9;
    static int rowCount = 3;
    private HashMap<Item, Integer> cachedReagentList;

    public ContainerInscriptionTable(int i, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(i, playerInventory, ((InscriptionTableTile)playerInventory.field_70458_d.field_70170_p.func_175625_s(packetBuffer.func_179259_c())).readFrom(packetBuffer));
    }

    public ContainerInscriptionTable(int windowId, PlayerInventory playerInventory, InscriptionTableTile inventory) {
        super((ContainerType)ContainerInit.INSCRIPTION_TABLE.get(), windowId);
        int xpos;
        this.inventory = new InvWrapper((IInventory)inventory);
        this.table = inventory;
        inventory.func_174889_b(playerInventory.field_70458_d);
        this.cachedReagentList = new HashMap();
        this.func_75146_a((Slot)new SingleItemSlot(this.inventory, 0, 8, 8, (Item)ItemInit.ARCANIST_INK.get()));
        this.func_75146_a((Slot)new SingleItemSlot(this.inventory, 1, 33, 8, (Item)ItemInit.VELLUM.get()));
        this.func_75146_a((Slot)new SingleItemSlot(this.inventory, 2, 58, 8, (Item)ItemInit.ARCANE_ASH.get()));
        this.func_75146_a(new InscriptionTableOutputSlot(playerInventory.field_70458_d, inventory, 3, 232, 8));
        for (xpos = 0; xpos < 3; ++xpos) {
            for (int ypos = 0; ypos < 9; ++ypos) {
                this.func_75146_a(new Slot((IInventory)playerInventory, ypos + xpos * 9 + 9, 48 + ypos * 18, 174 + xpos * 18));
            }
        }
        for (xpos = 0; xpos < 9; ++xpos) {
            this.func_75146_a(new Slot((IInventory)playerInventory, xpos, 48 + xpos * 18, 232));
        }
        this.cacheCurrentReagents(playerInventory.field_70458_d.field_70170_p);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        BlockPos pos = this.table.func_174877_v();
        return pos.func_177951_i((Vector3i)playerIn.func_233580_cy_()) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < SIZE ? !this.func_75135_a(itemstack1, SIZE, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, SIZE, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void setCurrentShape(Shape shape, World world) {
        if (this.table != null) {
            this.table.setCurrentShape(shape);
            this.cacheCurrentReagents(world);
        }
    }

    public void setCurrentComponent(Component component, World world) {
        if (this.table != null) {
            this.table.setCurrentComponent(component);
            this.cacheCurrentReagents(world);
        }
    }

    public void setCurrentModifier(int index, Modifier modifier, World world) {
        if (this.table != null) {
            this.table.setCurrentModifier(modifier, index);
            this.cacheCurrentReagents(world);
        }
    }

    public ModifiedSpellPart<Shape> getCurrentShape() {
        return this.table.getCurrentShape();
    }

    public ModifiedSpellPart<Component> getCurrentComponent() {
        return this.table.getCurrentComponent();
    }

    public Modifier getCurrentModifier(int index) {
        return this.table.getCurrentModifier(index);
    }

    public void increaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int steps = isShiftDown ? 5 : 1;
        for (int i = 0; i < steps; ++i) {
            if (part instanceof Shape) {
                this.table.changeShapeAttributeValue(attribute, this.table.getCurrentShape().stepUp(attribute));
                continue;
            }
            if (!(part instanceof Component)) continue;
            this.table.changeComponentAttributeValue(attribute, this.table.getCurrentComponent().stepUp(attribute));
        }
        this.cacheCurrentReagents(world);
    }

    public void decreaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int steps = isShiftDown ? 5 : 1;
        for (int i = 0; i < steps; ++i) {
            if (part instanceof Shape) {
                this.table.changeShapeAttributeValue(attribute, this.table.getCurrentShape().stepDown(attribute));
                continue;
            }
            if (!(part instanceof Component)) continue;
            this.table.changeComponentAttributeValue(attribute, this.table.getCurrentComponent().stepDown(attribute));
        }
        this.cacheCurrentReagents(world);
    }

    public float getManaCost(PlayerEntity player) {
        return this.table.getManaCost(player);
    }

    public float getComplexity() {
        return this.table.getComplexity();
    }

    public InscriptionTableTile.CraftCheckResult isReadyToBuild(IPlayerProgression progression) {
        return this.table.canBeginCrafting(progression);
    }

    public int getRequiredInk() {
        return this.table.getInkRemaining();
    }

    public int getRequiredVellum() {
        return this.table.getPaperRemaining();
    }

    public int getRequiredAsh() {
        return this.table.getFuelRemaining();
    }

    public void cacheCurrentReagents(World world) {
        this.cachedReagentList.clear();
        ModifiedSpellPart<Shape> shape = this.table.getCurrentShape();
        ModifiedSpellPart<Component> component = this.table.getCurrentComponent();
        if (shape != null) {
            world.func_199532_z().func_215367_a(shape.getPart().getRegistryName()).ifPresent(recipe -> {
                for (ResourceLocation rLoc : ((ShapeRecipe)recipe).getRequiredItems()) {
                    this.lookupAndCacheItem(rLoc);
                }
            });
        }
        if (component != null) {
            world.func_199532_z().func_215367_a(component.getPart().getRegistryName()).ifPresent(recipe -> {
                for (ResourceLocation rLoc : ((ComponentRecipe)recipe).getRequiredItems()) {
                    this.lookupAndCacheItem(rLoc);
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            Modifier m = this.table.getCurrentModifier(i);
            if (m == null) continue;
            world.func_199532_z().func_215367_a(m.getRegistryName()).ifPresent(recipe -> {
                for (ResourceLocation rLoc : ((ModifierRecipe)recipe).getRequiredItems()) {
                    this.lookupAndCacheItem(rLoc);
                }
            });
        }
        for (ResourceLocation rLoc : this.table.getReagentsForComplexity()) {
            this.lookupAndCacheItem(rLoc);
        }
    }

    private void lookupAndCacheItem(ResourceLocation rLoc) {
        List<Item> item = MATags.smartLookupItem(rLoc);
        if (item.size() == 0) {
            return;
        }
        if (this.cachedReagentList.containsKey(item.get(0))) {
            this.cachedReagentList.put(item.get(0), this.cachedReagentList.get(item.get(0)) + 1);
        } else {
            this.cachedReagentList.put(item.get(0), 1);
        }
    }

    public HashMap<Item, Integer> getCurrentReagents() {
        return this.cachedReagentList;
    }

    public void sendStartBuild() {
        this.table.build();
    }

    public int getCraftTicks() {
        return this.table.getCraftTicks();
    }

    public int getCraftTicksConsumed() {
        return this.table.getCraftTicksConsumed();
    }
}

