/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.api.cantrips.ICantrip;
import com.ma.api.events.CantripCastEvent;
import com.ma.api.events.ConstructCraftedEvent;
import com.ma.api.events.ManaweaveCraftingEvent;
import com.ma.api.events.ManaweavePatternDrawnEvent;
import com.ma.api.events.PlayerMagicLevelUpEvent;
import com.ma.api.events.RitualCompleteEvent;
import com.ma.api.events.RuneforgeCraftingEvent;
import com.ma.api.events.RuneforgeEnchantEvent;
import com.ma.api.events.RunescribeCraftingEvent;
import com.ma.api.events.SpellCastEvent;
import com.ma.api.events.SpellCraftedEvent;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.api.recipes.IManaweavingRecipe;
import com.ma.api.recipes.IRitualRecipe;
import com.ma.api.recipes.IRuneforgeRecipe;
import com.ma.api.recipes.IRunescribeRecipe;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.spells.base.ISpellDefinition;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EventDispatcher {
    public static void DispatchRitualComplete(IRitualRecipe ritual, NonNullList<RitualEffect> handlers, BlockPos center, List<ItemStack> reagents, PlayerEntity caster) {
        RitualCompleteEvent evt = new RitualCompleteEvent(ritual, handlers, center, caster, reagents);
        MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    public static boolean DispatchManaweaveCrafting(IManaweavingRecipe recipe, ItemStack output, PlayerEntity crafter) {
        ManaweaveCraftingEvent evt = new ManaweaveCraftingEvent(recipe, output, crafter);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchRuneforgeCraft(IRuneforgeRecipe recipe, ItemStack output, PlayerEntity crafter) {
        RuneforgeCraftingEvent evt = new RuneforgeCraftingEvent(recipe, output, crafter);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchRuneforgeEnchant(ItemStack output, PlayerEntity crafter) {
        RuneforgeEnchantEvent evt = new RuneforgeEnchantEvent(output, crafter);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchRunescribeCraft(IRunescribeRecipe recipe, ItemStack output, PlayerEntity crafter) {
        RunescribeCraftingEvent evt = new RunescribeCraftingEvent(recipe, output, crafter);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchManaweavePatternDrawn(IManaweavePattern pattern, PlayerEntity caster) {
        ManaweavePatternDrawnEvent evt = new ManaweavePatternDrawnEvent(pattern, caster);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchPlayerLevelUp(PlayerEntity player, int newLevel) {
        PlayerMagicLevelUpEvent evt = new PlayerMagicLevelUpEvent(player, newLevel);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean DispatchSpellCast(ISpellDefinition spell, PlayerEntity caster) {
        SpellCastEvent evt = new SpellCastEvent(spell, caster);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static void DispatchSpellCrafted(ISpellDefinition spell, PlayerEntity caster) {
        SpellCraftedEvent evt = new SpellCraftedEvent(spell, caster);
        MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    public static void DispatchConstructCrafted(Entity construct, PlayerEntity caster) {
        ConstructCraftedEvent evt = new ConstructCraftedEvent(construct, caster);
        MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    public static void DispatchCantripCast(ICantrip cantrip, PlayerEntity caster) {
        CantripCastEvent evt = new CantripCastEvent(cantrip, caster);
        MinecraftForge.EVENT_BUS.post((Event)evt);
    }
}

