/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.ManaAndArtifice;
import com.ma.advancements.CustomAdvancementTriggers;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.events.BonefeatherCharmUsedEvent;
import com.ma.api.spells.DamageTypes;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.magic.resources.Souls;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralModConfig;
import com.ma.effects.EffectInit;
import com.ma.effects.beneficial.EffectManaShield;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.interop.CuriosInterop;
import com.ma.items.ItemInit;
import com.ma.items.armor.CouncilArmorItem;
import com.ma.items.armor.DemonArmorItem;
import com.ma.items.armor.FeyArmorItem;
import com.ma.items.artifice.FactionSpecificSpellModifierRing;
import com.ma.items.artifice.ItemWardingAmulet;
import com.ma.items.artifice.ItemWitherguardAmulet;
import com.ma.items.artifice.curio.ItemEmberglowBracelet;
import com.ma.items.sorcery.ItemCrystalPhylactery;
import com.ma.items.sorcery.bound.ItemBoundShield;
import com.ma.tools.InventoryUtilities;
import com.ma.tools.ProjectileHelper;
import com.ma.tools.SummonUtils;
import com.ma.tools.TeleportHelper;
import com.ma.tools.math.MathUtils;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableFloat;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageEventHandler {
    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.func_70644_a((Effect)EffectInit.MIST_FORM.get())) {
            event.setCanceled(true);
            return;
        }
        if (living.func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            event.setDistance(event.getDistance() - 2.0f);
        }
        if (living instanceof PlayerEntity) {
            int damage;
            PlayerEntity player = (PlayerEntity)living;
            if (((DemonArmorItem)ItemInit.DEMON_ARMOR_BOOTS.get()).handlePlayerMeteorJumpImpact(player, event.getDistance())) {
                event.setCanceled(true);
                return;
            }
            if (player.func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) != null) {
                event.setDistance(event.getDistance() * 2.0f);
            }
            if (player.field_71071_by.func_70301_a(EquipmentSlotType.CHEST.func_188454_b()).func_77973_b() == ItemInit.SPECTRAL_ELYTRA.get()) {
                event.setDistance(event.getDistance() - 5.0f);
            }
            if (!event.isCanceled() && (float)(damage = DamageEventHandler.calculateFallDamage(living, event.getDistance(), event.getDamageMultiplier())) > living.func_110143_aJ()) {
                boolean consumed_fall_charm = false;
                if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.FALL_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM)) {
                    consumed_fall_charm = true;
                    CuriosInterop.DamageCurioInSlot((Item)ItemInit.FALL_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM, 999);
                } else if (InventoryUtilities.removeItemFromInventory(new ItemStack((IItemProvider)ItemInit.FALL_CHARM.get()), true, true, (IItemHandlerModifiable)new InvWrapper((IInventory)player.field_71071_by))) {
                    consumed_fall_charm = true;
                }
                if (consumed_fall_charm) {
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                    BonefeatherCharmUsedEvent bfe = new BonefeatherCharmUsedEvent(player);
                    MinecraftForge.EVENT_BUS.post((Event)bfe);
                    if (player instanceof ServerPlayerEntity) {
                        CustomAdvancementTriggers.USE_BONEFEATHER.trigger((ServerPlayerEntity)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        LivingEntity living = event.getEntityLiving();
        if (living == null || source == null) {
            return;
        }
        if (source == DamageSource.field_76368_d && (living.func_70644_a((Effect)EffectInit.MIST_FORM.get()) || living.func_70644_a((Effect)EffectInit.ELDRIN_FLIGHT.get()))) {
            event.setCanceled(true);
            return;
        }
        if (living.func_70644_a((Effect)EffectInit.FORTIFICATION.get()) && source != DamageSource.field_76379_h && source != DamageSource.field_76368_d && source != DamageSource.field_76380_i && !source.func_151517_h()) {
            event.setCanceled(true);
            living.func_70097_a(DamageTypes.causeFortificationDamage(source), ((Double)GeneralModConfig.MA_FORTIFICATION_DAMAGE.get()).floatValue());
            return;
        }
        if (source.func_76364_f() instanceof ProjectileEntity && living instanceof PlayerEntity) {
            boolean shouldReflect = false;
            boolean shouldReflectAtShooter = false;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            Entity sourceEntity = source.func_76346_g();
            if (living.func_70644_a((Effect)EffectInit.WIND_WALL.get()) && (sourceEntity == null || sourceEntity.func_184222_aU())) {
                shouldReflect = true;
                EffectInstance windWall = living.func_70660_b((Effect)EffectInit.WIND_WALL.get());
                if (windWall != null) {
                    shouldReflectAtShooter = windWall.func_76458_c() > 0;
                }
            } else if (((CouncilArmorItem)ItemInit.COUNCIL_ARMOR__CHEST.get()).isSetEquipped(living)) {
                shouldReflect = CouncilArmorItem.consumeReflectCharget(player);
                shouldReflectAtShooter = true;
            } else if (((FeyArmorItem)ItemInit.FEY_ARMOR_CHEST.get()).isSetEquipped(living)) {
                shouldReflect = FeyArmorItem.randomReflectChance();
                shouldReflectAtShooter = true;
            }
            if (shouldReflect) {
                event.setCanceled(true);
                ProjectileHelper.ReflectProjectile(living, (ProjectileEntity)source.func_76364_f(), shouldReflectAtShooter, 10.0f);
                return;
            }
        }
        if (!source.func_76352_a() && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && source.func_76346_g().func_70068_e(event.getEntity()) < (Double)GeneralModConfig.MA_MELEE_DIST.get() && ((FeyArmorItem)ItemInit.FEY_ARMOR_CHEST.get()).isSetEquipped(living) && FeyArmorItem.randomTeleportChance() && TeleportHelper.randomTeleport((LivingEntity)source.func_76346_g(), 16.0f, 10)) {
            event.setCanceled(true);
            return;
        }
        if (source.func_76347_k()) {
            if (((ItemEmberglowBracelet)ItemInit.EMBERGLOW_BRACELET.get()).isEquippedAndHasMana(living, event.getAmount(), true)) {
                event.setCanceled(true);
                return;
            }
            if (((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped(living)) {
                event.setCanceled(true);
                return;
            }
        }
        if (source.func_94541_c() && ((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped(living)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity source = event.getSource().func_76346_g();
        LivingEntity living = event.getEntityLiving();
        if (source != null && source instanceof LivingEntity) {
            boolean retaliate;
            LivingEntity sourceLiving = (LivingEntity)source;
            double dist = living.func_70068_e((Entity)sourceLiving);
            boolean bl = retaliate = dist <= 25.0;
            if (retaliate && living.func_184607_cu().func_77973_b() == ItemInit.BOUND_SHIELD.get() && DamageEventHandler.canEntityBlock(event.getSource(), living)) {
                ((ItemBoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(((ItemBoundShield)ItemInit.BOUND_SHIELD.get()).getRecipe(living.func_184607_cu()), living, sourceLiving, living.func_184600_cs());
            }
        }
        if (event.getAmount() > 0.0f) {
            EffectInstance lev;
            if (living instanceof PlayerEntity && (lev = living.func_70660_b((Effect)EffectInit.LEVITATION.get())) != null) {
                PlayerEntity target = (PlayerEntity)event.getEntityLiving();
                boolean wasFlying = target.field_71075_bZ.field_75100_b;
                int amplifier = lev.func_76458_c();
                int duration = lev.func_76459_b();
                target.func_195063_d((Effect)EffectInit.LEVITATION.get());
                if ((duration /= 2) > 100) {
                    target.func_195064_c(new EffectInstance((Effect)EffectInit.LEVITATION.get(), duration, amplifier));
                    ManaAndArtifice.instance.proxy.setFlightEnabled(target, true);
                    target.field_71075_bZ.field_75100_b = wasFlying;
                }
            }
            if (living.func_70644_a((Effect)EffectInit.BIND_WOUNDS.get())) {
                living.func_195063_d((Effect)EffectInit.BIND_WOUNDS.get());
            }
        }
        boolean reduce = event.getSource() != DamageSource.field_76380_i && event.getSource() != DamageSource.field_76379_h && event.getSource() != DamageSource.field_76368_d && event.getSource() != DamageSource.field_76366_f && event.getSource() != DamageSource.field_76369_e && event.getSource() != DamageSource.field_191291_g && !event.getSource().func_151517_h();
        EffectInstance mana_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.MANA_SHIELD.get());
        if (mana_shield != null && reduce) {
            float reduction = event.getAmount() * 0.2f * (float)MathUtils.clamp(mana_shield.func_76458_c() + 1, 1, 5);
            float reductionCost = ((EffectManaShield)EffectInit.MANA_SHIELD.get()).getReductionCost(mana_shield.func_76458_c() + 1);
            event.getEntityLiving().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                float amountReduced = reduction;
                if (m.getCastingResource().getAmount() < amountReduced * reductionCost) {
                    amountReduced = m.getCastingResource().getAmount() / reductionCost;
                }
                m.getCastingResource().consume(amountReduced * reductionCost);
                m.forceSync(1);
                if (m.getCastingResource().getAmount() <= 0.0f) {
                    event.getEntityLiving().func_195063_d((Effect)EffectInit.MANA_SHIELD.get());
                }
                event.setAmount(event.getAmount() - amountReduced);
            });
            if (event.getAmount() == 0.0f) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity source;
        boolean reduce;
        EffectInstance fire_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.FIRE_SHIELD.get());
        EffectInstance briar_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.BRIARTHORN_BARRIER.get());
        EffectInstance life_tap = event.getEntityLiving().func_70660_b((Effect)EffectInit.LIFE_TAP.get());
        boolean bl = reduce = event.getSource() != DamageSource.field_76380_i && event.getSource() != DamageSource.field_76379_h && event.getSource() != DamageSource.field_76368_d && event.getSource() != DamageSource.field_76366_f && event.getSource() != DamageSource.field_76369_e && event.getSource() != DamageSource.field_191291_g && !event.getSource().func_151517_h();
        if (event.getSource() == DamageSource.field_82727_n && ((ItemWitherguardAmulet)ItemInit.WITHERGUARD_AMULET.get()).isEquippedAndHasMana(event.getEntityLiving(), 1.0f, true)) {
            event.setCanceled(true);
            return;
        }
        if (reduce && event.getSource().func_82725_o() && ((ItemWardingAmulet)ItemInit.WARDING_AMULET.get()).isEquippedAndHasMana(event.getEntityLiving(), 1.0f, true)) {
            event.setAmount(event.getAmount() - event.getAmount() * 0.2f);
        }
        if (event.getSource().func_76347_k() && fire_shield != null && reduce) {
            float reduction = event.getAmount() * 0.1f * (float)(fire_shield.func_76458_c() + 1);
            event.setAmount(event.getAmount() - reduction);
        }
        if ((source = event.getSource().func_76346_g()) != null && source instanceof LivingEntity && source != event.getEntity()) {
            float damage;
            boolean retaliate;
            LivingEntity sourceLiving;
            LivingEntity living = event.getEntityLiving();
            double dist = living.func_70068_e((Entity)(sourceLiving = (LivingEntity)source));
            boolean bl2 = retaliate = dist <= 25.0;
            if (retaliate && event.getEntityLiving().func_184607_cu().func_77973_b() == ItemInit.BOUND_SHIELD.get() && DamageEventHandler.canEntityBlock(event.getSource(), event.getEntityLiving())) {
                ((ItemBoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(((ItemBoundShield)ItemInit.BOUND_SHIELD.get()).getRecipe(event.getEntityLiving().func_184607_cu()), living, sourceLiving, living.func_184600_cs());
            }
            if (briar_shield != null) {
                if (event.getSource().func_76355_l().equals("thorns") || event.getSource().func_76355_l().equals("poison") || event.getSource().func_76355_l().equals("sting") || event.getSource().func_76355_l().equals("cactus") || event.getSource().func_76355_l().equals("sweetBerryBush")) {
                    float reduction = event.getAmount() * 0.1f * (float)(briar_shield.func_76458_c() + 1);
                    event.setAmount(event.getAmount() - reduction);
                }
                if (retaliate) {
                    damage = (briar_shield.func_76458_c() + 1) * 2;
                    sourceLiving.func_70097_a(DamageTypes.causeBriarDamage(), damage);
                }
            }
            if (fire_shield != null && retaliate) {
                damage = (fire_shield.func_76458_c() + 1) * 2;
                sourceLiving.func_70097_a(DamageSource.field_76372_a, damage);
            }
            if (life_tap != null) {
                float healing = event.getAmount() * 0.05f * (float)(life_tap.func_76458_c() + 1);
                sourceLiving.func_70691_i(healing);
            }
            if (source instanceof PlayerEntity) {
                PlayerEntity sourcePlayer = (PlayerEntity)source;
                if (!event.getSource().func_76352_a()) {
                    CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.EMBERGLOW_BRACELET.get(), (LivingEntity)sourcePlayer).ifPresent(t -> {
                        if (living.func_70068_e(source) < 4.0) {
                            living.func_70015_d(4);
                        }
                        ((ItemStack)t.getRight()).func_222118_a(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio((String)t.getLeft(), ((Integer)t.getMiddle()).intValue(), damager));
                    });
                }
                if (sourcePlayer.func_225608_bj_() && sourcePlayer.func_184614_ca().func_190926_b()) {
                    CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TRICKERY_BRACELET.get(), (LivingEntity)sourcePlayer).ifPresent(t -> {
                        living.func_233627_a_(5.0f, sourcePlayer.func_226277_ct_() - living.func_226277_ct_(), sourcePlayer.func_226281_cx_() - living.func_226281_cx_());
                        ((ItemStack)t.getRight()).func_222118_a(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio((String)t.getLeft(), ((Integer)t.getMiddle()).intValue(), damager));
                    });
                }
                sourcePlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.getAlliedFaction() == Faction.UNDEAD) {
                        float souls;
                        if (sourcePlayer.getPersistentData().func_74767_n("bone_armor_set_bonus") && (souls = DamageEventHandler.getSoulsRestored(sourcePlayer, (Entity)living)) > 0.0f) {
                            sourcePlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().restore(souls * 0.1f));
                        }
                        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.COWL_OF_CONSUMPTION.get(), (LivingEntity)sourcePlayer) != null && event.getAmount() >= 10.0f) {
                            sourcePlayer.func_71024_bL().func_75122_a(1, 0.1f);
                        }
                    }
                });
            }
        }
        if (event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        } else if (event.getEntityLiving().getPersistentData().func_74767_n("bone_armor_set_bonus") && !event.getSource().func_76357_e() && event.getEntityLiving().func_110143_aJ() > 1.0f && event.getAmount() > event.getEntityLiving().func_110143_aJ()) {
            event.getEntityLiving().func_195064_c(new EffectInstance((Effect)EffectInit.MIST_FORM.get(), 200, 0, true, true));
            event.getEntityLiving().func_70606_j(1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        PlayerEntity soulRecipient;
        Entity causeOfDeath = event.getSource().func_76346_g();
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_70660_b((Effect)EffectInit.CHRONO_ANCHOR.get()) != null) {
                player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    if (m.getChronoAnchorData().canRevert(player)) {
                        event.setCanceled(true);
                        player.func_195063_d((Effect)EffectInit.CHRONO_ANCHOR.get());
                    }
                });
            } else {
                SummonUtils.getSummons(player).forEach(s -> s.func_174812_G());
            }
            if (event.getEntityLiving().func_70644_a((Effect)EffectInit.LIFT.get())) {
                event.getEntityLiving().func_195063_d((Effect)EffectInit.LIFT.get());
            }
        } else if (event.getEntityLiving() instanceof MobEntity && causeOfDeath != null && causeOfDeath instanceof PlayerEntity && !(event.getEntityLiving() instanceof EntityAnimatedConstruct)) {
            ItemCrystalPhylactery.addToPhylactery((IInventory)((PlayerEntity)causeOfDeath).field_71071_by, (EntityType<? extends MobEntity>)event.getEntityLiving().func_200600_R(), ((PlayerEntity)causeOfDeath).func_184812_l_() ? 100.0f : 1.0f, causeOfDeath.field_70170_p);
        }
        Object object = causeOfDeath instanceof PlayerEntity ? (PlayerEntity)causeOfDeath : (soulRecipient = causeOfDeath instanceof CreatureEntity && SummonUtils.isSummon((LivingEntity)((CreatureEntity)causeOfDeath)) ? SummonUtils.getSummoner((LivingEntity)((CreatureEntity)causeOfDeath)) : null);
        if (soulRecipient != null) {
            soulRecipient.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getCastingResource().getRegistryName().equals((Object)Souls.IDENTIFIER)) {
                    m.getCastingResource().restore(DamageEventHandler.getSoulsRestored(soulRecipient, event.getEntity()));
                }
            });
        }
    }

    private static boolean canEntityBlock(DamageSource damageSource, LivingEntity living) {
        Vector3d vector3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSource.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSource.func_76363_c() && living.func_184585_cz() && !flag && (vector3d2 = damageSource.func_188404_v()) != null) {
            Vector3d vector3d = living.func_70676_i(1.0f);
            Vector3d vector3d1 = vector3d2.func_72444_a(living.func_213303_ch()).func_72432_b();
            vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
            if (vector3d1.func_72430_b(vector3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static int calculateFallDamage(LivingEntity entity, float distance, float damageMult) {
        EffectInstance effectinstance = entity.func_70660_b(Effects.field_76430_j);
        float f = effectinstance == null ? 0.0f : (float)(effectinstance.func_76458_c() + 1);
        return MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMult));
    }

    private static float getSoulsRestored(PlayerEntity soulRecipient, Entity target) {
        if (soulRecipient != null) {
            if (!(target instanceof LivingEntity) || target instanceof CreatureEntity && SummonUtils.isSummon((LivingEntity)((CreatureEntity)target))) {
                return 0.0f;
            }
            MutableFloat restoreAmount = new MutableFloat(1.0f);
            if (target instanceof PlayerEntity) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_PLAYER.get());
            } else if (target instanceof VillagerEntity) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_VILLAGER.get());
            } else if (target instanceof IFactionEnemy) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_FACTION.get());
            } else if (((LivingEntity)target).func_70662_br()) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_UNDEAD.get());
            } else if (target instanceof AnimalEntity) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_ANIMAL.get());
            } else if (target instanceof GolemEntity) {
                restoreAmount.setValue(0.0f);
            } else if (target instanceof MobEntity) {
                restoreAmount.setValue((Number)GeneralModConfig.MA_SOULS_MOB.get());
            }
            if (((LivingEntity)target).func_70644_a((Effect)EffectInit.SOUL_VULNERABILITY.get())) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 5.0f);
            }
            if (((FactionSpecificSpellModifierRing)ItemInit.BONE_RING.get()).isEquippedAndHasMana((LivingEntity)soulRecipient, 3.5f, true)) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 2.25f);
            }
            return restoreAmount.getValue().floatValue();
        }
        return 0.0f;
    }
}

