/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.base.ISpellRune;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.EntityInit;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySpellRune
extends Entity
implements ISpellRune<EntitySpellRune> {
    private static final DataParameter<Integer> AFFINITY = EntityDataManager.func_187226_a(EntitySpellRune.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAGNITUDE = EntityDataManager.func_187226_a(EntitySpellRune.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntitySpellRune.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> CASTER = EntityDataManager.func_187226_a(EntitySpellRune.class, (IDataSerializer)DataSerializers.field_187203_m);
    private UUID myID;
    private ISpellDefinition recipe;
    private PlayerEntity _cachedCaster;
    private ArrayList<Entity> targetedEntities = new ArrayList();

    public EntitySpellRune(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.myID = UUID.randomUUID();
    }

    public EntitySpellRune(PlayerEntity caster, ISpellDefinition spell) {
        this((EntityType)EntityInit.SPELL_RUNE.get(), caster.field_70170_p);
        this.setCasterAndSpell(caster, spell);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            if (this.getCasterID() != null) {
                this.field_70170_p.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                    if (m.wasRuneRemoved(this.getCasterID(), this.myID)) {
                        this.remove(false);
                    }
                });
            } else {
                this.remove(false);
            }
        }
        this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()).forEach(e -> this.func_70108_f((Entity)e));
    }

    private void setCasterAndSpell(PlayerEntity caster, ISpellDefinition spell) {
        this._cachedCaster = caster;
        this.setCasterID(caster.func_110124_au());
        this.recipe = spell;
        this.field_70180_af.func_187227_b(AFFINITY, (Object)spell.getHighestAffinity().ordinal());
        this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(this.recipe.getShape().getValue(Attribute.RADIUS)));
        this.field_70180_af.func_187227_b(MAGNITUDE, (Object)((int)spell.getShape().getValue(Attribute.MAGNITUDE)));
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.field_70180_af.func_187225_a(AFFINITY)];
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if ((Integer)this.field_70180_af.func_187225_a(MAGNITUDE) == 2 ? !(entityIn instanceof LivingEntity) : (Integer)this.field_70180_af.func_187225_a(MAGNITUDE) == 3 && !(entityIn instanceof PlayerEntity)) {
            return;
        }
        this.trigger(entityIn, false);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.trigger(source.func_76364_f(), true);
        return true;
    }

    private void trigger(Entity e, boolean force) {
        if (!this.func_70089_S()) {
            return;
        }
        if (!force) {
            if (e == this.getCaster()) {
                return;
            }
            if (this.getCaster() != null && this.getCaster().func_184191_r(e)) {
                return;
            }
        }
        float radius = ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles(radius);
        } else {
            this.remove(false);
            if (this.recipe == null) {
                return;
            }
            SpellContext context = new SpellContext((ServerWorld)this.field_70170_p, this.recipe, this);
            this.targetEntities(radius, context);
            this.targetBlocks(radius, context);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles(float radius) {
        Affinity affinity = Affinity.values()[(Integer)this.field_70180_af.func_187225_a(AFFINITY)];
        MAParticleType particle = null;
        SoundEvent sound = null;
        switch (affinity) {
            case ARCANE: {
                particle = (MAParticleType)ParticleInit.ARCANE.get();
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.ARCANE : SFX.Spell.Impact.AoE.ARCANE;
                break;
            }
            case EARTH: {
                particle = (MAParticleType)ParticleInit.DUST.get();
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.EARTH : SFX.Spell.Impact.AoE.EARTH;
                break;
            }
            case ENDER: {
                particle = (MAParticleType)ParticleInit.ENDER.get();
                sound = SFX.Spell.Impact.Single.ENDER;
                break;
            }
            case FIRE: {
                particle = (MAParticleType)ParticleInit.FLAME.get();
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.FIRE : SFX.Spell.Impact.AoE.FIRE;
                break;
            }
            case HELLFIRE: {
                particle = (MAParticleType)ParticleInit.HELLFIRE.get();
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.FIRE : SFX.Spell.Impact.AoE.FIRE;
                break;
            }
            case WATER: {
                particle = (MAParticleType)ParticleInit.FROST.get();
                sound = SFX.Spell.Impact.Single.ICE;
                break;
            }
            case WIND: {
                particle = (MAParticleType)ParticleInit.AIR_VELOCITY.get();
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.WIND : SFX.Spell.Impact.AoE.WIND;
                break;
            }
            default: {
                particle = (MAParticleType)ParticleInit.SPARKLE_STATIONARY.get();
            }
        }
        int i = 0;
        while ((float)i < 20.0f * radius) {
            Vector3d position = this.func_213303_ch().func_72441_c((double)(-radius) + Math.random() * (double)radius, (double)(-radius) + Math.random() * (double)radius, (double)(-radius) + Math.random() * (double)radius);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType(particle), position.field_72450_a, position.field_72448_b, position.field_72449_c, 0.0, 0.4, 0.0);
            ++i;
        }
        if (sound != null) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.4f), false);
        }
    }

    private void targetEntities(float radius, SpellContext context) {
        if (this.recipe == null || !this.recipe.isValid()) {
            return;
        }
        if (!this.recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
            return;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getOrCreatePlayer(), Hand.MAIN_HAND);
        this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g((double)radius)).forEach(e -> {
            if (!this.targetedEntities.contains(e)) {
                this.targetedEntities.add((Entity)e);
                SpellCaster.ApplyComponents(this.recipe, source, new SpellTarget((Entity)e), context);
            }
        });
    }

    protected PlayerEntity getOrCreatePlayer() {
        PlayerEntity caster = this.getCaster();
        return caster != null && caster.func_70068_e((Entity)this) < 4096.0 ? caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p));
    }

    private void targetBlocks(float radius, SpellContext context) {
        if (this.recipe == null || !this.recipe.isValid()) {
            return;
        }
        if (!this.recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
            return;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getOrCreatePlayer(), Hand.MAIN_HAND);
        int iRadius = (int)Math.floor(radius);
        for (int i = -iRadius; i <= iRadius; ++i) {
            for (int j = -iRadius; j <= iRadius; ++j) {
                for (int k = -iRadius; k <= iRadius; ++k) {
                    BlockPos offset = new BlockPos(i, j, k);
                    SpellCaster.ApplyComponents(this.recipe, source, new SpellTarget(offset, Direction.DOWN), context);
                }
            }
        }
    }

    @Nullable
    private PlayerEntity getCaster() {
        if (this._cachedCaster == null && this.getCasterID() != null) {
            this._cachedCaster = this.field_70170_p.func_217371_b(this.getCasterID());
        }
        return this._cachedCaster;
    }

    @Nullable
    private UUID getCasterID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(CASTER)).get();
    }

    private void setCasterID(UUID casterID) {
        this.field_70180_af.func_187227_b(CASTER, Optional.of(casterID));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == CASTER) {
            this._cachedCaster = null;
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(AFFINITY, (Object)Affinity.UNKNOWN.ordinal());
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CASTER, Optional.empty());
        this.field_70180_af.func_187214_a(MAGNITUDE, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("caster")) {
            try {
                this.setCasterID(UUID.fromString(compound.func_74779_i("caster")));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load caster ID when loading rune entity");
                ManaAndArtifice.LOGGER.throwing((Throwable)ex);
            }
        }
        if (compound.func_74764_b("recipe")) {
            this.recipe = SpellRecipe.fromNBT(compound.func_74775_l("recipe"));
        }
        if (compound.func_74764_b("affinity")) {
            this.field_70180_af.func_187227_b(AFFINITY, (Object)compound.func_74762_e("affinity"));
        }
        if (compound.func_74764_b("myUUID")) {
            try {
                this.myID = UUID.fromString(compound.func_74779_i("myUUID"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load UUID when loading EntitySpellRune");
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("caster", this.getCasterID() != null ? this.getCasterID().toString() : "");
        compound.func_74778_a("myUUID", this.myID.toString());
        compound.func_74768_a("affinity", ((Integer)this.field_70180_af.func_187225_a(AFFINITY)).intValue());
        CompoundNBT recipeNBT = new CompoundNBT();
        if (this.recipe != null) {
            this.recipe.writeToNBT(recipeNBT);
        }
        compound.func_218657_a("recipe", (INBT)recipeNBT);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K && this.getCaster() != null) {
            this.field_70170_p.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.addRune(this.getCaster(), this));
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.removeRune(this.getCaster() != null ? this.getCaster().func_110124_au() : null, this.myID));
        }
    }

    @Override
    public UUID getID() {
        return this.myID;
    }
}

