/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.google.common.collect.Lists;
import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.ISpellInteractibleBlock;
import com.ma.api.entities.ISpellInteractibleEntity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.boss.EntityOdin;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySpellProjectile
extends DamagingProjectileEntity {
    private static final DataParameter<CompoundNBT> SPELL_RECIPE = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> SPECIAL_RENDER = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> SPECIAL_RENDER_PARAM = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> FORCED_AFFINITY = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> FORCED_DAMAGE = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static ItemStack[] halloween_stacks = new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196708_eQ), new ItemStack((IItemProvider)Blocks.field_196714_eU), new ItemStack((IItemProvider)Blocks.field_196703_eM), new ItemStack((IItemProvider)Blocks.field_196705_eO), new ItemStack((IItemProvider)Blocks.field_196625_cS), new ItemStack((IItemProvider)Blocks.field_196628_cT)};
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    public UUID shootingEntity;
    private int ticksInAir;
    private ArrayList<Affinity> affinities;
    private Optional<Integer> forcedTargetID = Optional.empty();
    private HashMap<Affinity, BiConsumer<Integer, Float>> particleFunctions = new HashMap();

    public EntitySpellProjectile(EntityType<? extends EntitySpellProjectile> type, World world) {
        super((EntityType)EntityInit.SPELL_PROJECTILE.get(), world);
        this.func_189654_d(true);
        this.forcedTargetID = Optional.empty();
        this.particleFunctions.put(Affinity.ARCANE, this::spawnArcaneParticles);
        this.particleFunctions.put(Affinity.ENDER, this::spawnEnderParticles);
        this.particleFunctions.put(Affinity.FIRE, this::spawnFireParticles);
        this.particleFunctions.put(Affinity.HELLFIRE, this::spawnHellfireParticles);
        this.particleFunctions.put(Affinity.LIGHTNING, this::spawnLightningParticles);
        this.particleFunctions.put(Affinity.WATER, this::spawnWaterParticles);
        this.particleFunctions.put(Affinity.ICE, this::spawnFrostParticles);
        this.particleFunctions.put(Affinity.WIND, this::spawnWindParticles);
        this.particleFunctions.put(Affinity.EARTH, this::spawnEarthParticles);
    }

    public EntitySpellProjectile(LivingEntity shooter, World worldIn) {
        this(worldIn, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
        this.func_212361_a((Entity)shooter);
    }

    public EntitySpellProjectile(World worldIn, double x, double y, double z) {
        super((EntityType)EntityInit.SPELL_PROJECTILE.get(), worldIn);
        this.func_70107_b(x, y, z);
        this.func_189654_d(true);
    }

    public ArrayList<Affinity> getAffinity() {
        if (this.affinities == null) {
            if ((Byte)this.field_70180_af.func_187225_a(FORCED_AFFINITY) > 0) {
                this.affinities = new ArrayList();
                this.affinities.add(Affinity.values()[(Byte)this.field_70180_af.func_187225_a(FORCED_AFFINITY)]);
            } else {
                SpellRecipe recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
                this.affinities = new ArrayList<Affinity>(recipe.getAffinity().keySet());
            }
        }
        return this.affinities;
    }

    public SpecialRenderType getSpecialRenderType() {
        return SpecialRenderType.values()[(Byte)this.field_70180_af.func_187225_a(SPECIAL_RENDER)];
    }

    public void spawnParticles(int particleCount, float partialTick) {
        Affinity aff;
        if (this.getAffinity() != null && this.particleFunctions.containsKey((Object)(aff = this.affinities.get((int)(Math.random() * (double)this.affinities.size()))))) {
            this.particleFunctions.get((Object)aff).accept(particleCount, Float.valueOf(partialTick));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPELL_RECIPE, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(FORCED_AFFINITY, (Object)0);
        this.field_70180_af.func_187214_a(FORCED_DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(SPECIAL_RENDER, (Object)0);
        this.field_70180_af.func_187214_a(SPECIAL_RENDER_PARAM, (Object)0);
    }

    public void setForcedDamageAffinityAndTarget(Affinity affinity, float damage, Entity target) {
        this.field_70180_af.func_187227_b(FORCED_DAMAGE, (Object)((byte)damage));
        this.field_70180_af.func_187227_b(FORCED_AFFINITY, (Object)((byte)affinity.ordinal()));
        this.forcedTargetID = Optional.of(target.func_145782_y());
    }

    public void setSpecialRender(SpecialRenderType type) {
        this.field_70180_af.func_187227_b(SPECIAL_RENDER, (Object)((byte)type.ordinal()));
        switch (type) {
            case HALLOWEEN: {
                this.field_70180_af.func_187227_b(SPECIAL_RENDER_PARAM, (Object)((byte)(Math.random() * (double)halloween_stacks.length)));
                break;
            }
        }
    }

    public ItemStack getSpecialRenderStack() {
        return halloween_stacks[(Byte)this.field_70180_af.func_187225_a(SPECIAL_RENDER_PARAM)];
    }

    public void setSpellRecipe(CompoundNBT recipe) {
        this.field_70180_af.func_187227_b(SPELL_RECIPE, (Object)recipe);
    }

    public void shoot(@Nullable Entity shooter, Vector3d look, float velocity, float inaccuracy) {
        this.func_70186_c(look.func_82615_a(), look.func_82617_b(), look.func_82616_c(), velocity, inaccuracy);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d Vector3d2 = new Vector3d(x, y, z).func_72432_b().func_186678_a((double)velocity);
        this.func_213317_d(Vector3d2);
        float f = MathHelper.func_76133_a((double)EntitySpellProjectile.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void entityHit(Entity entity) {
        if ((Byte)this.field_70180_af.func_187225_a(FORCED_DAMAGE) > 0) {
            Entity shooter = this.getShooter();
            if (shooter != null && shooter instanceof LivingEntity) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)((LivingEntity)shooter)), (float)((Byte)this.field_70180_af.func_187225_a(FORCED_DAMAGE)).byteValue());
            } else {
                entity.func_70097_a(DamageSource.field_76376_m, (float)((Byte)this.field_70180_af.func_187225_a(FORCED_DAMAGE)).byteValue());
            }
        } else {
            this.applyEffect(this.func_233580_cy_(), this.func_174811_aO(), entity);
        }
        this.func_70106_y();
    }

    protected void blockHit(BlockPos pos, Direction face) {
        if ((Byte)this.field_70180_af.func_187225_a(FORCED_DAMAGE) <= 0) {
            this.applyEffect(pos, face, null);
        }
        this.func_70106_y();
    }

    private void applyEffect(BlockPos impactPoint, Direction face, @Nullable Entity hitEntity) {
        if (this.getShooter() == null || !(this.getShooter() instanceof LivingEntity)) {
            this.func_70106_y();
            return;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getShooter(), Hand.MAIN_HAND);
        SpellRecipe recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
        if (recipe.isValid() && !this.field_70170_p.field_72995_K) {
            BlockState state = this.field_70170_p.func_180495_p(impactPoint);
            if (state.func_177230_c() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.func_177230_c()).onHitBySpell(this.field_70170_p, impactPoint, recipe)) {
                this.func_70106_y();
                return;
            }
            if (hitEntity != null && hitEntity instanceof ISpellInteractibleEntity && ((ISpellInteractibleEntity)hitEntity).onShapeTarget(recipe, source)) {
                this.func_70106_y();
                return;
            }
            float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
            SpellContext context = new SpellContext((ServerWorld)this.field_70170_p, recipe, (Entity)this);
            if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
                SpellCaster.spawnClientFX(this.field_70170_p, this.func_213303_ch(), source, recipe);
                int radius = (int)Math.floor(spellRadius) - 1;
                if (radius < 0) {
                    radius = 0;
                }
                if (radius > 0 || hitEntity == null) {
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            for (int k = -radius; k <= radius; ++k) {
                                BlockPos adjusted = impactPoint.func_177982_a(i, j, k);
                                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, face).doNotOffsetFace(), context);
                            }
                        }
                    }
                }
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
                float radius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
                List targets = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)radius), e -> !e.func_190530_aW());
                if (hitEntity != null && !targets.contains(hitEntity)) {
                    targets.add(hitEntity);
                }
                for (Entity target : targets) {
                    if (target == null || target == this.getShooter()) continue;
                    SpellCaster.ApplyComponents(recipe, source, new SpellTarget(target), context);
                }
            }
        }
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            this.blockHit(blockraytraceresult.func_216350_a(), blockraytraceresult.func_216354_b());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float getWaterDrag() {
        return this.affinities.contains((Object)Affinity.WATER) ? 1.0f : 0.6f;
    }

    public byte getPierceLevel() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void setPierceLevel(byte level) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)level);
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public void func_212361_a(@Nullable Entity entityIn) {
        this.shootingEntity = entityIn == null ? null : entityIn.func_110124_au();
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a("PierceLevel", this.getPierceLevel());
        if (this.shootingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.shootingEntity);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setPierceLevel(compound.func_74771_c("PierceLevel"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.shootingEntity = compound.func_186857_a("OwnerUUID");
        }
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        if (this.getShooter() instanceof EntityOdin) {
            return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_186662_g(3.0).func_216361_a(this.func_213322_ci()), candidate -> !(candidate.func_175149_v() || !candidate.func_70089_S() || !candidate.func_70067_L() || candidate == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(candidate.func_145782_y())));
        }
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), candidate -> !(candidate.func_175149_v() || !candidate.func_70089_S() || !candidate.func_70067_L() || candidate == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(candidate.func_145782_y())));
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity = p_213868_1_.func_216348_a();
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if (this.forcedTargetID != null && this.forcedTargetID.isPresent() && this.forcedTargetID.get().intValue() != entity.func_145782_y()) {
            return;
        }
        this.entityHit(entity);
        if (!entity.func_70089_S() && this.hitEntities != null) {
            this.hitEntities.add(entity);
        }
        if (this.getPierceLevel() <= 0) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        Vector3d Vector3d3;
        Vector3d motion = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntitySpellProjectile.func_213296_b((Vector3d)motion));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        ++this.ticksInAir;
        Vector3d Vector3d2 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, Vector3d3 = Vector3d2.func_178787_e(motion), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            Vector3d3 = raytraceresult.func_216347_e();
        }
        while (this.func_70089_S()) {
            EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = this.getShooter();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a((RayTraceResult)raytraceresult);
                this.field_70160_al = true;
            }
            if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
            raytraceresult = null;
        }
        motion = this.func_213322_ci();
        double d3 = motion.field_72450_a;
        double d4 = motion.field_72448_b;
        double d0 = motion.field_72449_c;
        double d5 = this.func_226277_ct_() + d3;
        double d1 = this.func_226278_cu_() + d4;
        double d2 = this.func_226281_cx_() + d0;
        float f1 = MathHelper.func_76133_a((double)EntitySpellProjectile.func_213296_b((Vector3d)motion));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float f2 = 0.99f;
        if (this.func_70090_H()) {
            if (this.affinities.contains((Object)Affinity.FIRE)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.remove(false);
                }
                return;
            }
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterDrag();
        }
        this.func_213317_d(motion.func_186678_a((double)f2));
        if (!this.func_189652_ae()) {
            Vector3d Vector3d4 = this.func_213322_ci();
            this.func_213293_j(Vector3d4.field_72450_a, Vector3d4.field_72448_b - (double)0.05f, Vector3d4.field_72449_c);
        }
        this.func_70107_b(d5, d1, d2);
        this.func_145775_I();
        if (this.field_70173_aa > 200) {
            this.remove(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySpellProjectile.func_184183_bd()) * d0;
    }

    public void spawnArcaneParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float spread = 0.05f;
        float spread_2 = 0.1f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)(-spread) + Math.random() * (double)spread_2, (double)(-spread) + Math.random() * (double)spread, (double)(-spread) + Math.random() * (double)spread_2);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())).setGravity(0.005f).setPhysics(true).setScale(0.025f), pos.field_72450_a + ((double)(-spread) + Math.random() * (double)spread * 2.0), pos.field_72448_b + ((double)(-spread) + Math.random() * (double)spread * 2.0), pos.field_72449_c + ((double)(-spread) + Math.random() * (double)spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnEnderParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())).setMaxAge(15), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0));
        }
    }

    public void spawnEarthParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.field_72450_a + (double)(-particle_spread + this.field_70170_p.field_73012_v.nextFloat() * particle_spread * 2.0f), pos.field_72448_b + (double)(-particle_spread + this.field_70170_p.field_73012_v.nextFloat() * particle_spread * 2.0f), pos.field_72449_c + (double)(-particle_spread + this.field_70170_p.field_73012_v.nextFloat() * particle_spread * 2.0f), 0.12156862765550613, 0.4431372582912445, 0.12156862765550613);
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnWaterParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, Math.random() * (double)velocity_spread, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnFireParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setScale(0.01f), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnHellfireParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())).setScale(0.01f), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnLightningParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        double radius = 0.25;
        Vector3d motion = this.func_213322_ci();
        int particleLife = (int)(5.0 + Math.random() * 5.0);
        this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())).setMaxAge(particleLife), pos.field_72450_a - radius + Math.random() * radius * 2.0, pos.field_72448_b - radius + Math.random() * radius * 2.0, pos.field_72449_c - radius + Math.random() * radius * 2.0, pos.field_72450_a + motion.field_72450_a * (double)particleLife / 2.0, pos.field_72448_b + motion.field_72448_b * (double)particleLife / 2.0, pos.field_72449_c + motion.field_72449_c * (double)particleLife / 2.0);
    }

    public void spawnWindParticles(int particleCount, float partialTick) {
        Vector3d velocity;
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        float v = 0.4f;
        float hVel = v / 2.0f;
        float velocity_spread = 0.025f;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d vSpread = new Vector3d((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            velocity = this.func_213322_ci().func_186678_a((double)-0.2f).func_178787_e(vSpread);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setMaxAge(10), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.func_213322_ci().field_72450_a * Math.random(), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.func_213322_ci().field_72448_b * Math.random(), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.func_213322_ci().field_72449_c * Math.random(), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
        if (Math.random() < (double)0.8f) {
            return;
        }
        v = 0.1f;
        hVel = 0.05f;
        Biome curBiome = this.field_70170_p.func_226691_t_(this.func_233580_cy_());
        switch (curBiome.func_201856_r()) {
            case BEACH: 
            case DESERT: {
                velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case FOREST: 
            case JUNGLE: 
            case PLAINS: 
            case SAVANNA: {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), 0.12156862765550613, 0.4431372582912445, 0.12156862765550613);
                break;
            }
            case ICY: 
            case TAIGA: 
            case EXTREME_HILLS: 
            case MESA: {
                velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case NETHER: {
                break;
            }
            case OCEAN: 
            case RIVER: 
            case SWAMP: {
                velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case THEEND: {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                break;
            }
        }
    }

    public void spawnFrostParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(this.func_213322_ci().func_186678_a((double)partialTick));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount / 2; ++j) {
            Vector3d velocity = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, (double)-0.05f + Math.random() * (double)0.05f, (double)-0.01f + Math.random() * (double)0.02f);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setScale(0.01f).setGravity(0.005f).setPhysics(true), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public static enum SpecialRenderType {
        NONE,
        HALLOWEEN;

    }
}

