/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.api.spells.targeting.SpellTargetHelper;
import com.ma.entities.EntityInit;
import com.ma.entities.sorcery.base.ChanneledSpellEntity;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.BlockUtils;
import com.ma.tools.render.LineSegment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntitySpellBeam
extends ChanneledSpellEntity {
    private static final Vector3d UP = new Vector3d(0.0, 1.0, 0.0);
    private boolean lastTickMissed = true;
    private Vector3d lastTickImpact = null;
    private BlockPos lastTickBlockPos = null;
    private Direction lastTickBlockFace = Direction.UP;

    public EntitySpellBeam(EntityType<? extends EntitySpellBeam> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySpellBeam(PlayerEntity caster, ISpellDefinition spell, World world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_BEAM.get()), caster, spell, world);
        this.func_70107_b(caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_());
        this.func_70101_b(this.getCaster().field_70177_z, this.getCaster().field_70125_A);
    }

    @Override
    public void func_70071_h_() {
        PlayerEntity caster = this.getCaster();
        SpellRecipe recipe = this.getSpell();
        if (caster != null && recipe != null && recipe.isValid()) {
            float range = this.getShapeAttributeByAge(Attribute.RANGE);
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            Vector3d newPos = caster.func_213303_ch().func_72441_c(0.0, (double)(caster.func_70047_e() - 0.1f), 0.0);
            HandSide casterHandedness = caster.func_184591_cq();
            newPos = casterHandedness == HandSide.RIGHT && caster.func_184600_cs() == Hand.MAIN_HAND || casterHandedness == HandSide.LEFT && caster.func_184600_cs() == Hand.OFF_HAND ? newPos.func_178787_e(caster.func_70040_Z().func_72431_c(UP).func_72432_b().func_186678_a((double)0.1f)) : newPos.func_178787_e(caster.func_70040_Z().func_72431_c(UP).func_72432_b().func_186678_a((double)-0.1f));
            this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            this.field_70125_A = caster.field_70125_A;
            this.field_70127_C = caster.field_70127_C;
            this.field_70177_z = caster.field_70759_as;
            this.field_70126_B = caster.field_70758_at;
            RayTraceResult result = SpellTargetHelper.rayTrace(this, this.field_70170_p, this.func_213303_ch(), caster.func_70040_Z(), true, false, RayTraceContext.BlockMode.COLLIDER, entity -> entity.func_70067_L() && entity.func_70089_S() && entity != caster, caster.func_174813_aQ().func_72314_b((double)range, (double)range, (double)range), range);
            this.lastTickImpact = result.func_216347_e();
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.lastTickBlockPos = ((BlockRayTraceResult)result).func_216350_a();
                this.lastTickBlockFace = ((BlockRayTraceResult)result).func_216354_b();
            } else {
                this.lastTickBlockPos = new BlockPos(this.lastTickImpact);
            }
            this.lastTickMissed = result.func_216346_c() == RayTraceResult.Type.MISS;
        } else {
            this.lastTickMissed = true;
        }
        super.func_70071_h_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, PlayerEntity caster, ServerWorld world) {
        if (this.lastTickMissed || caster == null) {
            return;
        }
        IModifiedSpellPart s = recipe.getShape();
        float radius_h = ((ModifiedSpellPart)s).getValue(Attribute.WIDTH) / 2.0f;
        float radius_v = ((ModifiedSpellPart)s).getValue(Attribute.HEIGHT) / 2.0f;
        float radius_d = ((ModifiedSpellPart)s).getValue(Attribute.DEPTH) * Math.max((float)this.field_70173_aa / 20.0f, 1.0f) / 2.0f;
        SpellSource source = new SpellSource((LivingEntity)caster, caster.func_184600_cs());
        List<Entity> entities = this.targetEntities(this.lastTickImpact, radius_h * 2.0f, radius_v * 2.0f, radius_d);
        BlockPos[] blocks = this.targetBlocks(this.lastTickBlockPos, radius_h, radius_v, radius_d);
        SpellContext context = new SpellContext(world, recipe, this);
        for (Entity e : entities) {
            SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
        }
        for (BlockPos b : blocks) {
            SpellCaster.ApplyComponents(recipe, source, new SpellTarget(b, this.lastTickBlockFace), context);
        }
    }

    @Override
    protected void spawnAirParticles() {
        this.spawnParticles((MAParticleType)ParticleInit.AIR_VELOCITY.get(), 10, 0.1f);
    }

    @Override
    protected void spawnEarthParticles() {
        this.spawnParticles((MAParticleType)ParticleInit.DUST.get(), 5, 0.01f);
        float particle_spread = 0.2f;
        this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.lastTickImpact.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), 0.05, 0.31, 0.12);
    }

    @Override
    protected void spawnFireParticles(boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticles(hellfire ? (MAParticleType)ParticleInit.HELLFIRE.get() : (MAParticleType)ParticleInit.FLAME.get(), 20, 0.01f);
        } else {
            this.spawnLightningParticles((MAParticleType)ParticleInit.LIGHTNING_BOLT.get(), 1);
        }
    }

    @Override
    protected void spawnWaterParticles(boolean frost) {
        this.spawnParticles(frost ? (MAParticleType)ParticleInit.FROST.get() : (MAParticleType)ParticleInit.WATER.get(), 10, 0.01f);
    }

    @Override
    protected void spawnEnderParticles() {
        this.spawnParticles((MAParticleType)ParticleInit.ENDER_VELOCITY.get(), 10, 0.01f);
    }

    @Override
    protected void spawnArcaneParticles() {
        this.spawnParticles((MAParticleType)ParticleInit.ARCANE.get(), 10, 0.01f);
    }

    private void spawnParticles(MAParticleType type, int amount, float velocity) {
        if (this.lastTickMissed) {
            return;
        }
        float particle_spread = 0.2f;
        for (int i = 0; i < amount; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType(type), this.lastTickImpact.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)(-velocity) + Math.random() * (double)velocity * 2.0, (double)(-velocity) + Math.random() * (double)velocity * 2.0, (double)(-velocity) + Math.random() * (double)velocity * 2.0);
        }
    }

    private void spawnLightningParticles(MAParticleType type, int amount) {
        if (this.lastTickMissed) {
            return;
        }
        float particle_spread = 0.5f;
        for (int i = 0; i < amount; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType(type), this.lastTickImpact.field_72450_a, this.lastTickImpact.field_72448_b, this.lastTickImpact.field_72449_c, this.lastTickImpact.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0));
        }
    }

    protected BlockPos[] targetBlocks(BlockPos impactPoint, float radius_h, float radius_v, float radius_d) {
        BlockPos projectedDepthPoint = BlockUtils.Vector3dToBlockPosRound(this.func_70040_Z().func_72432_b().func_186678_a((double)radius_d).func_72441_c((double)impactPoint.func_177958_n(), (double)impactPoint.func_177956_o(), (double)impactPoint.func_177952_p()));
        return this.getAllBlockLocationsDepth(impactPoint, projectedDepthPoint, radius_h, radius_v);
    }

    private BlockPos[] getAllBlockLocationsDepth(BlockPos startPoint, BlockPos endPoint, float radius_h, float radius_v) {
        double radiusOffsetX = Math.cos(Math.toRadians(this.field_70177_z)) * (double)radius_h;
        double radiusOffsetZ = Math.sin(Math.toRadians(this.field_70177_z)) * (double)radius_h;
        ArrayList vecList = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(startPoint, endPoint, pos -> {
            BlockPos[] positions;
            Vector3d a = new Vector3d((double)pos.func_177958_n() + radiusOffsetX, (double)pos.func_177956_o(), (double)pos.func_177952_p() + radiusOffsetZ);
            Vector3d b = new Vector3d((double)pos.func_177958_n() - radiusOffsetX, (double)pos.func_177956_o(), (double)pos.func_177952_p() - radiusOffsetZ);
            for (BlockPos position : positions = this.getAllBlockLocationsHorizontal(BlockUtils.Vector3dToBlockPosRound(a), BlockUtils.Vector3dToBlockPosRound(b))) {
                int y = 0;
                while ((double)y <= Math.floor(radius_v)) {
                    BlockPos vOffset = position.func_177982_a(0, y, 0);
                    if (!vecList.contains(vOffset)) {
                        vecList.add(vOffset);
                    }
                    ++y;
                }
            }
        });
        return vecList.toArray(new BlockPos[0]);
    }

    private BlockPos[] getAllBlockLocationsHorizontal(BlockPos p1, BlockPos p2) {
        ArrayList allPoints = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(p1, p2, pos -> {
            if (!allPoints.contains(pos)) {
                allPoints.add(pos);
            }
        });
        return allPoints.toArray(new BlockPos[0]);
    }

    public int[] getBeamColor() {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return new int[]{255, 255, 255};
        }
        return recipe.getHighestAffinity().getColor();
    }

    protected List<Entity> targetEntities(Vector3d impactPoint, float width, float height, float depth) {
        Vector3d forward = this.func_70040_Z().func_72432_b();
        Vector3d center = impactPoint.func_178787_e(forward.func_186678_a((double)(depth / 2.0f)));
        AxisAlignedBB bb = new AxisAlignedBB(new BlockPos(center)).func_186662_g((double)Math.max(width, Math.max(height, depth)));
        List possibleTargets = this.field_70170_p.func_72839_b((Entity)this.getCaster(), bb);
        ArrayList<Entity> targets = new ArrayList<Entity>();
        float r_width = width / 2.0f;
        float r_height = height / 2.0f;
        float r_depth = depth / 2.0f;
        Vector3d depth_a = impactPoint;
        Vector3d depth_b = impactPoint.func_178787_e(forward.func_186678_a((double)depth));
        Vector3d horizontal_a = center.func_178787_e(forward.func_72431_c(UP).func_186678_a((double)r_width));
        Vector3d horizontal_b = center.func_178787_e(forward.func_72431_c(UP).func_186678_a((double)(-r_width)));
        LineSegment line_horizontal = new LineSegment(horizontal_a, horizontal_b);
        LineSegment line_depth = new LineSegment(depth_a, depth_b);
        for (Entity e : possibleTargets) {
            if (e == this || e == this.getCaster()) continue;
            Vector3d target = e.func_213303_ch();
            Vector3d closest_horizontal = line_horizontal.closestPointOnLine(target);
            Vector3d closest_depth = line_depth.closestPointOnLine(target);
            target = target.func_178786_a(0.0, target.field_72448_b, 0.0);
            closest_horizontal = closest_horizontal.func_178786_a(0.0, closest_horizontal.field_72448_b, 0.0);
            closest_depth = closest_depth.func_178786_a(0.0, closest_depth.field_72448_b, 0.0);
            double depthDist = Math.abs(closest_horizontal.func_72438_d(target));
            double heightDist = Math.abs(center.field_72448_b - e.func_226278_cu_());
            double widthDist = closest_depth.func_72438_d(target);
            if (!(widthDist >= (double)(-r_width)) || !(widthDist <= (double)r_width) || !(heightDist >= (double)(-r_height)) || !(heightDist <= (double)r_height) || !(depthDist >= (double)(-r_depth)) || !(depthDist <= (double)r_depth)) continue;
            targets.add(e);
        }
        return targets;
    }

    public Vector3d getLastTickImpact() {
        return this.lastTickImpact;
    }
}

