/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.ManaAndArtifice;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.particles.bolt.LightningData;
import com.ma.particles.bolt.Segment;
import com.ma.tools.BlockUtils;
import com.ma.tools.math.Vector3;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFlatLandsProjectile
extends Entity {
    private static final DataParameter<BlockPos> START = EntityDataManager.func_187226_a(EntityFlatLandsProjectile.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> END = EntityDataManager.func_187226_a(EntityFlatLandsProjectile.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> SEED = EntityDataManager.func_187226_a(EntityFlatLandsProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PATHINDEX = EntityDataManager.func_187226_a(EntityFlatLandsProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    LightningData pathData;
    int age = 0;
    float interpPct = 0.0f;
    PlayerEntity caster_reference;
    UUID casterID;

    public EntityFlatLandsProjectile(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        ++this.age;
        if (this.age > 200 && !this.field_70170_p.field_72995_K) {
            this.remove(false);
            return;
        }
        PlayerEntity caster = this.getCaster();
        if (this.pathData == null || !this.pathData.isFinal() || caster == null) {
            return;
        }
        ArrayList<Segment> pathSegments = this.pathData.getSegments();
        if (!this.field_70170_p.field_72995_K && ((Integer)this.field_70180_af.func_187225_a(PATHINDEX)).intValue() == pathSegments.size()) {
            BlockPos end = (BlockPos)this.field_70180_af.func_187225_a(END);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos targetPos = end.func_177982_a(i, j, k);
                        if (this.field_70170_p.func_175625_s(targetPos) != null || !BlockUtils.destroyBlock((LivingEntity)caster, this.field_70170_p, targetPos, true, 10, ToolType.AXE, ToolType.HOE, ToolType.PICKAXE, ToolType.SHOVEL)) continue;
                        BlockUtils.updateBlockState(this.field_70170_p, targetPos);
                    }
                }
            }
            this.remove(false);
            return;
        }
        Vector3 start = this.getCurrentStartPoint();
        Vector3 end = this.getCurrentEndPoint();
        Vector3 interp = Vector3.lerp(start, end, this.interpPct);
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        this.func_70634_a(interp.x, interp.y, interp.z);
        this.interpPct += 0.35f;
        if (this.interpPct >= 1.0f) {
            this.interpPct = 0.0f;
            this.field_70180_af.func_187227_b(PATHINDEX, (Object)((Integer)this.field_70180_af.func_187225_a(PATHINDEX) + 1));
        }
    }

    public void spawnParticles(int particleCount, float partialTick) {
        if (this.pathData == null || !this.pathData.isFinal()) {
            return;
        }
        Vector3 start = this.getCurrentStartPoint();
        Vector3 end = this.getCurrentEndPoint();
        Vector3 interp = Vector3.lerp(start, end, this.interpPct + 0.35f * partialTick);
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (double)interp.x + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)interp.y + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)interp.z + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), 0.0, 0.0, 0.0);
        }
    }

    private PlayerEntity getCaster() {
        if (this.caster_reference == null && this.casterID != null) {
            this.caster_reference = this.field_70170_p.func_217371_b(this.casterID);
        }
        return this.caster_reference;
    }

    public Vector3 getCurrentStartPoint() {
        ArrayList<Segment> pathSegments = this.pathData.getSegments();
        int index = (Integer)this.field_70180_af.func_187225_a(PATHINDEX);
        if (index < 0 || index >= pathSegments.size()) {
            return new Vector3(this.func_213303_ch());
        }
        return pathSegments.get(index).getStart();
    }

    public Vector3 getCurrentEndPoint() {
        ArrayList<Segment> pathSegments = this.pathData.getSegments();
        int index = (Integer)this.field_70180_af.func_187225_a(PATHINDEX);
        if (index < 0 || index >= pathSegments.size()) {
            return new Vector3(this.func_213303_ch());
        }
        return pathSegments.get(index).getEnd();
    }

    public void SetSeed(int seed) {
        this.field_70180_af.func_187227_b(SEED, (Object)seed);
        this.calculateFractalPath();
    }

    public void setPoints(BlockPos start, BlockPos end) {
        this.field_70180_af.func_187227_b(START, (Object)start);
        this.field_70180_af.func_187227_b(END, (Object)end);
        this.calculateFractalPath();
    }

    public void setCaster(PlayerEntity caster) {
        this.caster_reference = caster;
    }

    private void calculateFractalPath() {
        this.pathData = new LightningData(new Vector3((BlockPos)this.field_70180_af.func_187225_a(START)), new Vector3((BlockPos)this.field_70180_af.func_187225_a(END)), ((Integer)this.field_70180_af.func_187225_a(SEED)).intValue());
        this.pathData.fractalize();
        this.pathData.finalize();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SEED.equals(key) || START.equals(key) || END.equals(key)) {
            this.calculateFractalPath();
            return;
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(START, (Object)this.func_233580_cy_());
        this.field_70180_af.func_187214_a(END, (Object)this.func_233580_cy_());
        this.field_70180_af.func_187214_a(SEED, (Object)1234);
        this.field_70180_af.func_187214_a(PATHINDEX, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("start_x") && compound.func_74764_b("start_y") && compound.func_74764_b("start_z")) {
            this.field_70180_af.func_187227_b(START, (Object)new BlockPos(compound.func_74762_e("start_x"), compound.func_74762_e("start_y"), compound.func_74762_e("start_z")));
        }
        if (compound.func_74764_b("end_x") && compound.func_74764_b("end_y") && compound.func_74764_b("end_z")) {
            this.field_70180_af.func_187227_b(START, (Object)new BlockPos(compound.func_74762_e("start_x"), compound.func_74762_e("start_y"), compound.func_74762_e("start_z")));
        }
        if (compound.func_74764_b("seed")) {
            this.field_70180_af.func_187227_b(SEED, (Object)compound.func_74762_e("seed"));
        }
        if (compound.func_74764_b("index")) {
            this.field_70180_af.func_187227_b(PATHINDEX, (Object)compound.func_74762_e("index"));
        }
        if (compound.func_74764_b("caster_uuid")) {
            try {
                this.casterID = UUID.fromString(compound.func_74779_i("caster_uuid"));
            }
            catch (Exception e) {
                ManaAndArtifice.LOGGER.error("Error loading caster UUID for flat lands projectile!");
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("start_x", ((BlockPos)this.field_70180_af.func_187225_a(START)).func_177958_n());
        compound.func_74768_a("start_y", ((BlockPos)this.field_70180_af.func_187225_a(START)).func_177956_o());
        compound.func_74768_a("start_z", ((BlockPos)this.field_70180_af.func_187225_a(START)).func_177952_p());
        compound.func_74768_a("end_x", ((BlockPos)this.field_70180_af.func_187225_a(END)).func_177958_n());
        compound.func_74768_a("end_y", ((BlockPos)this.field_70180_af.func_187225_a(END)).func_177956_o());
        compound.func_74768_a("end_z", ((BlockPos)this.field_70180_af.func_187225_a(END)).func_177952_p());
        compound.func_74768_a("seed", ((Integer)this.field_70180_af.func_187225_a(SEED)).intValue());
        compound.func_74768_a("index", ((Integer)this.field_70180_af.func_187225_a(PATHINDEX)).intValue());
        compound.func_74778_a("caster_uuid", this.caster_reference != null ? this.caster_reference.func_110124_au().toString() : "");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }
}

