/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers.ritual;

import com.ma.api.rituals.RitualBlockPos;
import com.ma.entities.rituals.EntityRitual;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.render.MARenderTypes;
import com.ma.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityRitualRenderer
extends EntityRenderer<EntityRitual> {
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static final float FX_Y_OFFSET = 1.2f;
    private int reagentSlotCount = 1;

    public EntityRitualRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(EntityRitual entity) {
        return null;
    }

    public void render(EntityRitual entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean guiding_placement = entityIn.getState() == EntityRitual.RitualState.GUIDING_REAGENT_PLACEMENT;
        NonNullList<RitualBlockPos> rbp = guiding_placement ? entityIn.getRitualData((byte)1) : entityIn.getRitualData((byte)2);
        ArrayList<BlockPos> validPositions = entityIn.getValidReagentLocations();
        float speed = entityIn.getSpeed();
        int radiant_advance_rate = (int)Math.ceil(10.0f * speed);
        int beam_advance_rate = (int)Math.ceil(3.0f * speed);
        int maxPositions = entityIn.getState() == EntityRitual.RitualState.GUIDING_REAGENT_PLACEMENT ? 256 : entityIn.getAge() / radiant_advance_rate;
        int beamAge = entityIn.getAge() - radiant_advance_rate * rbp.size();
        int beamMaximum = 0;
        int iteratorMaximum = Math.min(maxPositions, rbp.size());
        int lastBeamStartIndex = -1;
        if (iteratorMaximum == rbp.size()) {
            beamMaximum = beamAge / beam_advance_rate;
        }
        this.reagentSlotCount = 1;
        for (int i = 0; i < iteratorMaximum; ++i) {
            if (lastBeamStartIndex == -1) {
                lastBeamStartIndex = i;
            }
            BlockPos curPos = ((RitualBlockPos)rbp.get(i)).getBlockPos();
            BlockPos nextPos = null;
            if (!guiding_placement) {
                if (i == iteratorMaximum - 1) {
                    if (entityIn.getCurrentRitual().getConnectBeam()) {
                        nextPos = ((RitualBlockPos)rbp.get(lastBeamStartIndex)).getBlockPos();
                    }
                } else {
                    int curIndex = ((RitualBlockPos)rbp.get(i)).getDisplayIndex();
                    int nextIndex = ((RitualBlockPos)rbp.get(i + 1)).getDisplayIndex();
                    if (nextIndex == curIndex + 1) {
                        nextPos = ((RitualBlockPos)rbp.get(i + 1)).getBlockPos();
                    } else {
                        if (entityIn.getCurrentRitual().getConnectBeam()) {
                            nextPos = ((RitualBlockPos)rbp.get(lastBeamStartIndex)).getBlockPos();
                        }
                        lastBeamStartIndex = i + 1;
                    }
                }
            }
            double xPosCur = (double)curPos.func_177958_n() - entityIn.func_226277_ct_() + 0.5;
            double zPosCur = (double)curPos.func_177952_p() - entityIn.func_226281_cx_() + 0.5;
            if (entityIn.getState() == EntityRitual.RitualState.GUIDING_REAGENT_PLACEMENT) {
                int index = i;
                this.renderReagentPlacementGuide(entityIn, (RitualBlockPos)rbp.get(i), matrixStackIn, xPosCur, zPosCur, bufferIn, packedLightIn, partialTicks, validPositions.stream().anyMatch(p -> p.equals((Object)((RitualBlockPos)rbp.get(index)).getBlockPos())));
                continue;
            }
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(xPosCur, (double)1.2f, zPosCur);
            int alpha = 128;
            if (i == iteratorMaximum - 1 && iteratorMaximum != rbp.size()) {
                float ageTicks = (float)(entityIn.getAge() % radiant_advance_rate) + partialTicks;
                float pct = ageTicks / (float)radiant_advance_rate;
                alpha = (int)(128.0f * pct);
            }
            WorldRenderUtils.renderRadiant(entityIn, matrixStackIn, bufferIn, EntityRitualRenderer.colorsFromLong(entityIn.getCurrentRitual().getInnerColor()), EntityRitualRenderer.colorsFromLong(entityIn.getCurrentRitual().getOuterColor()), alpha, 0.005f);
            if (nextPos != null) {
                double xPosNext = (double)nextPos.func_177958_n() - entityIn.func_226277_ct_() + 0.5;
                double zPosNext = (double)nextPos.func_177952_p() - entityIn.func_226281_cx_() + 0.5;
                if (i < beamMaximum - 1) {
                    WorldRenderUtils.renderBeam(entityIn.field_70170_p, partialTicks, matrixStackIn, bufferIn, packedLightIn, new Vector3d(xPosCur, (double)1.2f, zPosCur), new Vector3d(xPosNext, (double)1.2f, zPosNext), 1.0f, EntityRitualRenderer.colorsFromLong(entityIn.getCurrentRitual().getBeamColor()), MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                } else if (!(i != beamMaximum - 1 || beamMaximum >= rbp.size() && entityIn.getCurrentRitual().getConnectBeam())) {
                    float beamPct = ((float)(beamAge % beam_advance_rate) + partialTicks) / (float)beam_advance_rate;
                    WorldRenderUtils.renderBeam(entityIn.field_70170_p, partialTicks, matrixStackIn, bufferIn, packedLightIn, new Vector3d(xPosCur, (double)1.2f, zPosCur), new Vector3d(xPosNext, (double)1.2f, zPosNext), beamPct, EntityRitualRenderer.colorsFromLong(entityIn.getCurrentRitual().getBeamColor()), MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                }
            }
            matrixStackIn.func_227865_b_();
        }
        if (entityIn.getState() == EntityRitual.RitualState.COLLECTING_PATTERNS) {
            this.renderPatternGuide(entityIn, matrixStackIn, bufferIn);
        }
        this.renderCollectedReagents(entityIn, matrixStackIn, partialTicks, packedLightIn, bufferIn);
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderCollectedReagents(EntityRitual entityIn, MatrixStack matrixStackIn, float partialTicks, int packedLightIn, IRenderTypeBuffer bufferIn) {
        NonNullList<Pair<BlockPos, ItemStack>> collectedReagents = entityIn.getCollectedReagentsByLocation();
        BlockPos pos = entityIn.func_233580_cy_();
        float scale = 0.5f;
        float collapse = 1.0f;
        if (entityIn.getState() == EntityRitual.RitualState.COLLAPSING) {
            collapse = 1.0f - (float)entityIn.getStageTicks() / 20.0f;
        } else if (entityIn.getState().ordinal() > EntityRitual.RitualState.COLLAPSING.ordinal()) {
            return;
        }
        float up = entityIn.getState() == EntityRitual.RitualState.COLLECTING_REAGENTS ? Math.min(((float)entityIn.getStageTicks() + partialTicks) / 20.0f, 1.0f) : 1.0f;
        float rotation = 0.0f;
        rotation = entityIn.getState() == EntityRitual.RitualState.COLLECTING_REAGENTS && entityIn.getStageTicks() <= 20 ? 0.0f : ((float)(entityIn.field_70170_p.func_82737_E() - entityIn.worldTimeAtReagentCollectStart - 20L) + partialTicks) % 360.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)up, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matrixStackIn.func_227862_a_(collapse, collapse, collapse);
        for (Pair e : collectedReagents) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)(((BlockPos)e.getFirst()).func_177958_n() - pos.func_177958_n()), (double)(((BlockPos)e.getFirst()).func_177956_o() - pos.func_177956_o()), (double)(((BlockPos)e.getFirst()).func_177952_p() - pos.func_177952_p()));
            matrixStackIn.func_227862_a_(scale, scale, scale);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            if (((ItemStack)e.getSecond()).func_77973_b() instanceof BlockItem) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotation));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotation));
            }
            this.itemRenderer.func_229110_a_((ItemStack)e.getSecond(), ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderReagentPlacementGuide(EntityRitual entityIn, RitualBlockPos posData, MatrixStack matrixStackIn, double xPosCur, double zPosCur, IRenderTypeBuffer bufferIn, int packedLightIn, float partialTicks, boolean present) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(xPosCur, -0.5, zPosCur);
        if (posData.isPresent() && !posData.getReagent().isDynamic()) {
            ITag tags;
            Item renderItem;
            if (entityIn.getCurrentRitual().getDisplayIndexes()) {
                if (posData.getReagent().isOptional()) {
                    this.func_225629_a_(entityIn, (ITextComponent)new StringTextComponent("" + this.reagentSlotCount++), matrixStackIn, bufferIn, packedLightIn);
                } else {
                    this.func_225629_a_(entityIn, (ITextComponent)new StringTextComponent("" + this.reagentSlotCount++).func_240699_a_(TextFormatting.GOLD), matrixStackIn, bufferIn, packedLightIn);
                }
            }
            if ((renderItem = (Item)ForgeRegistries.ITEMS.getValue(posData.getReagent().getResourceLocation())) == Items.field_190931_a && (tags = ItemTags.func_199903_a().func_199910_a(posData.getReagent().getResourceLocation())) != null && tags.func_230236_b_().size() > 0) {
                renderItem = (Item)tags.func_205596_a(new Random(432L));
            }
            if (renderItem != null) {
                matrixStackIn.func_227861_a_(0.0, (double)1.2f, 0.0);
                matrixStackIn.func_227862_a_(0.3f, 0.3f, 0.3f);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)entityIn.getStageTicks() + partialTicks));
                if (!present) {
                    this.itemRenderer.func_229110_a_(new ItemStack((IItemProvider)renderItem), ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
                }
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderPatternGuide(EntityRitual entityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        Quaternion cameraRotation = this.field_76990_c.func_229098_b_();
        Quaternion patternRotation = new Quaternion(cameraRotation.func_195889_a(), cameraRotation.func_195891_b(), cameraRotation.func_195893_c(), cameraRotation.func_195894_d());
        ManaweavingPattern pattern = entityIn.getRequestedPattern();
        if (pattern != null) {
            WorldRenderUtils.renderManaweavePattern(pattern, patternRotation, matrixStackIn, bufferIn);
        }
    }

    private static int[] colorsFromLong(long packedColor) {
        return new int[]{(int)(packedColor >> 16 & 0xFFL), (int)(packedColor >> 8 & 0xFFL), (int)(packedColor & 0xFFL)};
    }
}

