/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers.player;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.adjusters.SpellAdjustingContext;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.items.sorcery.ItemSpell;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.items.sorcery.ItemStaff;
import com.ma.spells.SpellAdjusters;
import com.ma.spells.crafting.SpellRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class HandParticleLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public HandParticleLayer(IEntityRenderer<T, M> rendererIn) {
        super(rendererIn);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack leftHandItem;
        if (entitylivingbaseIn.func_82150_aj()) {
            return;
        }
        boolean playerIsRightHanded = entitylivingbaseIn.func_184591_cq() == HandSide.RIGHT;
        boolean itemIsInUse = entitylivingbaseIn.func_184605_cv() > 0;
        Hand activeHand = entitylivingbaseIn.func_184600_cs();
        ItemStack rightHandItem = playerIsRightHanded ? entitylivingbaseIn.func_184592_cb() : entitylivingbaseIn.func_184614_ca();
        ItemStack itemStack = leftHandItem = playerIsRightHanded ? entitylivingbaseIn.func_184614_ca() : entitylivingbaseIn.func_184592_cb();
        if (!rightHandItem.func_190926_b() || !leftHandItem.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            if (this.func_215332_c().field_217114_e) {
                matrixStackIn.func_227861_a_(0.0, 0.75, 0.0);
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            if (!itemIsInUse || playerIsRightHanded && activeHand == Hand.OFF_HAND || !playerIsRightHanded && activeHand == Hand.MAIN_HAND) {
                this.renderHandParticle((LivingEntity)entitylivingbaseIn, leftHandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStackIn, bufferIn, packedLightIn);
            }
            if (!itemIsInUse || !playerIsRightHanded && activeHand == Hand.OFF_HAND || playerIsRightHanded && activeHand == Hand.MAIN_HAND) {
                this.renderHandParticle((LivingEntity)entitylivingbaseIn, rightHandItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderHandParticle(LivingEntity living, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide side, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSpell) {
            boolean leftHand;
            matrixStack.func_227860_a_();
            CompoundNBT nbt = living instanceof PlayerEntity ? ((ItemSpell)stack.func_77973_b()).getSpellCompound(stack, (PlayerEntity)living) : new CompoundNBT();
            SpellRecipe recipe = SpellRecipe.fromNBT(nbt);
            Matrix4f curMatrix = matrixStack.func_227866_c_().func_227870_a_();
            Matrix4f inverted = curMatrix.func_226601_d_();
            inverted.func_226600_c_();
            curMatrix.func_226595_a_(inverted);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-living.field_70761_aq));
            matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-90.0f));
            ((IHasArm)this.func_215332_c()).func_225599_a_(side, matrixStack);
            if (stack.func_77973_b() instanceof ItemStaff) {
                matrixStack.func_227861_a_(0.0, 1.5, 0.0);
            } else if (stack.func_77973_b() instanceof ItemSpellBook && ((ItemSpellBook)stack.func_77973_b()).renderBookModel) {
                matrixStack.func_227861_a_(0.0, 0.5, -0.55);
            }
            boolean bl = leftHand = side == HandSide.LEFT;
            if (leftHand) {
                matrixStack.func_227861_a_(0.225, 0.65, -0.95);
            } else {
                matrixStack.func_227861_a_(-0.225, 0.65, -0.95);
            }
            if (living instanceof PlayerEntity && SpellAdjusters.checkHellfireStaff(new SpellAdjustingContext(stack, (PlayerEntity)living, SpellCastStage.CASTING))) {
                SpellAdjusters.modifyHellfireStaff(recipe, (PlayerEntity)living);
            }
            Affinity[] affs = recipe.getAffinity().keySet().toArray(new Affinity[0]);
            this.spawnParticleFromMatrix(affs[(int)(Math.random() * (double)affs.length)], matrixStack, living, transformType);
            matrixStack.func_227865_b_();
        }
    }

    private void spawnParticleFromMatrix(Affinity affinity, MatrixStack matrixStackIn, LivingEntity entitylivingbaseIn, ItemCameraTransforms.TransformType type) {
        Vector3d playerPos = entitylivingbaseIn.func_213303_ch();
        Matrix4f curMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
        Vector3d particlePos = playerPos.func_178787_e(new Vector3d((double)curMatrix.field_226578_d_, (double)curMatrix.field_226582_h_, (double)curMatrix.field_226586_l_));
        switch (affinity) {
            case ARCANE: {
                Vector3d origin = new Vector3d(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                Vector3d offset = new Vector3d(entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian(), entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian(), entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian()).func_72432_b().func_186678_a((double)0.3f);
                origin = origin.func_178787_e(offset);
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_LERP.get())), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                break;
            }
            case EARTH: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, (double)-0.005f + Math.random() * (double)0.01f, (double)0.03f, (double)-0.005f + Math.random() * (double)0.01f);
                break;
            }
            case ENDER: {
                Vector3d origin = new Vector3d(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                Vector3d offset = new Vector3d(entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian(), entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian(), entitylivingbaseIn.field_70170_p.field_73012_v.nextGaussian()).func_72432_b().func_186678_a((double)0.3f);
                origin = origin.func_178787_e(offset);
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                break;
            }
            case FIRE: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                break;
            }
            case HELLFIRE: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                break;
            }
            case LIGHTNING: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, particlePos.field_72450_a - (double)0.4f + Math.random() * (double)0.8f, particlePos.field_72448_b - (double)0.4f + Math.random() * (double)0.8f, particlePos.field_72449_c - (double)0.4f + Math.random() * (double)0.8f);
                break;
            }
            case WATER: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, -0.05 * Math.random() * 0.1, Math.random() * 0.05, -0.05 * Math.random() * 0.1);
                break;
            }
            case ICE: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                break;
            }
            case WIND: {
                entitylivingbaseIn.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, (double)0.3f, (double)0.01f, (double)0.05f);
                break;
            }
        }
    }
}

