/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.utility.WanderingWizardEntity;
import com.ma.tools.RLoc;
import com.ma.tools.render.MARenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class WanderingWizardRenderer
extends MobRenderer<WanderingWizardEntity, VillagerModel<WanderingWizardEntity>> {
    private static final ResourceLocation texture = RLoc.create("textures/entity/villager/wandering_wizard.png");

    public WanderingWizardRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new VillagerModel(0.0f), 0.5f);
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new CrossedArmsItemLayer((IEntityRenderer)this));
    }

    public void render(WanderingWizardEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.field_70173_aa < 60) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MARenderTypes.PORTAL_TEXTURE);
            Quaternion cameraRotation = this.field_76990_c.func_229098_b_();
            Quaternion portalRotation = new Quaternion(0.0f, cameraRotation.func_195891_b(), 0.0f, cameraRotation.func_195894_d());
            float spawnPct = entityIn.field_70173_aa < 20 ? (float)entityIn.field_70173_aa / 20.0f : (entityIn.field_70173_aa < 40 ? 1.0f : (float)(20 - (entityIn.field_70173_aa - 40)) / 20.0f);
            float scaleFactor = 4.0f * spawnPct;
            float portalSpinDegrees = entityIn.field_70173_aa * 3 % 360;
            float verticalOffset = 1.5f;
            int[] colors = new int[]{68, 13, 112};
            IVertexBuilder vertexBuilder = bufferIn.getBuffer(MARenderTypes.PORTAL_RENDER);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)verticalOffset, 0.0);
            matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            matrixStackIn.func_227863_a_(portalRotation);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(portalSpinDegrees));
            matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
            Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
            float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
            float nrmH = (float)Math.cos((double)(portalSpinDegrees - 90.0f) * Math.PI / 180.0);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, colors);
            matrixStackIn.func_227865_b_();
            colors = new int[]{82, 167, 217};
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)verticalOffset, 0.0);
            matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            matrixStackIn.func_227863_a_(portalRotation);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-portalSpinDegrees));
            matrixStackIn.func_227861_a_(0.0, -0.25, (double)0.001f);
            matrixstack$entry = matrixStackIn.func_227866_c_();
            renderMatrix = matrixstack$entry.func_227870_a_();
            normalMatrix = matrixstack$entry.func_227872_b_();
            nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, colors);
            WanderingWizardRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, colors);
            matrixStackIn.func_227865_b_();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTextureLocation(entityIn));
        }
        if (entityIn.field_70173_aa >= 20) {
            super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] rgb) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(rgb[0], rgb[1], rgb[2], 230).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normalMatrix, nrmH, nrmV, nrmH).func_181675_d();
    }

    public ResourceLocation getTextureLocation(WanderingWizardEntity entity) {
        return texture;
    }
}

