/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.constructs.animated.AnimatedConstructConstruction;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.models.constructs.AnimatedConstructModel;
import com.ma.entities.renderers.MAGeckoRenderer;
import com.ma.items.constructs.parts._base.ConstructMaterial;
import com.ma.items.constructs.parts._base.ConstructSlot;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.items.constructs.parts.torso.ConstructPartManaTorso;
import com.ma.tools.math.MathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.geo.render.built.GeoBone;

public class EntityAnimatedConstructRenderer
extends MAGeckoRenderer<EntityAnimatedConstruct> {
    private RenderReferenceStack renderStack = null;
    private float manaPct = 0.0f;
    Matrix4f pos;
    Matrix3f normal;

    public EntityAnimatedConstructRenderer(EntityRendererManager renderManager) {
        super(renderManager, new AnimatedConstructModel());
    }

    @Override
    public RenderType getRenderType(EntityAnimatedConstruct animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228646_f_((ResourceLocation)textureLocation);
    }

    @Override
    public void render(EntityAnimatedConstruct entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        RenderReferenceStack latest;
        this.renderStack = latest = new RenderReferenceStack(bufferIn, this.getTextureLocation((LivingEntity)entityIn), entityIn.func_184614_ca(), entityIn.func_184592_cb());
        latest.model = (AnimatedConstructModel)this.getGeoModelProvider();
        latest.entity = entityIn;
        latest.data = entityIn.getConstructData();
        if (this.getGeoModelProvider() instanceof IAnimatableModel) {
            latest.model.getModel(latest.model.getModelLocation(entityIn));
            Iterator<ConstructMaterial> iterator = latest.data.getComposition().iterator();
            while (iterator.hasNext()) {
                ConstructMaterial matl;
                latest.matl = matl = iterator.next();
                latest.setVisibilityMatrix();
                matrixStackIn.func_227860_a_();
                super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
            }
        }
        entityIn.getConstructData().getPart(ConstructSlot.TORSO).ifPresent(p -> {
            if (p instanceof ConstructPartManaTorso) {
                this.manaPct = entityIn.getManaPct();
                this.renderChargeBar(packedLightIn, ((float)entityIn.field_70173_aa + partialTicks) / 5.0f, latest);
            }
        });
        this.renderHeldItems();
    }

    private void renderChargeBar(int packedLight, float partialTicks, RenderReferenceStack latest) {
        if (latest.rtb == null || this.pos == null || this.normal == null) {
            return;
        }
        float alpha = this.manaPct > 0.2f ? 1.0f : Math.abs((float)Math.sin(partialTicks));
        float[] fullColor = new float[]{0.0f, 1.0f, 0.0f, alpha};
        float[] emptyColor = new float[]{1.0f, 0.0f, 0.0f, alpha};
        float width = 0.05f;
        float min = 0.65f;
        float height = 0.35f;
        IVertexBuilder builder = latest.rtb.getBuffer(RenderType.func_228657_l_());
        float[] rgba = new float[]{MathUtils.lerpf(emptyColor[0], fullColor[0], this.manaPct), MathUtils.lerpf(emptyColor[1], fullColor[1], this.manaPct), MathUtils.lerpf(emptyColor[2], fullColor[2], this.manaPct), MathUtils.lerpf(emptyColor[3], fullColor[3], this.manaPct)};
        Vector3f nrm = new Vector3f(1.0f, 0.0f, 0.0f);
        nrm.func_229188_a_(this.normal);
        builder.func_227888_a_(this.pos, -width, min, 0.0f);
        builder.func_227885_a_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.func_225583_a_(0.0f, 0.0f);
        builder.func_227891_b_(0);
        builder.func_227886_a_(packedLight);
        builder.func_225584_a_(nrm.func_195899_a(), nrm.func_195900_b(), nrm.func_195902_c());
        builder.func_181675_d();
        builder.func_227888_a_(this.pos, width, min, 0.0f);
        builder.func_227885_a_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.func_225583_a_(1.0f, 0.0f);
        builder.func_227891_b_(0);
        builder.func_227886_a_(packedLight);
        builder.func_225584_a_(nrm.func_195899_a(), nrm.func_195900_b(), nrm.func_195902_c());
        builder.func_181675_d();
        builder.func_227888_a_(this.pos, width, min + height * this.manaPct, 0.0f);
        builder.func_227885_a_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.func_225583_a_(1.0f, 1.0f);
        builder.func_227891_b_(0);
        builder.func_227886_a_(packedLight);
        builder.func_225584_a_(nrm.func_195899_a(), nrm.func_195900_b(), nrm.func_195902_c());
        builder.func_181675_d();
        builder.func_227888_a_(this.pos, -width, min + height * this.manaPct, 0.0f);
        builder.func_227885_a_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.func_225583_a_(0.0f, 1.0f);
        builder.func_227891_b_(0);
        builder.func_227886_a_(packedLight);
        builder.func_225584_a_(nrm.func_195899_a(), nrm.func_195900_b(), nrm.func_195902_c());
        builder.func_181675_d();
    }

    private void renderHeldItems() {
        if (this.renderStack.offHandStack != null) {
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.renderStack.offHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.offHandStack, this.renderStack.rtb);
        }
        if (this.renderStack.mainHandStack != null) {
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.renderStack.mainHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.mainHandStack, this.renderStack.rtb);
        }
        this.renderStack.mainHandStack = null;
        this.renderStack.offHandStack = null;
    }

    @Override
    public void renderRecursively(GeoBone arg0, MatrixStack arg1, IVertexBuilder arg2, int arg3, int arg4, float arg5, float arg6, float arg7, float arg8) {
        if (arg0.getName().equals("right_arm_held_item") && !this.renderStack.offHand.func_190926_b()) {
            arg1.func_227860_a_();
            arg1.func_227861_a_(0.38, 0.23, -0.1);
            arg1.func_227862_a_(0.7f, 0.7f, 0.7f);
            this.renderStack.offHandStack = new MatrixStack();
            ((RenderReferenceStack)this.renderStack).offHandStack.field_227859_a_.add(arg1.func_227866_c_());
            this.renderStack.packedLight = arg3;
            this.renderStack.packedOverlay = arg4;
            arg1.func_227865_b_();
        } else if (arg0.getName().equals("left_arm_held_item") && !this.renderStack.mainHand.func_190926_b()) {
            arg1.func_227860_a_();
            arg1.func_227861_a_(-0.38, 0.23, -0.1);
            arg1.func_227862_a_(0.7f, 0.7f, 0.7f);
            this.renderStack.mainHandStack = new MatrixStack();
            ((RenderReferenceStack)this.renderStack).mainHandStack.field_227859_a_.add(arg1.func_227866_c_());
            this.renderStack.packedLight = arg3;
            this.renderStack.packedOverlay = arg4;
            arg1.func_227865_b_();
        } else if (arg0.getName().equals("torso_mana")) {
            arg1.func_227860_a_();
            arg1.func_227861_a_(0.0, 0.0, 0.35);
            this.normal = arg1.func_227866_c_().func_227872_b_();
            this.pos = arg1.func_227866_c_().func_227870_a_();
            arg1.func_227865_b_();
        }
        super.renderRecursively(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public boolean shouldShowName(EntityAnimatedConstruct entity) {
        return super.shouldShowName((LivingEntity)entity);
    }

    protected void renderNameTag(EntityAnimatedConstruct construct, ITextComponent name, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225629_5_) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.35, 0.0);
        super.func_225629_a_((Entity)construct, name, matrixStack, buffer, p_225629_5_);
        matrixStack.func_227865_b_();
    }

    private class RenderReferenceStack {
        public ResourceLocation constructTexture = new ResourceLocation("mana-and-artifice", "textures/entity/animated_construct/stone.png");
        public IRenderTypeBuffer rtb;
        public ItemStack mainHand = ItemStack.field_190927_a;
        public ItemStack offHand = ItemStack.field_190927_a;
        public ConstructMaterial matl;
        public AnimatedConstructModel model;
        public EntityAnimatedConstruct entity;
        public AnimatedConstructConstruction data;
        private MatrixStack mainHandStack = null;
        private MatrixStack offHandStack = null;
        private int packedLight;
        private int packedOverlay;

        public RenderReferenceStack(IRenderTypeBuffer rtb, ResourceLocation texture, ItemStack mainHand, ItemStack offHand) {
            this.rtb = rtb;
            this.constructTexture = texture;
            this.mainHand = mainHand;
            this.offHand = offHand;
        }

        public void setVisibilityMatrix() {
            if (this.model == null || this.data == null || this.matl == null || this.entity == null) {
                return;
            }
            this.model.resetMutexVisibility();
            this.model.setActiveMaterial(this.matl);
            for (ItemConstructPart part : this.data.getPartsForMaterial(this.matl)) {
                this.model.setMutexVisibility(part.getSlot(), part.getModelTypeMutex(), this.entity.getOwner() != null ? this.entity.getOwner().func_110124_au() : null);
            }
        }
    }
}

