/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.DamageTypes;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.ai.RetaliateOnAttackGoal;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityLanternWraith
extends FlyingEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntityLanternWraith>,
IRangedAttackMob,
IFactionEnemy<EntityLanternWraith>,
IEntityAdditionalSpawnData {
    private static final String INSTRUCTION_BOLT = "bolt";
    private static final String INSTRUCTION_AFFECT = "affect";
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private boolean isAttacking = false;
    private PlayerEntity raidTarget;
    private int tier;
    private HashMap<String, Integer> damageResists;

    public EntityLanternWraith(EntityType<? extends FlyingEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70765_h = new MoveHelperController(this);
        this.damageResists = new HashMap();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public static boolean canSpawnPredicate(EntityType<EntityLanternWraith> p_234351_0_, IWorld p_234351_1_, SpawnReason p_234351_2_, BlockPos p_234351_3_, Random p_234351_4_) {
        return p_234351_1_.func_175659_aa() != Difficulty.PEACEFUL && p_234351_1_.func_180495_p(p_234351_3_.func_177977_b()).func_177230_c() != Blocks.field_189878_dg;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.applyInitialSpawnTier((IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.move", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.idle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ModelLanternWraith.attack", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new WraithFlyGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, this.func_233637_b_(Attributes.field_233821_d_), 40, 80, 12.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new RetaliateOnAttackGoal((MobEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, this::factionTargetHelpPredicate));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k() || source == DamageSource.field_76379_h) {
            return false;
        }
        amount = this.applyDamageResists(source, amount);
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SFX.Entity.LanternWraith.HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SFX.Entity.LanternWraith.DEATH;
    }

    public SoundEvent func_184639_G() {
        return SFX.Entity.LanternWraith.IDLE;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.DEMONS;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeFactionData(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readFactionData(compound);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BOLT, 20, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219603_Y, SoundCategory.HOSTILE, 1.0f, (float)(0.9 + Math.random() * 0.2));
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public void spawnSoulFireBolt(Entity target) {
        if (!target.func_70089_S()) {
            return;
        }
        ServerMessageDispatcher.sendParticleSpawn(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.1f, this.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_(), 64.0f, (RegistryKey<World>)this.field_70170_p.func_234923_W_(), (MAParticleType)ParticleInit.WRAITH_BOLT.get());
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Vector3d>(INSTRUCTION_AFFECT, 20, target.func_213303_ch(), this::tryAffectTarget));
    }

    public void tryAffectTarget(String identifier, Vector3d position) {
        LivingEntity entity = this.func_70638_az();
        if (entity == null) {
            return;
        }
        Effect goalEffect = Effects.field_76421_d;
        int duration = 60;
        boolean increaseMagnitude = true;
        if (this.tier >= 2 && entity.func_70660_b((Effect)EffectInit.LIFE_TAP.get()) == null) {
            goalEffect = (Effect)EffectInit.LIFE_TAP.get();
            duration = 200;
            increaseMagnitude = false;
        } else if (this.tier >= 3 && !entity.func_233570_aj_()) {
            goalEffect = (Effect)EffectInit.GRAVITY_WELL.get();
            duration = 100;
            increaseMagnitude = false;
        }
        double dist = entity.func_195048_a(position);
        if (!entity.func_70089_S() || dist > 4.0) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            entity.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().consume(20.0f));
        }
        int magnitude = 0;
        int damage = 5;
        EffectInstance inst = entity.func_70660_b(goalEffect);
        if (inst != null) {
            if (increaseMagnitude) {
                damage += inst.func_76458_c() * 2;
                if ((magnitude += inst.func_76458_c() + 1) > 2) {
                    magnitude = 2;
                }
            } else {
                damage += 5;
            }
        }
        entity.func_195064_c(new EffectInstance(goalEffect, duration, magnitude));
        entity.func_70097_a(DamageTypes.causeSourcedMagicDamage((LivingEntity)this), (float)damage);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "bolt": {
                    this.spawnSoulFireBolt((Entity)entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void executeInstruction(CustomInstructionKeyframeEvent event) {
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tier);
    }

    static class WraithFlyGoal
    extends Goal {
        private final EntityLanternWraith parentEntity;

        public WraithFlyGoal(EntityLanternWraith wraith) {
            this.parentEntity = wraith;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            if (this.parentEntity.func_70638_az() == null) {
                double d2;
                double d1;
                double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = this.parentEntity.func_70638_az().func_70068_e((Entity)this.parentEntity);
            return !this.parentEntity.func_70685_l((Entity)this.parentEntity.func_70638_az()) || dist < 25.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.parentEntity.func_70638_az() == null) {
                Random random = this.parentEntity.func_70681_au();
                double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                int count = 0;
                int y = (int)d1;
                boolean ground = false;
                while (count < 16) {
                    if (this.parentEntity.field_70170_p.func_175623_d(new BlockPos(d0, (double)y, d2))) {
                        ++count;
                        --y;
                        continue;
                    }
                    ground = true;
                    break;
                }
                if (!ground) {
                    d1 -= 16.0;
                }
                this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            } else {
                LivingEntity tgt = this.parentEntity.func_70638_az();
                double dist = this.parentEntity.func_195048_a(tgt.func_213303_ch());
                if (dist < 25.0) {
                    Vector3d direction = this.parentEntity.func_213303_ch().func_178788_d(tgt.func_213303_ch()).func_72432_b();
                    direction = direction.func_72441_c(0.0, -direction.field_72448_b, 0.0);
                    Vector3d offset = direction.func_186678_a(10.0);
                    Vector3d target = tgt.func_213303_ch().func_178787_e(offset).func_72441_c(0.0, 3.0, 0.0);
                    Vector3d vector3d = new Vector3d(target.field_72450_a, 0.0, target.field_72449_c);
                    Vector3d vector3d2 = new Vector3d(tgt.func_226277_ct_(), 0.0, tgt.func_226281_cx_());
                    if (vector3d.func_72438_d(vector3d2) < 2.0) {
                        target = target.func_72441_c(Math.random() * 5.0 - 10.0, 0.0, Math.random() * 5.0 - 10.0);
                    }
                    this.parentEntity.func_70605_aq().func_75642_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, 1.0);
                }
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityLanternWraith parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityLanternWraith wraith) {
            super((MobEntity)wraith);
            this.parentEntity = wraith;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                if (this.parentEntity.func_70638_az() == null) {
                    this.parentEntity.func_200602_a(EntityAnchorArgument.Type.FEET, this.parentEntity.func_213303_ch().func_178787_e(this.parentEntity.func_213322_ci()));
                    if (this.courseChangeCooldown-- <= 0) {
                        this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                        Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                        double d0 = vector3d.func_72433_c();
                        if (this.isCollided(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                            this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                        } else {
                            this.field_188491_h = MovementController.Action.WAIT;
                        }
                    }
                } else {
                    this.parentEntity.func_200602_a(EntityAnchorArgument.Type.FEET, this.parentEntity.func_70638_az().func_213303_ch());
                }
            }
        }

        private boolean isCollided(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }
}

