/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.attributes.AttributeInit;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public class ConstructPatrol
extends ConstructCommand {
    private static final int PATROL_WAIT_TIME = 100;
    private int targetRate = 20;
    private List<BlockPos> patrol_points;
    private int patrolPointIndex = 0;
    private int nextPathWaitTime = 0;

    public ConstructPatrol(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        this.patrol_points = new ArrayList<BlockPos>();
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.patrol_points.size() == 0) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.patrol_no_points", new Object[0]));
        }
        if (this.construct.getConstructData().isAnyCapabilityEnabled(ConstructCapability.MELEE_ATTACK, ConstructCapability.RANGED_ATTACK) && this.construct.field_70170_p.func_82737_E() % (long)this.targetRate == 0L) {
            this.targetNearby();
        }
        if (this.construct.func_70638_az() == null) {
            if (!this.doPatrol()) {
                this.isFinished = true;
                return;
            }
        } else {
            this.doAttackTarget();
        }
    }

    private boolean doPatrol() {
        if (this.patrol_points.size() == 0) {
            return false;
        }
        this.moveBlockTarget = this.patrol_points.get(this.patrolPointIndex);
        if (this.doMove()) {
            if (this.nextPathWaitTime > 0) {
                --this.nextPathWaitTime;
                return true;
            }
            ++this.patrolPointIndex;
            this.nextPathWaitTime = 100;
            if (this.patrolPointIndex >= this.patrol_points.size()) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.patrol_complete", new Object[0]));
                this.isSuccess = true;
                return false;
            }
        }
        return true;
    }

    private void doAttackTarget() {
        if (!this.construct.func_70638_az().func_70089_S()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.victory", this.translate((Entity)this.construct.func_70638_az())));
            this.construct.func_70624_b(null);
            return;
        }
        this.doAttack();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.patrolPointIndex = 0;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.patrolPointIndex = 0;
    }

    private void targetNearby() {
        if (this.owner == null || !this.owner.func_70089_S() || this.construct.func_70638_az() != null && this.construct.func_70638_az().func_70089_S()) {
            return;
        }
        double targetRange = this.construct.func_110148_a((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).func_111126_e();
        List entities = this.construct.field_70170_p.func_217357_a(MobEntity.class, this.construct.func_174813_aQ().func_72314_b(targetRange, 2.0, targetRange)).stream().filter(e -> e.func_70089_S() && (e instanceof IMob || e.func_70638_az() == this.construct.getOwner() || e.func_70643_av() == this.construct.getOwner())).collect(Collectors.toList());
        if (entities.size() == 0) {
            return;
        }
        entities.sort(new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                Double o1Dist = o1.func_70068_e((Entity)ConstructPatrol.this.owner);
                Double o2Dist = o2.func_70068_e((Entity)ConstructPatrol.this.owner);
                return o1Dist.compareTo(o2Dist);
            }
        });
        this.construct.func_70624_b((LivingEntity)((MobEntity)entities.get(0)));
        this.pathCooldown = 0;
        this.moveEntityTarget = this.construct.func_70638_az();
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.attack", this.translate(this.construct.func_70638_az().func_200600_R().func_210760_d(), new Object[0])), false);
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.PATROL;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructPatrol) {
            this.patrol_points.clear();
            this.patrol_points.addAll(((ConstructPatrol)other).patrol_points);
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return new CompoundNBT();
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        this.patrol_points.clear();
        for (int i = 0; i < 4; ++i) {
            ItemStack firstMark = config.func_70301_a(i);
            BlockPos pos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            if (pos == null) continue;
            this.patrol_points.add(pos);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.patrol_points.size() > 0;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(4);
    }
}

