/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.BlockUtils;
import com.ma.tools.MATags;
import com.ma.tools.RLoc;
import com.ma.tools.math.MathUtils;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ToolType;

public class ConstructHarvest
extends ConstructCommand {
    public static final ResourceLocation construct_harvestable = RLoc.create("blocks/construct_harvestables");
    private static final int MAX_SIZE = 32;
    private static final int MAX_BLOCKS_CHECKED_PER_TICK = 50;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.HARVEST};
    private int interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
    private AxisAlignedBB plantArea = null;
    private BlockPos currentPlantTarget = null;
    private NonNullList<BlockPos> knownPlantTargets;
    private int lastPlantLocation = 0;
    private boolean tooBig = false;
    private boolean searchingSurroundings = false;
    int x;
    int y;
    int z;

    public ConstructHarvest(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.knownPlantTargets = NonNullList.func_191196_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.currentPlantTarget == null) {
            this.findBlockTarget();
            return;
        }
        this.moveBlockTarget = this.currentPlantTarget;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
                if (this.interactTimer != 4) {
                    return;
                }
            }
            if (this.construct.field_70170_p.func_195588_v(this.currentPlantTarget)) {
                BlockState state = this.construct.field_70170_p.func_180495_p(this.currentPlantTarget);
                if (this.isValidBlock(state)) {
                    if (this.interactTimer == 4) {
                        this.construct.getHandWithCapability(ConstructCapability.HARVEST).ifPresent(h -> this.construct.func_184609_a((Hand)h));
                        return;
                    }
                    this.harvest();
                } else {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvest_badstate", this.currentPlantTarget.func_177958_n(), this.currentPlantTarget.func_177956_o(), this.currentPlantTarget.func_177952_p(), this.translate(state)));
                    this.knownPlantTargets.remove((Object)this.currentPlantTarget);
                    this.lastPlantLocation = 0;
                    this.currentPlantTarget = null;
                    this.isFinished = true;
                }
            }
        }
    }

    private void harvest() {
        BlockState state = this.construct.field_70170_p.func_180495_p(this.currentPlantTarget);
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvesting", this.translate(state), this.currentPlantTarget.func_177958_n(), this.currentPlantTarget.func_177956_o(), this.currentPlantTarget.func_177952_p()));
        BlockUtils.destroyBlock((LivingEntity)(this.construct.getOwner() != null ? this.construct.getOwner() : this.construct), this.construct.field_70170_p, this.currentPlantTarget, true, 99, ToolType.HOE, ToolType.SHOVEL, ToolType.AXE, ToolType.SHOVEL);
        this.knownPlantTargets.remove((Object)this.currentPlantTarget);
        this.lastPlantLocation = 0;
        this.currentPlantTarget = null;
        this.isFinished = true;
    }

    private boolean isValidBlock(BlockState state) {
        boolean valid;
        boolean no_age = MATags.isBlockIn(state.func_177230_c(), RLoc.create("construct_harvestables_no_age"));
        boolean bl = valid = no_age || MATags.isBlockIn(state.func_177230_c(), RLoc.create("construct_harvestables"));
        if (state.func_177230_c() instanceof CropsBlock) {
            valid &= ((CropsBlock)state.func_177230_c()).func_185525_y(state);
        } else {
            Optional<IntegerProperty> ageProp = state.func_235904_r_().stream().filter(p -> p.func_177701_a() == "age").map(p -> (IntegerProperty)p).findFirst();
            if (ageProp.isPresent() && !no_age) {
                valid &= state.func_177229_b((Property)ageProp.get()) == ageProp.get().func_177700_c().stream().max(Integer::compare).get();
            }
        }
        return valid;
    }

    private void findBlockTarget() {
        if (this.plantArea == null) {
            return;
        }
        if (!this.searchingSurroundings && this.knownPlantTargets.size() == 0) {
            this.setupRecheck();
        }
        if (this.searchingSurroundings) {
            this.searchSurroundings();
        } else {
            this.pickPlantLocation();
        }
    }

    private void setupRecheck() {
        this.searchingSurroundings = true;
        this.knownPlantTargets.clear();
        this.lastPlantLocation = 0;
        this.x = (int)this.plantArea.field_72340_a;
        this.y = (int)this.plantArea.field_72338_b;
        this.z = (int)this.plantArea.field_72339_c;
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvest_scan_starting", new Object[0]));
    }

    private void searchSurroundings() {
        int count = 0;
        while ((double)this.x < this.plantArea.field_72336_d) {
            while ((double)this.y < this.plantArea.field_72337_e) {
                while ((double)this.z < this.plantArea.field_72334_f) {
                    BlockPos curSearch = new BlockPos(this.x, this.y, this.z);
                    if (this.construct.field_70170_p.func_195588_v(curSearch) && this.isValidBlock(this.construct.field_70170_p.func_180495_p(curSearch))) {
                        this.knownPlantTargets.add((Object)curSearch);
                    }
                    if (++count >= 50) {
                        return;
                    }
                    ++this.z;
                }
                this.z = (int)this.plantArea.field_72339_c;
                ++this.y;
            }
            this.y = (int)this.plantArea.field_72338_b;
            ++this.x;
        }
        this.searchingSurroundings = false;
        if (this.knownPlantTargets.size() == 0) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvest_scan_no_results", new Object[0]));
            this.isFinished = true;
            return;
        }
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvest_scan_success", new Object[0]));
    }

    private void pickPlantLocation() {
        int count = 0;
        if (this.knownPlantTargets.size() == 0) {
            this.isFinished = true;
            return;
        }
        while (this.lastPlantLocation < this.knownPlantTargets.size()) {
            BlockPos curSearch = (BlockPos)this.knownPlantTargets.get(this.lastPlantLocation);
            if (this.construct.field_70170_p.func_195588_v(curSearch)) {
                if (this.isValidBlock(this.construct.field_70170_p.func_180495_p(curSearch))) {
                    this.currentPlantTarget = curSearch;
                    return;
                }
                this.knownPlantTargets.remove(this.lastPlantLocation);
                --this.lastPlantLocation;
            }
            if (++count >= 50) {
                return;
            }
            ++this.lastPlantLocation;
        }
        this.lastPlantLocation = 0;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.plantArea == null) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.harvest_not_configured", new Object[0]), false);
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.plantArea.func_216364_b(), this.plantArea.func_216360_c(), this.plantArea.func_216362_d()), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        AxisAlignedBB prevPlantArea = this.plantArea;
        this.plantArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.plantArea = MathUtils.createInclusiveBB(firstPos, secondPos);
                if (this.plantArea.func_216364_b() > 32.0 || this.plantArea.func_216360_c() > 32.0 || this.plantArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
        if (this.plantArea != null && !this.plantArea.equals((Object)prevPlantArea)) {
            this.knownPlantTargets.clear();
        }
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.HARVEST;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
    }

    @Override
    public boolean isFullyConfigured() {
        return this.plantArea != null;
    }
}

