/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.boss.attacks;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.DamageTypes;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.boss.EntityOdin;
import com.ma.items.ItemInit;
import com.ma.tools.SummonUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class AllfatherAxeThrownEntity
extends DamagingProjectileEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> IS_RETURNING = EntityDataManager.func_187226_a(AllfatherAxeThrownEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final ItemStack renderStack = new ItemStack((IItemProvider)ItemInit.ALLFATHER_AXE.get());
    private CompoundNBT itemData;

    public AllfatherAxeThrownEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public AllfatherAxeThrownEntity(LivingEntity shooter, World worldIn, CompoundNBT data) {
        this(worldIn, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
        this.func_212361_a((Entity)shooter);
        this.itemData = data;
    }

    public AllfatherAxeThrownEntity(World worldIn, double x, double y, double z) {
        super((EntityType)EntityInit.ALLFATHER_AXE.get(), worldIn);
        this.func_70107_b(x, y, z);
        this.func_189654_d(true);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d Vector3d2 = new Vector3d(x, y, z).func_72432_b().func_186678_a((double)velocity);
        this.func_213317_d(Vector3d2);
        float f = MathHelper.func_76133_a((double)AllfatherAxeThrownEntity.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_213868_a(EntityRayTraceResult ray) {
        Entity hitEntity = ray.func_216348_a();
        if (!this.isValidEntity(hitEntity)) {
            return;
        }
        LivingEntity livingHit = (LivingEntity)hitEntity;
        Entity eOwner = this.func_234616_v_();
        if (!(eOwner instanceof LivingEntity)) {
            return;
        }
        if (livingHit == eOwner) {
            if (this.field_70170_p.field_72995_K || !this.isReturning()) {
                return;
            }
            ItemStack returnStack = new ItemStack((IItemProvider)ItemInit.ALLFATHER_AXE.get());
            returnStack.func_77982_d(this.itemData);
            if (livingHit instanceof PlayerEntity) {
                if (((PlayerEntity)livingHit).func_191521_c(returnStack)) {
                    this.func_70106_y();
                } else {
                    this.drop();
                }
            } else if (livingHit instanceof EntityOdin) {
                ((EntityOdin)livingHit).showAxe();
                this.func_70106_y();
            } else {
                this.func_70106_y();
            }
            return;
        }
        livingHit.func_70097_a(DamageTypes.causeSourcedFrostDamage((LivingEntity)this.func_234616_v_()), 15.0f);
        livingHit.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 100));
    }

    protected void func_230299_a_(BlockRayTraceResult ray) {
    }

    protected void func_191955_a(BlockState state) {
        BlockState blockstate = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        if (blockstate.func_177230_c() == Blocks.field_150355_j) {
            this.field_70170_p.func_180501_a(this.func_233580_cy_(), Blocks.field_150432_aD.func_176223_P(), 3);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_RETURNING, (Object)0);
    }

    protected IParticleData func_195057_f() {
        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMaxAge(0);
    }

    public void func_70071_h_() {
        Entity owner = this.func_234616_v_();
        if (owner == null || !owner.func_70089_S()) {
            this.drop();
            return;
        }
        if (this.field_70173_aa >= 20 && !this.isReturning()) {
            this.setReturning();
        }
        if (this.isReturning()) {
            this.func_213317_d(owner.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(this.func_213303_ch()).func_72432_b());
        }
        if (this.field_70170_p.field_72995_K) {
            Vector3d dm = this.func_213322_ci();
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setScale(0.05f).setGravity(0.01f).setPhysics(true), this.func_226277_ct_() + Math.random() * dm.field_72450_a, this.func_226278_cu_() + Math.random() * dm.field_72448_b, this.func_226281_cx_() + Math.random() * dm.field_72449_c, 0.0, 0.0, 0.0);
        }
        if (this.field_70148_d) {
            this.func_184185_a(SFX.Spell.Cast.ICE, 0.05f, 1.0f);
            this.func_184185_a(SFX.Entity.SkeletonAssassin.BOLO_THROW, 0.75f, 0.5f);
        }
        super.func_70071_h_();
    }

    protected float func_82341_c() {
        return 0.95f;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    private void drop() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemEntity ie = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack((IItemProvider)ItemInit.ALLFATHER_AXE.get()));
        ie.func_213317_d(this.func_213322_ci());
        this.field_70170_p.func_217376_c((Entity)ie);
        this.func_70106_y();
    }

    private boolean isReturning() {
        return (Byte)this.field_70180_af.func_187225_a(IS_RETURNING) == 1;
    }

    private void setReturning() {
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)1);
        this.field_70232_b = -this.field_70232_b;
        this.field_70233_c = -this.field_70233_c;
        this.field_70230_d = -this.field_70230_d;
    }

    private boolean isValidEntity(Entity e) {
        LazyOptional op;
        if (!(e instanceof LivingEntity)) {
            return false;
        }
        Entity shooter = this.func_234616_v_();
        if (shooter == null) {
            return false;
        }
        if (!(shooter instanceof PlayerEntity)) {
            return true;
        }
        PlayerEntity player = (PlayerEntity)shooter;
        if (SummonUtils.isSummon((LivingEntity)e) && SummonUtils.getSummoner((LivingEntity)e) == player) {
            return false;
        }
        if (e instanceof IFactionEnemy && (op = player.getCapability(PlayerProgressionProvider.PROGRESSION)).isPresent()) {
            Faction playerFaction = ((IPlayerProgression)op.resolve().get()).getAlliedFaction();
            if (((IFactionEnemy)e).getFaction() == ((IPlayerProgression)op.resolve().get()).getAlliedFaction()) {
                return false;
            }
        }
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.func_234616_v_() != null) {
            buffer.writeInt(this.func_234616_v_().func_145782_y());
        } else {
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int ownerID = additionalData.readInt();
        if (ownerID > -1) {
            Entity owner = this.field_70170_p.func_73045_a(ownerID);
            this.func_212361_a(owner);
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70039_c(CompoundNBT nbt) {
        if (this.itemData != null) {
            nbt.func_218657_a("itemData", (INBT)this.itemData);
        }
        return super.func_70039_c(nbt);
    }

    public void func_70020_e(CompoundNBT nbt) {
        super.func_70020_e(nbt);
        if (nbt.func_74764_b("itemData")) {
            this.itemData = nbt.func_74775_l("itemData");
        }
    }
}

