/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.boss;

import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.boss.BossMonster;
import com.ma.entities.boss.attacks.PumpkinKingEntangleEntity;
import com.ma.entities.boss.attacks.PumpkinKingIncinerateEntity;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class EntityPumpkinKing
extends BossMonster<EntityPumpkinKing>
implements IEntityAdditionalSpawnData,
IAnimPacketSync<EntityPumpkinKing> {
    private final ServerBossInfo bossEvent = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<PlayerEntity> randomPlayerFlyable = p -> p.field_71075_bZ.field_75100_b || !p.func_233570_aj_();
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_ENTANGLE = "entangle";
    private static final String INSTRUCTION_INCINERATE = "incinerate";
    private static final int ENTANGLE_CD = 300;
    private static final int INCINERATE_CD = 300;
    private static final int ATTACK_CD = 20;
    private int entangleCooldown = 0;
    private int incinerateCooldown = 0;
    private int attackCooldown = 0;
    private boolean isAttacking = false;
    private boolean leftHandPunch = false;
    private boolean isEntangling = false;
    private boolean isIncinerating = false;

    public EntityPumpkinKing(EntityType<? extends EntityPumpkinKing> type, World world) {
        super(type, world);
    }

    public EntityPumpkinKing(World world) {
        this((EntityType<? extends EntityPumpkinKing>)((EntityType)EntityInit.PUMPKIN_KING.get()), world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BossMonster.DoNothingGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new EntangleGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new IncinerateGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, (double)0.35f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, le -> true));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        --this.entangleCooldown;
        --this.incinerateCooldown;
        --this.attackCooldown;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isAttacking || this.attackCooldown > 0) {
            return true;
        }
        this.func_184185_a(SFX.Entity.PumpkinKing.ATTACK, this.func_70599_aP(), this.func_70647_i());
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 10, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 15, "", this::handleDelayCallback));
        this.isAttacking = true;
        this.leftHandPunch = Math.random() < 0.5;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        return true;
    }

    @Override
    protected ServerBossInfo getBossEvent() {
        return this.bossEvent;
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            block5 : switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                    break;
                }
                case "incinerate": {
                    PlayerEntity player;
                    ArrayList<PlayerEntity> attacked = new ArrayList<PlayerEntity>();
                    for (int i = 0; i < 10 && (player = this.getRandomNearbyPlayer(null)) != null; ++i) {
                        if (!attacked.contains(player)) {
                            this.spawnIncinerate(player);
                            attacked.add(player);
                        }
                        if (attacked.size() >= 4 || attacked.size() == this.field_70170_p.func_217369_A().size()) break block5;
                    }
                    break;
                }
                case "entangle": {
                    PlayerEntity player = this.getRandomNearbyPlayer(randomPlayerFlyable);
                    if (player == null) break;
                    this.spawnEntangle(player);
                }
            }
        }
    }

    private void spawnIncinerate(PlayerEntity player) {
        PumpkinKingIncinerateEntity incinerate = new PumpkinKingIncinerateEntity(this.field_70170_p);
        incinerate.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        this.field_70170_p.func_217376_c((Entity)incinerate);
    }

    private void spawnEntangle(PlayerEntity player) {
        BlockPos spawnPos = player.func_233580_cy_();
        int offsetAmount = 10;
        spawnPos = spawnPos.func_177982_a(-offsetAmount + (int)(Math.random() * (double)offsetAmount * 2.0), 0, -offsetAmount + (int)(Math.random() * (double)offsetAmount * 2.0));
        while (spawnPos.func_177956_o() > 0 && this.field_70170_p.func_175623_d(spawnPos)) {
            spawnPos = spawnPos.func_177977_b();
        }
        spawnPos = spawnPos.func_177984_a();
        PumpkinKingEntangleEntity entangle = new PumpkinKingEntangleEntity(this.field_70170_p);
        entangle.func_70107_b((float)spawnPos.func_177958_n() + 0.5f, spawnPos.func_177956_o(), (float)spawnPos.func_177952_p() + 0.5f);
        entangle.setTarget(player);
        this.field_70170_p.func_217376_c((Entity)entangle);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity;
                this.maybeDisableShield(playerentity, (playerentity = (PlayerEntity)entityIn).func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
            if (this.field_70146_Z.nextFloat() < 0.4f && entityIn instanceof MobEntity) {
                ((MobEntity)entityIn).func_70624_b((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(PlayerEntity player, ItemStack playerItem) {
        if (!playerItem.func_190926_b() && playerItem.func_77973_b().isShield(playerItem, (LivingEntity)player)) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                player.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isAttacking = false;
            if (this.isEntangling) {
                this.entangleCooldown = 300;
                if (this.incinerateCooldown <= 0) {
                    this.incinerateCooldown = 37;
                }
                this.isEntangling = false;
            } else if (this.isIncinerating) {
                this.incinerateCooldown = 300;
                this.isIncinerating = false;
            } else {
                this.attackCooldown = 20;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isAttacking);
        nbt.func_74757_a("entangling", this.isEntangling);
        nbt.func_74757_a("incinerating", this.isIncinerating);
        nbt.func_74757_a("left_hand_punch", this.leftHandPunch);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isAttacking = nbt.func_74767_n("attacking");
        this.isEntangling = nbt.func_74767_n("entangling");
        this.isIncinerating = nbt.func_74767_n("incinerating");
        this.leftHandPunch = nbt.func_74767_n("left_hand_punch");
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(79);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
        this.func_184185_a(SFX.Entity.PumpkinKing.SPAWN, this.func_70599_aP(), this.func_70647_i());
    }

    protected SoundEvent func_184639_G() {
        return SFX.Entity.PumpkinKing.IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SFX.Entity.PumpkinKing.DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SFX.Entity.PumpkinKing.HURT;
    }

    @Override
    public boolean func_70097_a(DamageSource type, float amount) {
        if (this.getInvulnerableTicks() > 0 && type != DamageSource.field_76380_i) {
            return false;
        }
        if (type == DamageSource.field_191291_g || type == DamageSource.field_76371_c || type == DamageSource.field_76368_d) {
            this.func_70106_y();
            return false;
        }
        if (type.func_76355_l().equals("ma-frost")) {
            amount *= 2.0f;
        }
        if (type.func_76347_k()) {
            amount = (float)((double)amount * 0.5);
        }
        return super.func_70097_a(type, amount);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulnerableTicks() > 0) {
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 <= 0) {
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_175669_a(1023, this.func_233580_cy_(), 0);
                }
                this.func_70691_i(this.func_110138_aP());
            }
            this.setInvulnerableTicks(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(25.0f);
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getInvulnerableTicks() > 0) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.spawn", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().transitionLengthTicks = 2.0;
        if (!this.isAttacking) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.idle", Boolean.valueOf(true)));
            }
        } else if (this.isIncinerating) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.incinerate", Boolean.valueOf(false)));
        } else if (this.isEntangling) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.entangle", Boolean.valueOf(false)));
        } else if (this.leftHandPunch) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.swipe_left", Boolean.valueOf(false)).addAnimation("animation.PumpkinKing.idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.PumpkinKing.swipe_right", Boolean.valueOf(false)).addAnimation("animation.PumpkinKing.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, (double)0.6f).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.field_70177_z = additionalData.readFloat();
        this.field_70126_B = additionalData.readFloat();
        this.field_70125_A = additionalData.readFloat();
        this.field_70127_C = additionalData.readFloat();
        this.field_70761_aq = this.field_70177_z;
        this.field_70760_ar = this.field_70126_B;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.field_70177_z);
        buffer.writeFloat(this.field_70126_B);
        buffer.writeFloat(this.field_70125_A);
        buffer.writeFloat(this.field_70127_C);
    }

    public class EntangleGoal
    extends Goal {
        public EntangleGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityPumpkinKing.this.entangleCooldown <= 0 && EntityPumpkinKing.this.func_70638_az() != null && !EntityPumpkinKing.this.isAttacking && EntityPumpkinKing.this.incinerateCooldown <= 0;
        }

        public void func_75249_e() {
            EntityPumpkinKing.this.func_70661_as().func_75499_g();
            EntityPumpkinKing.this.isEntangling = true;
            EntityPumpkinKing.this.isAttacking = true;
            EntityPumpkinKing.this.func_184185_a(SFX.Entity.PumpkinKing.ENTANGLE, EntityPumpkinKing.this.func_70599_aP(), EntityPumpkinKing.this.func_70647_i());
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityPumpkinKing.INSTRUCTION_ENTANGLE, 15, (LivingEntity)EntityPumpkinKing.this, (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityPumpkinKing.INSTRUCTION_ENTANGLE, 25, (LivingEntity)EntityPumpkinKing.this, (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityPumpkinKing.INSTRUCTION_ENTANGLE, 35, (LivingEntity)EntityPumpkinKing.this, (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityPumpkinKing.INSTRUCTION_ENTANGLE, 45, (LivingEntity)EntityPumpkinKing.this, (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 60, "", (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityPumpkinKing.this);
        }

        public boolean func_75253_b() {
            return EntityPumpkinKing.this.isEntangling;
        }
    }

    public class IncinerateGoal
    extends Goal {
        public IncinerateGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityPumpkinKing.this.incinerateCooldown <= 0 && EntityPumpkinKing.this.func_70638_az() != null && !EntityPumpkinKing.this.isAttacking;
        }

        public void func_75249_e() {
            EntityPumpkinKing.this.func_70661_as().func_75499_g();
            EntityPumpkinKing.this.isIncinerating = true;
            EntityPumpkinKing.this.isAttacking = true;
            EntityPumpkinKing.this.func_184185_a(SFX.Entity.PumpkinKing.INCINERATE, EntityPumpkinKing.this.func_70599_aP(), EntityPumpkinKing.this.func_70647_i());
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntityPumpkinKing.INSTRUCTION_INCINERATE, 65, (LivingEntity)EntityPumpkinKing.this, (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityPumpkinKing.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 82, "", (x$0, x$1) -> EntityPumpkinKing.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntityPumpkinKing.this);
        }

        public boolean func_75253_b() {
            return EntityPumpkinKing.this.isIncinerating;
        }
    }
}

