/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.ai;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class ThreatTable {
    private static final int THREAT_STEAL_THRESHOLD = 10;
    private Map<Integer, Float> threat = Maps.newHashMap();

    public void addThreat(LivingEntity attacker, float amount, LivingEntity currentTarget) {
        if (attacker == null) {
            return;
        }
        float newThreat = this.threat.getOrDefault(attacker.func_145782_y(), Float.valueOf(0.0f)).floatValue() + amount;
        this.threat.put(attacker.func_145782_y(), Float.valueOf(newThreat));
    }

    public void initializeThreat(LivingEntity attacker) {
        if (attacker == null) {
            return;
        }
        if (!this.threat.containsKey(attacker.func_145782_y())) {
            this.threat.put(attacker.func_145782_y(), Float.valueOf(1.0f));
        }
    }

    public boolean shouldSwitchTarget(LivingEntity currentTarget, LivingEntity potentialTarget) {
        if (currentTarget == null || !currentTarget.func_70089_S()) {
            return true;
        }
        if (potentialTarget == null || !potentialTarget.func_70089_S()) {
            return false;
        }
        if (currentTarget.func_145782_y() == potentialTarget.func_145782_y()) {
            return false;
        }
        float currentThreat = this.threat.getOrDefault(currentTarget.func_145782_y(), Float.valueOf(0.0f)).floatValue();
        float targetThreat = this.threat.getOrDefault(potentialTarget.func_145782_y(), Float.valueOf(0.0f)).floatValue();
        return targetThreat >= currentThreat + 10.0f;
    }

    public int getRandomThreatEntry(World world, LivingEntity owner, double maxTargetDist) {
        ArrayList allKeys = new ArrayList();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        double maxDistSquared = maxTargetDist * maxTargetDist;
        this.threat.keySet().forEach((? super T entityID) -> {
            Entity e = world.func_73045_a(entityID.intValue());
            if (e == null || !e.func_70089_S() || !(e instanceof LivingEntity)) {
                toRemove.add((Integer)entityID);
                return;
            }
            if (e.func_213303_ch().func_72436_e(owner.func_213303_ch()) < maxDistSquared) {
                allKeys.add(entityID);
            }
        });
        toRemove.forEach((? super E i) -> this.threat.remove(i));
        if (allKeys.size() == 0) {
            return -1;
        }
        return (Integer)allKeys.get((int)(Math.random() * (double)allKeys.size()));
    }

    @Nullable
    private Pair<Integer, Float> getHighestThreatTarget() {
        if (this.threat.size() == 0) {
            return null;
        }
        MutableInt highestID = new MutableInt(-1);
        MutableFloat highestThreat = new MutableFloat(-1.0f);
        this.threat.forEach((? super K k, ? super V v) -> {
            if (highestID.getValue() == -1 || highestThreat.getValue().floatValue() < v.floatValue()) {
                highestID.setValue((Number)k);
                highestThreat.setValue((Number)v);
            }
        });
        return new Pair((Object)highestID.getValue(), (Object)highestThreat.getValue());
    }

    public void forEach(BiConsumer<Integer, Float> callback) {
        this.threat.forEach(callback);
    }
}

