/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities;

import com.ma.ManaAndArtifice;
import com.ma.entities.state.EntityStateMachine;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.world.World;

public abstract class LivingUtilityEntity
extends LivingEntity {
    protected static final DataParameter<String> CASTER_UUID = EntityDataManager.func_187226_a(LivingUtilityEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(LivingUtilityEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<String> CURRENT_ANIMATION = EntityDataManager.func_187226_a(LivingUtilityEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<String> CURRENT_SEQUENCE = EntityDataManager.func_187226_a(LivingUtilityEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected int stateTicks = 0;
    protected float lastTickAnimationPct;
    protected int lastAnimationChangeTimer = 0;
    protected float animationPct;
    protected EntityStateMachine<LivingUtilityEntity> stateMachine = new EntityStateMachine<LivingUtilityEntity>(this, CURRENT_SEQUENCE);
    protected PlayerEntity caster;

    protected LivingUtilityEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.func_174810_b(false);
        this.func_184224_h(true);
        this.field_70145_X = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.stateTicks;
        ++this.lastAnimationChangeTimer;
        this.lastTickAnimationPct = this.animationPct;
        if (this.caster == null) {
            this.caster = this.getCaster();
        }
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_205710_ba() {
        return false;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CASTER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(STATE, (Object)0);
        this.field_70180_af.func_187214_a(CURRENT_ANIMATION, (Object)"neutral");
        this.field_70180_af.func_187214_a(CURRENT_SEQUENCE, (Object)"");
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("caster", (String)this.field_70180_af.func_187225_a(CASTER_UUID));
        compound.func_74774_a("state", this.getState());
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("caster")) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)compound.func_74779_i("caster"));
        }
        if (compound.func_74764_b("state")) {
            this.field_70180_af.func_187227_b(STATE, (Object)compound.func_74771_c("state"));
        }
    }

    @Nullable
    protected PlayerEntity getCaster() {
        UUID caster = this.getCasterUUID();
        if (caster != null) {
            return this.field_70170_p.func_217371_b(caster);
        }
        return null;
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.field_70180_af.func_187225_a(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    protected void setState(byte state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
        this.stateTicks = 0;
    }

    public byte getState() {
        return (Byte)this.field_70180_af.func_187225_a(STATE);
    }

    public float getAnimationPct(float partialTicks) {
        return MathUtils.lerpf(this.lastTickAnimationPct, this.animationPct, partialTicks);
    }

    public void setCurrentAnimation(String anim) {
        this.field_70180_af.func_187227_b(CURRENT_ANIMATION, (Object)anim);
        this.lastAnimationChangeTimer = 0;
        this.lastTickAnimationPct = 0.0f;
        this.animationPct = 0.0f;
    }

    public String getCurrentAnimation() {
        return (String)this.field_70180_af.func_187225_a(CURRENT_ANIMATION);
    }

    public int getLastAnimChangeTimer() {
        return this.lastAnimationChangeTimer;
    }

    protected void enableFlightFor(PlayerEntity player) {
        if (player == null) {
            return;
        }
        player.func_189654_d(true);
        ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
    }

    protected void disableFlightFor(PlayerEntity player) {
        if (player == null) {
            return;
        }
        player.func_189654_d(false);
        ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
    }
}

