/*
 * Decompiled with CFR 0.152.
 */
package com.ma.enchantments;

import com.ma.effects.EffectInit;
import com.ma.enchantments.Beheading;
import com.ma.enchantments.Bouncing;
import com.ma.enchantments.Cloudstep;
import com.ma.enchantments.Fireproof;
import com.ma.enchantments.Gilded;
import com.ma.enchantments.TransitoryStep;
import com.ma.enchantments.auras.Aura;
import com.ma.network.ClientMessageDispatcher;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnchantmentInit {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"mana-and-artifice");
    public static final RegistryObject<Aura> HEALING = ENCHANTMENTS.register("aura-healing", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(Effects.field_76428_l).withManaCost(10.0f).withPredicate(p -> p.func_110143_aJ() <= p.func_110138_aP() * 0.75f && p.func_70660_b(Effects.field_76428_l) == null));
    public static final RegistryObject<Aura> RUNNING = ENCHANTMENTS.register("aura-running", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(Effects.field_76424_c).withMagnitude(3).withManaCost(0.075f).withPredicate(p -> !p.func_70644_a((Effect)EffectInit.PILGRIM.get())));
    public static final RegistryObject<Aura> PILGRIM = ENCHANTMENTS.register("aura-pilgrim", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(EffectInit.PILGRIM).withMagnitude(0).withManaCost(0.075f).withPredicate(p -> !p.func_70644_a(Effects.field_76424_c)));
    public static final RegistryObject<Aura> JUMPING = ENCHANTMENTS.register("aura-jumping", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(Effects.field_76430_j).withMagnitude(5).withManaCost(0.075f));
    public static final RegistryObject<Aura> WATER_BREATHING = ENCHANTMENTS.register("aura-depths", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(Effects.field_205136_C).withManaCost(0.075f).withPredicate(p -> p.func_203005_aq()));
    public static final RegistryObject<Aura> MINING_BOOST = ENCHANTMENTS.register("aura-mining", () -> new Aura(Enchantment.Rarity.UNCOMMON).withEffect(Effects.field_76422_e).withMagnitude(3).withManaCost(0.05f));
    public static final RegistryObject<Aura> REPAIR = ENCHANTMENTS.register("aura-repair", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(EffectInit.REPAIR).withManaCost(0.25f).withPredicate(p -> {
        for (int i = 0; i < p.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = p.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !stack.isRepairable() || !stack.func_77951_h()) continue;
            return true;
        }
        return false;
    }));
    public static final RegistryObject<Bouncing> BOUNCING = ENCHANTMENTS.register("bouncing", () -> new Bouncing(Enchantment.Rarity.COMMON));
    public static final RegistryObject<Cloudstep> LEAPING = ENCHANTMENTS.register("cloudstep", () -> new Cloudstep(Enchantment.Rarity.COMMON));
    public static final RegistryObject<Beheading> BEHEADING = ENCHANTMENTS.register("beheading", () -> new Beheading());
    public static final RegistryObject<TransitoryStep> TRANSITORY_STEP = ENCHANTMENTS.register("transitorystep", () -> new TransitoryStep(Enchantment.Rarity.RARE));
    public static final RegistryObject<Gilded> GILDED = ENCHANTMENTS.register("gilded", () -> new Gilded());
    public static final RegistryObject<Fireproof> FIREPROOF = ENCHANTMENTS.register("fireproof", () -> new Fireproof());

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.func_82737_E() % 5L == 0L) {
            EnchantmentInit.tickAuras(event.player, event.player.field_70170_p.field_72995_K || event.player.field_70170_p.func_82737_E() % 60L != 0L);
        }
        ItemStack boots = event.player.func_184582_a(EquipmentSlotType.FEET);
        if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)TRANSITORY_STEP.get()), (ItemStack)boots) > 0) {
            ((TransitoryStep)TRANSITORY_STEP.get()).apply(event.player, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerFall(LivingFallEvent event) {
        ItemStack boots;
        PlayerEntity player;
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity && event.getDistance() > 2.0f && !(player = (PlayerEntity)event.getEntityLiving()).func_225608_bj_() && player.func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) == null && !(boots = player.func_184582_a(EquipmentSlotType.FEET)).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)BOUNCING.get()), (ItemStack)boots) > 0) {
            event.setCanceled(true);
            if (player.field_70170_p.field_72995_K) {
                float maxVelocity = 4.0f;
                float bounceVelocity = (float)(player.func_213322_ci().field_72448_b * (double)-0.9f);
                Vector3d velocity = new Vector3d(player.func_213322_ci().field_72450_a, (double)Math.min(maxVelocity, bounceVelocity), player.func_213322_ci().field_72449_c);
                player.func_213293_j(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                ClientMessageDispatcher.sendPlayerBounce(velocity);
            }
        }
    }

    private static void tickAuras(PlayerEntity player, boolean manaOnly) {
        for (ItemStack armorStack : player.func_184193_aE()) {
            if (armorStack.func_190926_b()) continue;
            for (RegistryObject enchantment : ENCHANTMENTS.getEntries()) {
                int level;
                if (!(enchantment.get() instanceof Aura) || (level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)enchantment.get()), (ItemStack)armorStack)) <= 0) continue;
                ((Aura)enchantment.get()).apply(player, level, manaOnly);
            }
        }
    }
}

