/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.config.GeneralModConfig;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class SpellModConfig {
    private static HashMap<CompoundConfigKey, ForgeConfigSpec.DoubleValue> _configs = new HashMap();
    private static HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<String>> _dimensionBlacklists = new HashMap();
    private static HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<String>> _biomeBlacklists = new HashMap();

    public static void initForPart(ForgeConfigSpec.Builder serverBuilder, ISpellComponent shape, AttributeValuePair ... pairs) {
        String key = shape.getRegistryName().toString();
        serverBuilder.push(key);
        _biomeBlacklists.put(shape.getRegistryName(), (ForgeConfigSpec.ConfigValue<String>)serverBuilder.comment("Biome Blacklists - Biomes that this spell part cannot be cast in. Comma separated, no spaces.").define("biomeBlacklists", (Object)""));
        _dimensionBlacklists.put(shape.getRegistryName(), (ForgeConfigSpec.ConfigValue<String>)serverBuilder.comment("Dimension Blacklists - Dimensions that this spell part cannot be cast in. Comma separated, no spaces.").define("dimensionBlacklists", (Object)""));
        for (AttributeValuePair pair : pairs) {
            serverBuilder.push(pair.getAttribute().name());
            _configs.put(new CompoundConfigKey(shape, pair.getAttribute(), Value.MINIMUM), serverBuilder.comment("Minimum Value").defineInRange("minimum", (double)pair.getMinimum(), 0.0, 9999.0));
            _configs.put(new CompoundConfigKey(shape, pair.getAttribute(), Value.MAXIMUM), serverBuilder.comment("Maximum Value").defineInRange("maximum", (double)pair.getMaximum(), 0.0, 9999.0));
            _configs.put(new CompoundConfigKey(shape, pair.getAttribute(), Value.DEFAULT), serverBuilder.comment("Default Value").defineInRange("default", (double)pair.getDefaultValue(), 0.0, 9999.0));
            _configs.put(new CompoundConfigKey(shape, pair.getAttribute(), Value.STEP), serverBuilder.comment("Step Value (how much does one click in the inscription table change the value)").defineInRange("step", (double)pair.getStep(), 0.0, 9999.0));
            _configs.put(new CompoundConfigKey(shape, pair.getAttribute(), Value.COMPLEXITY), serverBuilder.comment("Complexity Value (how much does changing by one tick change the complexity)").defineInRange("step_complexity", (double)pair.getStepComplexity(), 0.0, 9999.0));
            serverBuilder.pop();
        }
        serverBuilder.pop();
    }

    public static float getConfiguredValue(ISpellComponent part, Attribute attribute, Value value, float defaultValue) {
        CompoundConfigKey key = new CompoundConfigKey(part, attribute, value);
        if (_configs.containsKey(key)) {
            return ((Double)_configs.get(key).get()).floatValue();
        }
        return defaultValue;
    }

    public static boolean isDimensionBlacklisted(ISpellComponent part, ResourceLocation dimensionID) {
        if (((String)GeneralModConfig.MA_SPELL_DIMENSION_BLACKLIST.get()).contains(dimensionID.toString())) {
            return false;
        }
        if (_dimensionBlacklists.containsKey(part.getRegistryName())) {
            return ((String)_dimensionBlacklists.get(part.getRegistryName()).get()).contains(dimensionID.toString());
        }
        return false;
    }

    public static boolean isBiomeBlacklisted(ISpellComponent part, ResourceLocation biomeID) {
        if (((String)GeneralModConfig.MA_SPELL_BIOME_BLACKLIST.get()).contains(biomeID.toString())) {
            return false;
        }
        if (_biomeBlacklists.containsKey(part.getRegistryName())) {
            return ((String)_biomeBlacklists.get(part.getRegistryName()).get()).contains(biomeID.toString());
        }
        return false;
    }

    public static class CompoundConfigKey {
        private ISpellComponent object;
        private Attribute attr;
        private Value value;

        public CompoundConfigKey(ISpellComponent object, Attribute attr, Value value) {
            this.object = object;
            this.attr = attr;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundConfigKey) {
                CompoundConfigKey other = (CompoundConfigKey)obj;
                return this.attr == other.attr && this.value == other.value && this.object.equals(other.object);
            }
            return false;
        }

        public int hashCode() {
            return this.object.hashCode() + this.attr.hashCode() + this.value.hashCode();
        }
    }

    public static enum Value {
        MINIMUM,
        MAXIMUM,
        DEFAULT,
        STEP,
        COMPLEXITY;

    }
}

